/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9JavaLangManagementData
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9JavaLangManagementData {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _counterPathOffset_;
	public static final int _currentNumberOfCPUsOffset_;
	public static final int _currentProcessingCapacityOffset_;
	public static final int _currentTotalPhysicalMemoryOffset_;
	public static final int _dlparNotificationCountOffset_;
	public static final int _dlparNotificationMonitorOffset_;
	public static final int _dlparNotificationQueueOffset_;
	public static final int _dlparNotificationsPendingOffset_;
	public static final int _garbageCollectorsOffset_;
	public static final int _gcCurrentThreadsOffset_;
	public static final int _gcMainCpuTimeOffset_;
	public static final int _gcMaxThreadsOffset_;
	public static final int _gcWorkerCpuTimeOffset_;
	public static final int _initialHeapSizeOffset_;
	public static final int _isCounterPathInitializedOffset_;
	public static final int _isCurrentThreadCpuTimeSupportedOffset_;
	public static final int _isThreadCpuTimeSupportedOffset_;
	public static final int _lastCompilationStartOffset_;
	public static final int _lastGCIDOffset_;
	public static final int _liveJavaDaemonThreadsOffset_;
	public static final int _liveJavaThreadsOffset_;
	public static final int _managementDataLockOffset_;
	public static final int _maximumHeapSizeOffset_;
	public static final int _memoryPoolsOffset_;
	public static final int _nonHeapMemoryPoolsOffset_;
	public static final int _notificationCountOffset_;
	public static final int _notificationEnabledOffset_;
	public static final int _notificationMonitorOffset_;
	public static final int _notificationQueueOffset_;
	public static final int _notificationsPendingOffset_;
	public static final int _peakLiveJavaThreadsOffset_;
	public static final int _postCollectionHeapSizeOffset_;
	public static final int _postCollectionHeapUsedOffset_;
	public static final int _preCollectionHeapSizeOffset_;
	public static final int _preCollectionHeapUsedOffset_;
	public static final int _supportedCollectorsOffset_;
	public static final int _supportedMemoryPoolsOffset_;
	public static final int _supportedNonHeapMemoryPoolsOffset_;
	public static final int _threadContentionMonitoringFlagOffset_;
	public static final int _threadCpuTimeEnabledFlagOffset_;
	public static final int _threadsCompilingOffset_;
	public static final int _totalClassLoadsOffset_;
	public static final int _totalClassUnloadsOffset_;
	public static final int _totalCompilationTimeOffset_;
	public static final int _totalJavaThreadsStartedOffset_;
	public static final int _vmStartTimeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_counterPathOffset_ = 0;
		_currentNumberOfCPUsOffset_ = 0;
		_currentProcessingCapacityOffset_ = 0;
		_currentTotalPhysicalMemoryOffset_ = 0;
		_dlparNotificationCountOffset_ = 0;
		_dlparNotificationMonitorOffset_ = 0;
		_dlparNotificationQueueOffset_ = 0;
		_dlparNotificationsPendingOffset_ = 0;
		_garbageCollectorsOffset_ = 0;
		_gcCurrentThreadsOffset_ = 0;
		_gcMainCpuTimeOffset_ = 0;
		_gcMaxThreadsOffset_ = 0;
		_gcWorkerCpuTimeOffset_ = 0;
		_initialHeapSizeOffset_ = 0;
		_isCounterPathInitializedOffset_ = 0;
		_isCurrentThreadCpuTimeSupportedOffset_ = 0;
		_isThreadCpuTimeSupportedOffset_ = 0;
		_lastCompilationStartOffset_ = 0;
		_lastGCIDOffset_ = 0;
		_liveJavaDaemonThreadsOffset_ = 0;
		_liveJavaThreadsOffset_ = 0;
		_managementDataLockOffset_ = 0;
		_maximumHeapSizeOffset_ = 0;
		_memoryPoolsOffset_ = 0;
		_nonHeapMemoryPoolsOffset_ = 0;
		_notificationCountOffset_ = 0;
		_notificationEnabledOffset_ = 0;
		_notificationMonitorOffset_ = 0;
		_notificationQueueOffset_ = 0;
		_notificationsPendingOffset_ = 0;
		_peakLiveJavaThreadsOffset_ = 0;
		_postCollectionHeapSizeOffset_ = 0;
		_postCollectionHeapUsedOffset_ = 0;
		_preCollectionHeapSizeOffset_ = 0;
		_preCollectionHeapUsedOffset_ = 0;
		_supportedCollectorsOffset_ = 0;
		_supportedMemoryPoolsOffset_ = 0;
		_supportedNonHeapMemoryPoolsOffset_ = 0;
		_threadContentionMonitoringFlagOffset_ = 0;
		_threadCpuTimeEnabledFlagOffset_ = 0;
		_threadsCompilingOffset_ = 0;
		_totalClassLoadsOffset_ = 0;
		_totalClassUnloadsOffset_ = 0;
		_totalCompilationTimeOffset_ = 0;
		_totalJavaThreadsStartedOffset_ = 0;
		_vmStartTimeOffset_ = 0;
	}

}
