/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: jvmtiAddrLocationMapPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the jvmtiAddrLocationMapPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=jvmtiAddrLocationMap.class)
public class jvmtiAddrLocationMapPointer extends StructurePointer {

	// NULL
	public static final jvmtiAddrLocationMapPointer NULL = new jvmtiAddrLocationMapPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected jvmtiAddrLocationMapPointer(long address) {
		super(address);
	}

	public static jvmtiAddrLocationMapPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static jvmtiAddrLocationMapPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static jvmtiAddrLocationMapPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new jvmtiAddrLocationMapPointer(address);
	}

	public jvmtiAddrLocationMapPointer add(long count) {
		return jvmtiAddrLocationMapPointer.cast(address + (jvmtiAddrLocationMap.SIZEOF * count));
	}

	public jvmtiAddrLocationMapPointer add(Scalar count) {
		return add(count.longValue());
	}

	public jvmtiAddrLocationMapPointer addOffset(long offset) {
		return jvmtiAddrLocationMapPointer.cast(address + offset);
	}

	public jvmtiAddrLocationMapPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public jvmtiAddrLocationMapPointer sub(long count) {
		return jvmtiAddrLocationMapPointer.cast(address - (jvmtiAddrLocationMap.SIZEOF * count));
	}

	public jvmtiAddrLocationMapPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public jvmtiAddrLocationMapPointer subOffset(long offset) {
		return jvmtiAddrLocationMapPointer.cast(address - offset);
	}

	public jvmtiAddrLocationMapPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public jvmtiAddrLocationMapPointer untag(long mask) {
		return jvmtiAddrLocationMapPointer.cast(address & ~mask);
	}

	public jvmtiAddrLocationMapPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return jvmtiAddrLocationMap.SIZEOF;
	}

	// Implementation methods

	// jlocation location
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_locationOffset_", declaredType="jlocation")
	public IDATA location() throws CorruptDataException {
		return new I64(getLongAtOffset(jvmtiAddrLocationMap._locationOffset_));
	}

	// jlocation location
	public IDATAPointer locationEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(jvmtiAddrLocationMap._locationOffset_));
	}

	// const void* start_address
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_start_addressOffset_", declaredType="const void*")
	public VoidPointer start_address() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(jvmtiAddrLocationMap._start_addressOffset_));
	}

	// const void* start_address
	public PointerPointer start_addressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiAddrLocationMap._start_addressOffset_));
	}

}
