/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_GCExtensionsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_GCExtensionsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_GCExtensions.class)
public class MM_GCExtensionsPointer extends MM_GCExtensionsBasePointer {

	// NULL
	public static final MM_GCExtensionsPointer NULL = new MM_GCExtensionsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_GCExtensionsPointer(long address) {
		super(address);
	}

	public static MM_GCExtensionsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_GCExtensionsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_GCExtensionsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_GCExtensionsPointer(address);
	}

	public MM_GCExtensionsPointer add(long count) {
		return MM_GCExtensionsPointer.cast(address + (MM_GCExtensions.SIZEOF * count));
	}

	public MM_GCExtensionsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_GCExtensionsPointer addOffset(long offset) {
		return MM_GCExtensionsPointer.cast(address + offset);
	}

	public MM_GCExtensionsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_GCExtensionsPointer sub(long count) {
		return MM_GCExtensionsPointer.cast(address - (MM_GCExtensions.SIZEOF * count));
	}

	public MM_GCExtensionsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_GCExtensionsPointer subOffset(long offset) {
		return MM_GCExtensionsPointer.cast(address - offset);
	}

	public MM_GCExtensionsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_GCExtensionsPointer untag(long mask) {
		return MM_GCExtensionsPointer.cast(address & ~mask);
	}

	public MM_GCExtensionsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_GCExtensions.SIZEOF;
	}

	// Implementation methods

	// bool _HeapManagementMXBeanBackCompatibilityEnabled
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__HeapManagementMXBeanBackCompatibilityEnabledOffset_", declaredType="bool")
	public boolean _HeapManagementMXBeanBackCompatibilityEnabled() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions.__HeapManagementMXBeanBackCompatibilityEnabledOffset_);
	}

	// bool _HeapManagementMXBeanBackCompatibilityEnabled
	public BoolPointer _HeapManagementMXBeanBackCompatibilityEnabledEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions.__HeapManagementMXBeanBackCompatibilityEnabledOffset_));
	}

	// I64 _TLHAsyncCallbackKey
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__TLHAsyncCallbackKeyOffset_", declaredType="I64")
	public IDATA _TLHAsyncCallbackKey() throws CorruptDataException {
		return new I64(getLongAtOffset(MM_GCExtensions.__TLHAsyncCallbackKeyOffset_));
	}

	// I64 _TLHAsyncCallbackKey
	public IDATAPointer _TLHAsyncCallbackKeyEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(MM_GCExtensions.__TLHAsyncCallbackKeyOffset_));
	}

	// I64 _asyncCallbackKey
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__asyncCallbackKeyOffset_", declaredType="I64")
	public IDATA _asyncCallbackKey() throws CorruptDataException {
		return new I64(getLongAtOffset(MM_GCExtensions.__asyncCallbackKeyOffset_));
	}

	// I64 _asyncCallbackKey
	public IDATAPointer _asyncCallbackKeyEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(MM_GCExtensions.__asyncCallbackKeyOffset_));
	}

	// U32 _stringTableListToTreeThreshold
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__stringTableListToTreeThresholdOffset_", declaredType="U32")
	public UDATA _stringTableListToTreeThreshold() throws CorruptDataException {
		return new U32(getIntAtOffset(MM_GCExtensions.__stringTableListToTreeThresholdOffset_));
	}

	// U32 _stringTableListToTreeThreshold
	public UDATAPointer _stringTableListToTreeThresholdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions.__stringTableListToTreeThresholdOffset_));
	}

	// MM_ObjectAccessBarrier* accessBarrier
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_accessBarrierOffset_", declaredType="MM_ObjectAccessBarrier*")
	public MM_ObjectAccessBarrierPointer accessBarrier() throws CorruptDataException {
		return MM_ObjectAccessBarrierPointer.cast(getPointerAtOffset(MM_GCExtensions._accessBarrierOffset_));
	}

	// MM_ObjectAccessBarrier* accessBarrier
	public PointerPointer accessBarrierEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._accessBarrierOffset_));
	}

	// MM_ClassLoaderManager* classLoaderManager
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classLoaderManagerOffset_", declaredType="MM_ClassLoaderManager*")
	public MM_ClassLoaderManagerPointer classLoaderManager() throws CorruptDataException {
		return MM_ClassLoaderManagerPointer.cast(getPointerAtOffset(MM_GCExtensions._classLoaderManagerOffset_));
	}

	// MM_ClassLoaderManager* classLoaderManager
	public PointerPointer classLoaderManagerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._classLoaderManagerOffset_));
	}

	// double classUnloadingAnonymousClassWeight
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classUnloadingAnonymousClassWeightOffset_", declaredType="double")
	public double classUnloadingAnonymousClassWeight() throws CorruptDataException {
		return getDoubleAtOffset(MM_GCExtensions._classUnloadingAnonymousClassWeightOffset_);
	}

	// double classUnloadingAnonymousClassWeight
	public DoublePointer classUnloadingAnonymousClassWeightEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(MM_GCExtensions._classUnloadingAnonymousClassWeightOffset_));
	}

	// bool collectStringConstants
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_collectStringConstantsOffset_", declaredType="bool")
	public boolean collectStringConstants() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._collectStringConstantsOffset_);
	}

	// bool collectStringConstants
	public BoolPointer collectStringConstantsEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._collectStringConstantsOffset_));
	}

	// MM_GCExtensions$ContinuationListOption continuationListOption
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_continuationListOptionOffset_", declaredType="MM_GCExtensions$ContinuationListOption")
	public long continuationListOption() throws CorruptDataException {
		if (MM_GCExtensions$ContinuationListOption.SIZEOF == 1) {
			return getByteAtOffset(MM_GCExtensions._continuationListOptionOffset_);
		} else if (MM_GCExtensions$ContinuationListOption.SIZEOF == 2) {
			return getShortAtOffset(MM_GCExtensions._continuationListOptionOffset_);
		} else if (MM_GCExtensions$ContinuationListOption.SIZEOF == 4) {
			return getIntAtOffset(MM_GCExtensions._continuationListOptionOffset_);
		} else if (MM_GCExtensions$ContinuationListOption.SIZEOF == 8) {
			return getLongAtOffset(MM_GCExtensions._continuationListOptionOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// MM_GCExtensions$ContinuationListOption continuationListOption
	public EnumPointer continuationListOptionEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(MM_GCExtensions._continuationListOptionOffset_), MM_GCExtensions$ContinuationListOption.class);
	}

	// MM_ContinuationObjectList* continuationObjectLists
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_continuationObjectListsOffset_", declaredType="MM_ContinuationObjectList*")
	public MM_ContinuationObjectListPointer continuationObjectLists() throws CorruptDataException, NoSuchFieldException {
	try {
		return MM_ContinuationObjectListPointer.cast(getPointerAtOffset(MM_GCExtensions._continuationObjectListsOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// MM_ContinuationObjectList* continuationObjectLists
	public PointerPointer continuationObjectListsEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._continuationObjectListsOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// MM_ContinuationStats continuationStats
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_continuationStatsOffset_", declaredType="MM_ContinuationStats")
	public MM_ContinuationStatsPointer continuationStats() throws CorruptDataException {
		return MM_ContinuationStatsPointer.cast(nonNullFieldEA(MM_GCExtensions._continuationStatsOffset_));
	}

	// MM_ContinuationStats continuationStats
	public PointerPointer continuationStatsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._continuationStatsOffset_));
	}

	// U64 deadClassLoaderCacheSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_deadClassLoaderCacheSizeOffset_", declaredType="U64")
	public UDATA deadClassLoaderCacheSize() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._deadClassLoaderCacheSizeOffset_));
	}

	// U64 deadClassLoaderCacheSize
	public UDATAPointer deadClassLoaderCacheSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._deadClassLoaderCacheSizeOffset_));
	}

	// MM_GCExtensions$DynamicClassUnloading dynamicClassUnloading
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dynamicClassUnloadingOffset_", declaredType="MM_GCExtensions$DynamicClassUnloading")
	public long dynamicClassUnloading() throws CorruptDataException {
		if (MM_GCExtensions$DynamicClassUnloading.SIZEOF == 1) {
			return getByteAtOffset(MM_GCExtensions._dynamicClassUnloadingOffset_);
		} else if (MM_GCExtensions$DynamicClassUnloading.SIZEOF == 2) {
			return getShortAtOffset(MM_GCExtensions._dynamicClassUnloadingOffset_);
		} else if (MM_GCExtensions$DynamicClassUnloading.SIZEOF == 4) {
			return getIntAtOffset(MM_GCExtensions._dynamicClassUnloadingOffset_);
		} else if (MM_GCExtensions$DynamicClassUnloading.SIZEOF == 8) {
			return getLongAtOffset(MM_GCExtensions._dynamicClassUnloadingOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// MM_GCExtensions$DynamicClassUnloading dynamicClassUnloading
	public EnumPointer dynamicClassUnloadingEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(MM_GCExtensions._dynamicClassUnloadingOffset_), MM_GCExtensions$DynamicClassUnloading.class);
	}

	// U64 dynamicClassUnloadingKickoffThreshold
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dynamicClassUnloadingKickoffThresholdOffset_", declaredType="U64")
	public UDATA dynamicClassUnloadingKickoffThreshold() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._dynamicClassUnloadingKickoffThresholdOffset_));
	}

	// U64 dynamicClassUnloadingKickoffThreshold
	public UDATAPointer dynamicClassUnloadingKickoffThresholdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._dynamicClassUnloadingKickoffThresholdOffset_));
	}

	// bool dynamicClassUnloadingKickoffThresholdForced
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dynamicClassUnloadingKickoffThresholdForcedOffset_", declaredType="bool")
	public boolean dynamicClassUnloadingKickoffThresholdForced() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._dynamicClassUnloadingKickoffThresholdForcedOffset_);
	}

	// bool dynamicClassUnloadingKickoffThresholdForced
	public BoolPointer dynamicClassUnloadingKickoffThresholdForcedEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._dynamicClassUnloadingKickoffThresholdForcedOffset_));
	}

	// bool dynamicClassUnloadingSet
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dynamicClassUnloadingSetOffset_", declaredType="bool")
	public boolean dynamicClassUnloadingSet() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._dynamicClassUnloadingSetOffset_);
	}

	// bool dynamicClassUnloadingSet
	public BoolPointer dynamicClassUnloadingSetEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._dynamicClassUnloadingSetOffset_));
	}

	// U64 dynamicClassUnloadingThreshold
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dynamicClassUnloadingThresholdOffset_", declaredType="U64")
	public UDATA dynamicClassUnloadingThreshold() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._dynamicClassUnloadingThresholdOffset_));
	}

	// U64 dynamicClassUnloadingThreshold
	public UDATAPointer dynamicClassUnloadingThresholdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._dynamicClassUnloadingThresholdOffset_));
	}

	// bool dynamicClassUnloadingThresholdForced
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dynamicClassUnloadingThresholdForcedOffset_", declaredType="bool")
	public boolean dynamicClassUnloadingThresholdForced() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._dynamicClassUnloadingThresholdForcedOffset_);
	}

	// bool dynamicClassUnloadingThresholdForced
	public BoolPointer dynamicClassUnloadingThresholdForcedEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._dynamicClassUnloadingThresholdForcedOffset_));
	}

	// bool dynamicHeapAdjustmentForRestore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dynamicHeapAdjustmentForRestoreOffset_", declaredType="bool")
	public boolean dynamicHeapAdjustmentForRestore() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._dynamicHeapAdjustmentForRestoreOffset_);
	}

	// bool dynamicHeapAdjustmentForRestore
	public BoolPointer dynamicHeapAdjustmentForRestoreEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._dynamicHeapAdjustmentForRestoreOffset_));
	}

	// U64 dynamicMaxSoftReferenceAge
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dynamicMaxSoftReferenceAgeOffset_", declaredType="U64")
	public UDATA dynamicMaxSoftReferenceAge() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._dynamicMaxSoftReferenceAgeOffset_));
	}

	// U64 dynamicMaxSoftReferenceAge
	public UDATAPointer dynamicMaxSoftReferenceAgeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._dynamicMaxSoftReferenceAgeOffset_));
	}

	// bool enableOriginalJDK8HeapSizeCompatibilityOption
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_enableOriginalJDK8HeapSizeCompatibilityOptionOffset_", declaredType="bool")
	public boolean enableOriginalJDK8HeapSizeCompatibilityOption() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._enableOriginalJDK8HeapSizeCompatibilityOptionOffset_);
	}

	// bool enableOriginalJDK8HeapSizeCompatibilityOption
	public BoolPointer enableOriginalJDK8HeapSizeCompatibilityOptionEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._enableOriginalJDK8HeapSizeCompatibilityOptionOffset_));
	}

	// I64 finalizeCycleInterval
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_finalizeCycleIntervalOffset_", declaredType="I64")
	public IDATA finalizeCycleInterval() throws CorruptDataException {
		return new I64(getLongAtOffset(MM_GCExtensions._finalizeCycleIntervalOffset_));
	}

	// I64 finalizeCycleInterval
	public IDATAPointer finalizeCycleIntervalEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._finalizeCycleIntervalOffset_));
	}

	// I64 finalizeCycleLimit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_finalizeCycleLimitOffset_", declaredType="I64")
	public IDATA finalizeCycleLimit() throws CorruptDataException {
		return new I64(getLongAtOffset(MM_GCExtensions._finalizeCycleLimitOffset_));
	}

	// I64 finalizeCycleLimit
	public IDATAPointer finalizeCycleLimitEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._finalizeCycleLimitOffset_));
	}

	// GC_FinalizeListManager* finalizeListManager
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_finalizeListManagerOffset_", declaredType="GC_FinalizeListManager*")
	public GC_FinalizeListManagerPointer finalizeListManager() throws CorruptDataException {
		return GC_FinalizeListManagerPointer.cast(getPointerAtOffset(MM_GCExtensions._finalizeListManagerOffset_));
	}

	// GC_FinalizeListManager* finalizeListManager
	public PointerPointer finalizeListManagerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._finalizeListManagerOffset_));
	}

	// U64 finalizeMainPriority
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_finalizeMainPriorityOffset_", declaredType="U64")
	public UDATA finalizeMainPriority() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._finalizeMainPriorityOffset_));
	}

	// U64 finalizeMainPriority
	public UDATAPointer finalizeMainPriorityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._finalizeMainPriorityOffset_));
	}

	// U64 finalizeWorkerPriority
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_finalizeWorkerPriorityOffset_", declaredType="U64")
	public UDATA finalizeWorkerPriority() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._finalizeWorkerPriorityOffset_));
	}

	// U64 finalizeWorkerPriority
	public UDATAPointer finalizeWorkerPriorityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._finalizeWorkerPriorityOffset_));
	}

	// bool forceGPFOnHeapInitializationError
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_forceGPFOnHeapInitializationErrorOffset_", declaredType="bool")
	public boolean forceGPFOnHeapInitializationError() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._forceGPFOnHeapInitializationErrorOffset_);
	}

	// bool forceGPFOnHeapInitializationError
	public BoolPointer forceGPFOnHeapInitializationErrorEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._forceGPFOnHeapInitializationErrorOffset_));
	}

	// U64 freeSizeThresholdForSurvivor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_freeSizeThresholdForSurvivorOffset_", declaredType="U64")
	public UDATA freeSizeThresholdForSurvivor() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._freeSizeThresholdForSurvivorOffset_));
	}

	// U64 freeSizeThresholdForSurvivor
	public UDATAPointer freeSizeThresholdForSurvivorEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._freeSizeThresholdForSurvivorOffset_));
	}

	// bool fvtest_forceFinalizeClassLoaders
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fvtest_forceFinalizeClassLoadersOffset_", declaredType="bool")
	public boolean fvtest_forceFinalizeClassLoaders() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._fvtest_forceFinalizeClassLoadersOffset_);
	}

	// bool fvtest_forceFinalizeClassLoaders
	public BoolPointer fvtest_forceFinalizeClassLoadersEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._fvtest_forceFinalizeClassLoadersOffset_));
	}

	// void* gcchkExtensions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gcchkExtensionsOffset_", declaredType="void*")
	public VoidPointer gcchkExtensions() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(MM_GCExtensions._gcchkExtensionsOffset_));
	}

	// void* gcchkExtensions
	public PointerPointer gcchkExtensionsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._gcchkExtensionsOffset_));
	}

	// MM_HookInterface hookInterface
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hookInterfaceOffset_", declaredType="MM_HookInterface")
	public MM_HookInterfacePointer hookInterface() throws CorruptDataException {
		return MM_HookInterfacePointer.cast(nonNullFieldEA(MM_GCExtensions._hookInterfaceOffset_));
	}

	// MM_HookInterface hookInterface
	public PointerPointer hookInterfaceEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._hookInterfaceOffset_));
	}

	// MM_IdleGCManager* idleGCManager
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idleGCManagerOffset_", declaredType="MM_IdleGCManager*")
	public MM_IdleGCManagerPointer idleGCManager() throws CorruptDataException {
		return MM_IdleGCManagerPointer.cast(getPointerAtOffset(MM_GCExtensions._idleGCManagerOffset_));
	}

	// MM_IdleGCManager* idleGCManager
	public PointerPointer idleGCManagerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._idleGCManagerOffset_));
	}

	// double initialRAMPercent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_initialRAMPercentOffset_", declaredType="double")
	public double initialRAMPercent() throws CorruptDataException {
		return getDoubleAtOffset(MM_GCExtensions._initialRAMPercentOffset_);
	}

	// double initialRAMPercent
	public DoublePointer initialRAMPercentEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(MM_GCExtensions._initialRAMPercentOffset_));
	}

	// bool isRegionSizeWithOverrideSpecified
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_isRegionSizeWithOverrideSpecifiedOffset_", declaredType="bool")
	public boolean isRegionSizeWithOverrideSpecified() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._isRegionSizeWithOverrideSpecifiedOffset_);
	}

	// bool isRegionSizeWithOverrideSpecified
	public BoolPointer isRegionSizeWithOverrideSpecifiedEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._isRegionSizeWithOverrideSpecifiedOffset_));
	}

	// MM_MarkJavaStats markJavaStats
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_markJavaStatsOffset_", declaredType="MM_MarkJavaStats")
	public MM_MarkJavaStatsPointer markJavaStats() throws CorruptDataException {
		return MM_MarkJavaStatsPointer.cast(nonNullFieldEA(MM_GCExtensions._markJavaStatsOffset_));
	}

	// MM_MarkJavaStats markJavaStats
	public PointerPointer markJavaStatsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._markJavaStatsOffset_));
	}

	// double maxRAMPercent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxRAMPercentOffset_", declaredType="double")
	public double maxRAMPercent() throws CorruptDataException {
		return getDoubleAtOffset(MM_GCExtensions._maxRAMPercentOffset_);
	}

	// double maxRAMPercent
	public DoublePointer maxRAMPercentEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(MM_GCExtensions._maxRAMPercentOffset_));
	}

	// U64 maxSoftReferenceAge
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxSoftReferenceAgeOffset_", declaredType="U64")
	public UDATA maxSoftReferenceAge() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._maxSoftReferenceAgeOffset_));
	}

	// U64 maxSoftReferenceAge
	public UDATAPointer maxSoftReferenceAgeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._maxSoftReferenceAgeOffset_));
	}

	// U64 minimumFreeSizeForSurvivor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_minimumFreeSizeForSurvivorOffset_", declaredType="U64")
	public UDATA minimumFreeSizeForSurvivor() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._minimumFreeSizeForSurvivorOffset_));
	}

	// U64 minimumFreeSizeForSurvivor
	public UDATAPointer minimumFreeSizeForSurvivorEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._minimumFreeSizeForSurvivorOffset_));
	}

	// MM_Wildcard* numaCommonThreadClassNamePatterns
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numaCommonThreadClassNamePatternsOffset_", declaredType="MM_Wildcard*")
	public MM_WildcardPointer numaCommonThreadClassNamePatterns() throws CorruptDataException {
		return MM_WildcardPointer.cast(getPointerAtOffset(MM_GCExtensions._numaCommonThreadClassNamePatternsOffset_));
	}

	// MM_Wildcard* numaCommonThreadClassNamePatterns
	public PointerPointer numaCommonThreadClassNamePatternsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._numaCommonThreadClassNamePatternsOffset_));
	}

	// U64 objectListFragmentCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_objectListFragmentCountOffset_", declaredType="U64")
	public UDATA objectListFragmentCount() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._objectListFragmentCountOffset_));
	}

	// U64 objectListFragmentCount
	public UDATAPointer objectListFragmentCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._objectListFragmentCountOffset_));
	}

	// MM_OwnableSynchronizerObjectList* ownableSynchronizerObjectLists
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ownableSynchronizerObjectListsOffset_", declaredType="MM_OwnableSynchronizerObjectList*")
	public MM_OwnableSynchronizerObjectListPointer ownableSynchronizerObjectLists() throws CorruptDataException {
		return MM_OwnableSynchronizerObjectListPointer.cast(getPointerAtOffset(MM_GCExtensions._ownableSynchronizerObjectListsOffset_));
	}

	// MM_OwnableSynchronizerObjectList* ownableSynchronizerObjectLists
	public PointerPointer ownableSynchronizerObjectListsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._ownableSynchronizerObjectListsOffset_));
	}

	// bool recycleRemainders
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_recycleRemaindersOffset_", declaredType="bool")
	public boolean recycleRemainders() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._recycleRemaindersOffset_);
	}

	// bool recycleRemainders
	public BoolPointer recycleRemaindersEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._recycleRemaindersOffset_));
	}

	// J9ReferenceArrayCopyTable referenceArrayCopyTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_referenceArrayCopyTableOffset_", declaredType="J9ReferenceArrayCopyTable")
	public J9ReferenceArrayCopyTablePointer referenceArrayCopyTable() throws CorruptDataException {
		return J9ReferenceArrayCopyTablePointer.cast(nonNullFieldEA(MM_GCExtensions._referenceArrayCopyTableOffset_));
	}

	// J9ReferenceArrayCopyTable referenceArrayCopyTable
	public PointerPointer referenceArrayCopyTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._referenceArrayCopyTableOffset_));
	}

	// MM_ReferenceObjectList* referenceObjectLists
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_referenceObjectListsOffset_", declaredType="MM_ReferenceObjectList*")
	public MM_ReferenceObjectListPointer referenceObjectLists() throws CorruptDataException {
		return MM_ReferenceObjectListPointer.cast(getPointerAtOffset(MM_GCExtensions._referenceObjectListsOffset_));
	}

	// MM_ReferenceObjectList* referenceObjectLists
	public PointerPointer referenceObjectListsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._referenceObjectListsOffset_));
	}

	// U64 runtimeCheckDynamicClassUnloading
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_runtimeCheckDynamicClassUnloadingOffset_", declaredType="U64")
	public UDATA runtimeCheckDynamicClassUnloading() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GCExtensions._runtimeCheckDynamicClassUnloadingOffset_));
	}

	// U64 runtimeCheckDynamicClassUnloading
	public UDATAPointer runtimeCheckDynamicClassUnloadingEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GCExtensions._runtimeCheckDynamicClassUnloadingOffset_));
	}

	// MM_ScavengerJavaStats scavengerJavaStats
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_scavengerJavaStatsOffset_", declaredType="MM_ScavengerJavaStats")
	public MM_ScavengerJavaStatsPointer scavengerJavaStats() throws CorruptDataException {
		return MM_ScavengerJavaStatsPointer.cast(nonNullFieldEA(MM_GCExtensions._scavengerJavaStatsOffset_));
	}

	// MM_ScavengerJavaStats scavengerJavaStats
	public PointerPointer scavengerJavaStatsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._scavengerJavaStatsOffset_));
	}

	// MM_GCExtensions$JitStringDeDupPolicy stringDedupPolicy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stringDedupPolicyOffset_", declaredType="MM_GCExtensions$JitStringDeDupPolicy")
	public long stringDedupPolicy() throws CorruptDataException {
		if (MM_GCExtensions$JitStringDeDupPolicy.SIZEOF == 1) {
			return getByteAtOffset(MM_GCExtensions._stringDedupPolicyOffset_);
		} else if (MM_GCExtensions$JitStringDeDupPolicy.SIZEOF == 2) {
			return getShortAtOffset(MM_GCExtensions._stringDedupPolicyOffset_);
		} else if (MM_GCExtensions$JitStringDeDupPolicy.SIZEOF == 4) {
			return getIntAtOffset(MM_GCExtensions._stringDedupPolicyOffset_);
		} else if (MM_GCExtensions$JitStringDeDupPolicy.SIZEOF == 8) {
			return getLongAtOffset(MM_GCExtensions._stringDedupPolicyOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// MM_GCExtensions$JitStringDeDupPolicy stringDedupPolicy
	public EnumPointer stringDedupPolicyEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(MM_GCExtensions._stringDedupPolicyOffset_), MM_GCExtensions$JitStringDeDupPolicy.class);
	}

	// MM_StringTable* stringTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stringTableOffset_", declaredType="MM_StringTable*")
	public MM_StringTablePointer stringTable() throws CorruptDataException {
		return MM_StringTablePointer.cast(getPointerAtOffset(MM_GCExtensions._stringTableOffset_));
	}

	// MM_StringTable* stringTable
	public PointerPointer stringTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._stringTableOffset_));
	}

	// bool testContainerMemLimit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_testContainerMemLimitOffset_", declaredType="bool")
	public boolean testContainerMemLimit() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._testContainerMemLimitOffset_);
	}

	// bool testContainerMemLimit
	public BoolPointer testContainerMemLimitEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._testContainerMemLimitOffset_));
	}

	// double testRAMSizePercentage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_testRAMSizePercentageOffset_", declaredType="double")
	public double testRAMSizePercentage() throws CorruptDataException {
		return getDoubleAtOffset(MM_GCExtensions._testRAMSizePercentageOffset_);
	}

	// double testRAMSizePercentage
	public DoublePointer testRAMSizePercentageEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(MM_GCExtensions._testRAMSizePercentageOffset_));
	}

	// void* tgcExtensions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tgcExtensionsOffset_", declaredType="void*")
	public VoidPointer tgcExtensions() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(MM_GCExtensions._tgcExtensionsOffset_));
	}

	// void* tgcExtensions
	public PointerPointer tgcExtensionsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._tgcExtensionsOffset_));
	}

	// MM_GCExtensions$TimingAddContinuationInList timingAddContinuationInList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timingAddContinuationInListOffset_", declaredType="MM_GCExtensions$TimingAddContinuationInList")
	public long timingAddContinuationInList() throws CorruptDataException {
		if (MM_GCExtensions$TimingAddContinuationInList.SIZEOF == 1) {
			return getByteAtOffset(MM_GCExtensions._timingAddContinuationInListOffset_);
		} else if (MM_GCExtensions$TimingAddContinuationInList.SIZEOF == 2) {
			return getShortAtOffset(MM_GCExtensions._timingAddContinuationInListOffset_);
		} else if (MM_GCExtensions$TimingAddContinuationInList.SIZEOF == 4) {
			return getIntAtOffset(MM_GCExtensions._timingAddContinuationInListOffset_);
		} else if (MM_GCExtensions$TimingAddContinuationInList.SIZEOF == 8) {
			return getLongAtOffset(MM_GCExtensions._timingAddContinuationInListOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// MM_GCExtensions$TimingAddContinuationInList timingAddContinuationInList
	public EnumPointer timingAddContinuationInListEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(MM_GCExtensions._timingAddContinuationInListOffset_), MM_GCExtensions$TimingAddContinuationInList.class);
	}

	// bool tlhMaximumSizeSpecified
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tlhMaximumSizeSpecifiedOffset_", declaredType="bool")
	public boolean tlhMaximumSizeSpecified() throws CorruptDataException {
		return getBoolAtOffset(MM_GCExtensions._tlhMaximumSizeSpecifiedOffset_);
	}

	// bool tlhMaximumSizeSpecified
	public BoolPointer tlhMaximumSizeSpecifiedEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GCExtensions._tlhMaximumSizeSpecifiedOffset_));
	}

	// MM_UnfinalizedObjectList* unfinalizedObjectLists
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unfinalizedObjectListsOffset_", declaredType="MM_UnfinalizedObjectList*")
	public MM_UnfinalizedObjectListPointer unfinalizedObjectLists() throws CorruptDataException {
		return MM_UnfinalizedObjectListPointer.cast(getPointerAtOffset(MM_GCExtensions._unfinalizedObjectListsOffset_));
	}

	// MM_UnfinalizedObjectList* unfinalizedObjectLists
	public PointerPointer unfinalizedObjectListsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._unfinalizedObjectListsOffset_));
	}

	// MM_GCExtensions$UserSpecifiedParameters userSpecifiedParameters
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_userSpecifiedParametersOffset_", declaredType="MM_GCExtensions$UserSpecifiedParameters")
	public MM_GCExtensions$UserSpecifiedParametersPointer userSpecifiedParameters() throws CorruptDataException {
		return MM_GCExtensions$UserSpecifiedParametersPointer.cast(nonNullFieldEA(MM_GCExtensions._userSpecifiedParametersOffset_));
	}

	// MM_GCExtensions$UserSpecifiedParameters userSpecifiedParameters
	public PointerPointer userSpecifiedParametersEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._userSpecifiedParametersOffset_));
	}

	// J9MemoryManagerVerboseInterface verboseFunctionTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_verboseFunctionTableOffset_", declaredType="J9MemoryManagerVerboseInterface")
	public J9MemoryManagerVerboseInterfacePointer verboseFunctionTable() throws CorruptDataException {
		return J9MemoryManagerVerboseInterfacePointer.cast(nonNullFieldEA(MM_GCExtensions._verboseFunctionTableOffset_));
	}

	// J9MemoryManagerVerboseInterface verboseFunctionTable
	public PointerPointer verboseFunctionTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._verboseFunctionTableOffset_));
	}

	// MM_UserSpecifiedParameterBool virtualLargeObjectHeap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_virtualLargeObjectHeapOffset_", declaredType="MM_UserSpecifiedParameterBool")
	public MM_UserSpecifiedParameterBoolPointer virtualLargeObjectHeap() throws CorruptDataException {
		return MM_UserSpecifiedParameterBoolPointer.cast(nonNullFieldEA(MM_GCExtensions._virtualLargeObjectHeapOffset_));
	}

	// MM_UserSpecifiedParameterBool virtualLargeObjectHeap
	public PointerPointer virtualLargeObjectHeapEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_GCExtensions._virtualLargeObjectHeapOffset_));
	}

}
