/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_VerboseBufferPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_VerboseBufferPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_VerboseBuffer.class)
public class MM_VerboseBufferPointer extends MM_BasePointer {

	// NULL
	public static final MM_VerboseBufferPointer NULL = new MM_VerboseBufferPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_VerboseBufferPointer(long address) {
		super(address);
	}

	public static MM_VerboseBufferPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_VerboseBufferPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_VerboseBufferPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_VerboseBufferPointer(address);
	}

	public MM_VerboseBufferPointer add(long count) {
		return MM_VerboseBufferPointer.cast(address + (MM_VerboseBuffer.SIZEOF * count));
	}

	public MM_VerboseBufferPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_VerboseBufferPointer addOffset(long offset) {
		return MM_VerboseBufferPointer.cast(address + offset);
	}

	public MM_VerboseBufferPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_VerboseBufferPointer sub(long count) {
		return MM_VerboseBufferPointer.cast(address - (MM_VerboseBuffer.SIZEOF * count));
	}

	public MM_VerboseBufferPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_VerboseBufferPointer subOffset(long offset) {
		return MM_VerboseBufferPointer.cast(address - offset);
	}

	public MM_VerboseBufferPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_VerboseBufferPointer untag(long mask) {
		return MM_VerboseBufferPointer.cast(address & ~mask);
	}

	public MM_VerboseBufferPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_VerboseBuffer.SIZEOF;
	}

	// Implementation methods

	// U8* _buffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bufferOffset_", declaredType="U8*")
	public U8Pointer _buffer() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(MM_VerboseBuffer.__bufferOffset_));
	}

	// U8* _buffer
	public PointerPointer _bufferEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_VerboseBuffer.__bufferOffset_));
	}

	// U8* _bufferAlloc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bufferAllocOffset_", declaredType="U8*")
	public U8Pointer _bufferAlloc() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(MM_VerboseBuffer.__bufferAllocOffset_));
	}

	// U8* _bufferAlloc
	public PointerPointer _bufferAllocEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_VerboseBuffer.__bufferAllocOffset_));
	}

	// U8* _bufferTop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bufferTopOffset_", declaredType="U8*")
	public U8Pointer _bufferTop() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(MM_VerboseBuffer.__bufferTopOffset_));
	}

	// U8* _bufferTop
	public PointerPointer _bufferTopEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_VerboseBuffer.__bufferTopOffset_));
	}

	// void** _vptr$MM_VerboseBuffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__vptr$MM_VerboseBufferOffset_", declaredType="void**")
	public PointerPointer _vptr$MM_VerboseBuffer() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(MM_VerboseBuffer.__vptr$MM_VerboseBufferOffset_));
	}

	// void** _vptr$MM_VerboseBuffer
	public PointerPointer _vptr$MM_VerboseBufferEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_VerboseBuffer.__vptr$MM_VerboseBufferOffset_));
	}

}
