/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_TgcExtensions
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_TgcExtensions {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __allocationContextRequestedOffset_;
	public static final int __allocationRequestedOffset_;
	public static final int __backtraceOffset_;
	public static final int __backtraceRequestedOffset_;
	public static final int __cardCleaningOffset_;
	public static final int __cardCleaningRequestedOffset_;
	public static final int __compactionOffset_;
	public static final int __compactionRequestedOffset_;
	public static final int __concurrentOffset_;
	public static final int __concurrentRequestedOffset_;
	public static final int __copyForwardRequestedOffset_;
	public static final int __dumpOffset_;
	public static final int __dumpRequestedOffset_;
	public static final int __dynamicCollectionSetDataOffset_;
	public static final int __dynamicCollectionSetRequestedOffset_;
	public static final int __excessiveGCOffset_;
	public static final int __excessiveGCRequestedOffset_;
	public static final int __exclusiveAccessOffset_;
	public static final int __exclusiveAccessRequestedOffset_;
	public static final int __freeListOffset_;
	public static final int __freeListRequestedOffset_;
	public static final int __freeListSummaryRequestedOffset_;
	public static final int __heapRequestedOffset_;
	public static final int __intelligentCompactRequestedOffset_;
	public static final int __interRegionReferencesRequestedOffset_;
	public static final int __interRegionRememberedSetDemographicsOffset_;
	public static final int __interRegionRememberedSetDemographicsRequestedOffset_;
	public static final int __interRegionRememberedSetRequestedOffset_;
	public static final int __largeAllocationRequestedOffset_;
	public static final int __largeAllocationVerboseRequestedOffset_;
	public static final int __numaOffset_;
	public static final int __numaRequestedOffset_;
	public static final int __outputFileOffset_;
	public static final int __parallelOffset_;
	public static final int __parallelRequestedOffset_;
	public static final int __portLibraryOffset_;
	public static final int __projectedStatsRequestedOffset_;
	public static final int __rootScannerRequestedOffset_;
	public static final int __rsclDistinctFlagArrayOffset_;
	public static final int __scavengerOffset_;
	public static final int __scavengerMemoryStatsRequestedOffset_;
	public static final int __scavengerRequestedOffset_;
	public static final int __scavengerSurvivalStatsRequestedOffset_;
	public static final int __sizeClassesRequestedOffset_;
	public static final int __terseOffset_;
	public static final int __terseRequestedOffset_;
	public static final int __writeOnceCompactTimingRequestedOffset_;
	public static final int __writeOnceCompactionOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__allocationContextRequestedOffset_ = 0;
		__allocationRequestedOffset_ = 0;
		__backtraceOffset_ = 0;
		__backtraceRequestedOffset_ = 0;
		__cardCleaningOffset_ = 0;
		__cardCleaningRequestedOffset_ = 0;
		__compactionOffset_ = 0;
		__compactionRequestedOffset_ = 0;
		__concurrentOffset_ = 0;
		__concurrentRequestedOffset_ = 0;
		__copyForwardRequestedOffset_ = 0;
		__dumpOffset_ = 0;
		__dumpRequestedOffset_ = 0;
		__dynamicCollectionSetDataOffset_ = 0;
		__dynamicCollectionSetRequestedOffset_ = 0;
		__excessiveGCOffset_ = 0;
		__excessiveGCRequestedOffset_ = 0;
		__exclusiveAccessOffset_ = 0;
		__exclusiveAccessRequestedOffset_ = 0;
		__freeListOffset_ = 0;
		__freeListRequestedOffset_ = 0;
		__freeListSummaryRequestedOffset_ = 0;
		__heapRequestedOffset_ = 0;
		__intelligentCompactRequestedOffset_ = 0;
		__interRegionReferencesRequestedOffset_ = 0;
		__interRegionRememberedSetDemographicsOffset_ = 0;
		__interRegionRememberedSetDemographicsRequestedOffset_ = 0;
		__interRegionRememberedSetRequestedOffset_ = 0;
		__largeAllocationRequestedOffset_ = 0;
		__largeAllocationVerboseRequestedOffset_ = 0;
		__numaOffset_ = 0;
		__numaRequestedOffset_ = 0;
		__outputFileOffset_ = 0;
		__parallelOffset_ = 0;
		__parallelRequestedOffset_ = 0;
		__portLibraryOffset_ = 0;
		__projectedStatsRequestedOffset_ = 0;
		__rootScannerRequestedOffset_ = 0;
		__rsclDistinctFlagArrayOffset_ = 0;
		__scavengerOffset_ = 0;
		__scavengerMemoryStatsRequestedOffset_ = 0;
		__scavengerRequestedOffset_ = 0;
		__scavengerSurvivalStatsRequestedOffset_ = 0;
		__sizeClassesRequestedOffset_ = 0;
		__terseOffset_ = 0;
		__terseRequestedOffset_ = 0;
		__writeOnceCompactTimingRequestedOffset_ = 0;
		__writeOnceCompactionOffset_ = 0;
	}

}
