/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class HelloWorld {
    DefaultStyledDocument doc;
    StyleContext styles;
    HashMap<String, Style> runAttr;
    Paragraph[] data = new Paragraph[]{new Paragraph("title", new Run[]{new Run("none", "Hello from Cupertino")}), new Paragraph("title", new Run[]{new Run("none", "\u53f0\u5317\u554f\u5019\u60a8!")}), new Paragraph("title", new Run[]{new Run("none", "\u0391\u03b8\u03b7\u03bd\u03b1\u03b9 \u03b1\u03c3\u03c0\u03b1\u03b6\u03bf\u03bd\u03c4\u03b1\u03b9 \u03c5\u03bc\u03b1\u03c2!")}), new Paragraph("title", new Run[]{new Run("none", "\u6771\u4eac\u304b\u3089\u4eca\u65e5\u306f")}), new Paragraph("title", new Run[]{new Run("none", "\u05e9\u05dc\u05d5\u05dd \u05de\u05d9\u05e8\u05d5\u05e9\u05dc\u05d9\u05dd")}), new Paragraph("title", new Run[]{new Run("none", "\u0633\u0644\u0627\u0645")})};

    HelloWorld(DefaultStyledDocument doc, StyleContext styles) {
        this.doc = doc;
        this.styles = styles;
        this.runAttr = new HashMap();
    }

    void loadDocument() {
        this.createStyles();
        for (int i = 0; i < this.data.length; ++i) {
            Paragraph p = this.data[i];
            this.addParagraph(p);
        }
    }

    void addParagraph(Paragraph p) {
        try {
            Style s = null;
            for (int i = 0; i < p.data.length; ++i) {
                Run run = p.data[i];
                s = this.runAttr.get(run.attr);
                this.doc.insertString(this.doc.getLength(), run.content, s);
            }
            Style ls = this.styles.getStyle(p.logical);
            this.doc.setLogicalStyle(this.doc.getLength() - 1, ls);
            this.doc.insertString(this.doc.getLength(), "\n", null);
        }
        catch (BadLocationException e) {
            System.err.println("Internal error: " + String.valueOf(e));
        }
    }

    void createStyles() {
        Style s = this.styles.addStyle(null, null);
        this.runAttr.put("none", s);
        s = this.styles.addStyle(null, null);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, new Color(153, 153, 102));
        this.runAttr.put("cquote", s);
        s = this.styles.addStyle(null, null);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, new Color(51, 102, 153));
        this.runAttr.put("aquote", s);
        try {
            ResourceBundle resources = ResourceBundle.getBundle("resources.Stylepad", Locale.getDefault());
            s = this.styles.addStyle(null, null);
            ImageIcon alice = new ImageIcon(resources.getString("aliceGif"));
            StyleConstants.setIcon(s, alice);
            this.runAttr.put("alice", s);
            s = this.styles.addStyle(null, null);
            ImageIcon caterpillar = new ImageIcon(resources.getString("caterpillarGif"));
            StyleConstants.setIcon(s, caterpillar);
            this.runAttr.put("caterpillar", s);
            s = this.styles.addStyle(null, null);
            ImageIcon hatter = new ImageIcon(resources.getString("hatterGif"));
            StyleConstants.setIcon(s, hatter);
            this.runAttr.put("hatter", s);
        }
        catch (MissingResourceException resources) {
            // empty catch block
        }
        Style def = this.styles.getStyle("default");
        Style heading = this.styles.addStyle("heading", def);
        StyleConstants.setBold(heading, true);
        StyleConstants.setAlignment(heading, 1);
        StyleConstants.setSpaceAbove(heading, 10.0f);
        StyleConstants.setSpaceBelow(heading, 10.0f);
        StyleConstants.setFontSize(heading, 18);
        Style sty = this.styles.addStyle("title", heading);
        StyleConstants.setFontSize(sty, 32);
        sty = this.styles.addStyle("edition", heading);
        StyleConstants.setFontSize(sty, 16);
        sty = this.styles.addStyle("author", heading);
        StyleConstants.setItalic(sty, true);
        StyleConstants.setSpaceBelow(sty, 25.0f);
        sty = this.styles.addStyle("subtitle", heading);
        StyleConstants.setSpaceBelow(sty, 35.0f);
        sty = this.styles.addStyle("normal", def);
        StyleConstants.setLeftIndent(sty, 10.0f);
        StyleConstants.setRightIndent(sty, 10.0f);
        StyleConstants.setFontSize(sty, 14);
        StyleConstants.setSpaceAbove(sty, 4.0f);
        StyleConstants.setSpaceBelow(sty, 4.0f);
    }

    static class Run {
        String attr;
        String content;

        Run(String attr, String content) {
            this.attr = attr;
            this.content = content;
        }
    }

    static class Paragraph {
        String logical;
        Run[] data;

        Paragraph(String logical, Run[] data) {
            this.logical = logical;
            this.data = data;
        }
    }
}

