/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _dirdescPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _dirdescPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_dirdesc.class)
public class _dirdescPointer extends StructurePointer {

	// NULL
	public static final _dirdescPointer NULL = new _dirdescPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _dirdescPointer(long address) {
		super(address);
	}

	public static _dirdescPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _dirdescPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _dirdescPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _dirdescPointer(address);
	}

	public _dirdescPointer add(long count) {
		return _dirdescPointer.cast(address + (_dirdesc.SIZEOF * count));
	}

	public _dirdescPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _dirdescPointer addOffset(long offset) {
		return _dirdescPointer.cast(address + offset);
	}

	public _dirdescPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _dirdescPointer sub(long count) {
		return _dirdescPointer.cast(address - (_dirdesc.SIZEOF * count));
	}

	public _dirdescPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _dirdescPointer subOffset(long offset) {
		return _dirdescPointer.cast(address - offset);
	}

	public _dirdescPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _dirdescPointer untag(long mask) {
		return _dirdescPointer.cast(address & ~mask);
	}

	public _dirdescPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _dirdesc.SIZEOF;
	}

	// Implementation methods

	// blksize_t dd_blksize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dd_blksizeOffset_", declaredType="blksize_t")
	public IDATA dd_blksize() throws CorruptDataException {
		return new I64(getLongAtOffset(_dirdesc._dd_blksizeOffset_));
	}

	// blksize_t dd_blksize
	public IDATAPointer dd_blksizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_dirdesc._dd_blksizeOffset_));
	}

	// U8* dd_buf
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dd_bufOffset_", declaredType="U8*")
	public U8Pointer dd_buf() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_dirdesc._dd_bufOffset_));
	}

	// U8* dd_buf
	public PointerPointer dd_bufEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dirdesc._dd_bufOffset_));
	}

	// off_t dd_curoff
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dd_curoffOffset_", declaredType="off_t")
	public IDATA dd_curoff() throws CorruptDataException {
		return new I64(getLongAtOffset(_dirdesc._dd_curoffOffset_));
	}

	// off_t dd_curoff
	public IDATAPointer dd_curoffEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_dirdesc._dd_curoffOffset_));
	}

	// I32 dd_fd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dd_fdOffset_", declaredType="I32")
	public IDATA dd_fd() throws CorruptDataException {
		return new I32(getIntAtOffset(_dirdesc._dd_fdOffset_));
	}

	// I32 dd_fd
	public IDATAPointer dd_fdEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_dirdesc._dd_fdOffset_));
	}

	// I64 dd_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dd_flagOffset_", declaredType="I64")
	public IDATA dd_flag() throws CorruptDataException {
		return new I64(getLongAtOffset(_dirdesc._dd_flagOffset_));
	}

	// I64 dd_flag
	public IDATAPointer dd_flagEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_dirdesc._dd_flagOffset_));
	}

	// off_t dd_loc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dd_locOffset_", declaredType="off_t")
	public IDATA dd_loc() throws CorruptDataException {
		return new I64(getLongAtOffset(_dirdesc._dd_locOffset_));
	}

	// off_t dd_loc
	public IDATAPointer dd_locEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_dirdesc._dd_locOffset_));
	}

	// void* dd_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dd_lockOffset_", declaredType="void*")
	public VoidPointer dd_lock() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_dirdesc._dd_lockOffset_));
	}

	// void* dd_lock
	public PointerPointer dd_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_dirdesc._dd_lockOffset_));
	}

	// I64 dd_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dd_sizeOffset_", declaredType="I64")
	public IDATA dd_size() throws CorruptDataException {
		return new I64(getLongAtOffset(_dirdesc._dd_sizeOffset_));
	}

	// I64 dd_size
	public IDATAPointer dd_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_dirdesc._dd_sizeOffset_));
	}

}
