/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: perfstat_memory_total_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the perfstat_memory_total_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=perfstat_memory_total_t.class)
public class perfstat_memory_total_tPointer extends StructurePointer {

	// NULL
	public static final perfstat_memory_total_tPointer NULL = new perfstat_memory_total_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected perfstat_memory_total_tPointer(long address) {
		super(address);
	}

	public static perfstat_memory_total_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static perfstat_memory_total_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static perfstat_memory_total_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new perfstat_memory_total_tPointer(address);
	}

	public perfstat_memory_total_tPointer add(long count) {
		return perfstat_memory_total_tPointer.cast(address + (perfstat_memory_total_t.SIZEOF * count));
	}

	public perfstat_memory_total_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public perfstat_memory_total_tPointer addOffset(long offset) {
		return perfstat_memory_total_tPointer.cast(address + offset);
	}

	public perfstat_memory_total_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public perfstat_memory_total_tPointer sub(long count) {
		return perfstat_memory_total_tPointer.cast(address - (perfstat_memory_total_t.SIZEOF * count));
	}

	public perfstat_memory_total_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public perfstat_memory_total_tPointer subOffset(long offset) {
		return perfstat_memory_total_tPointer.cast(address - offset);
	}

	public perfstat_memory_total_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public perfstat_memory_total_tPointer untag(long mask) {
		return perfstat_memory_total_tPointer.cast(address & ~mask);
	}

	public perfstat_memory_total_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return perfstat_memory_total_t.SIZEOF;
	}

	// Implementation methods

	// u_longlong_t bytes_coalesced
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bytes_coalescedOffset_", declaredType="u_longlong_t")
	public UDATA bytes_coalesced() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._bytes_coalescedOffset_));
	}

	// u_longlong_t bytes_coalesced
	public UDATAPointer bytes_coalescedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._bytes_coalescedOffset_));
	}

	// u_longlong_t bytes_coalesced_mempool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bytes_coalesced_mempoolOffset_", declaredType="u_longlong_t")
	public UDATA bytes_coalesced_mempool() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._bytes_coalesced_mempoolOffset_));
	}

	// u_longlong_t bytes_coalesced_mempool
	public UDATAPointer bytes_coalesced_mempoolEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._bytes_coalesced_mempoolOffset_));
	}

	// u_longlong_t comprsd_total
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_comprsd_totalOffset_", declaredType="u_longlong_t")
	public UDATA comprsd_total() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._comprsd_totalOffset_));
	}

	// u_longlong_t comprsd_total
	public UDATAPointer comprsd_totalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._comprsd_totalOffset_));
	}

	// u_longlong_t comprsd_wseg_pgs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_comprsd_wseg_pgsOffset_", declaredType="u_longlong_t")
	public UDATA comprsd_wseg_pgs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._comprsd_wseg_pgsOffset_));
	}

	// u_longlong_t comprsd_wseg_pgs
	public UDATAPointer comprsd_wseg_pgsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._comprsd_wseg_pgsOffset_));
	}

	// u_longlong_t comprsd_wseg_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_comprsd_wseg_sizeOffset_", declaredType="u_longlong_t")
	public UDATA comprsd_wseg_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._comprsd_wseg_sizeOffset_));
	}

	// u_longlong_t comprsd_wseg_size
	public UDATAPointer comprsd_wseg_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._comprsd_wseg_sizeOffset_));
	}

	// u_longlong_t cpgins
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpginsOffset_", declaredType="u_longlong_t")
	public UDATA cpgins() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._cpginsOffset_));
	}

	// u_longlong_t cpgins
	public UDATAPointer cpginsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._cpginsOffset_));
	}

	// u_longlong_t cpgouts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpgoutsOffset_", declaredType="u_longlong_t")
	public UDATA cpgouts() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._cpgoutsOffset_));
	}

	// u_longlong_t cpgouts
	public UDATAPointer cpgoutsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._cpgoutsOffset_));
	}

	// u_longlong_t cpool_inuse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpool_inuseOffset_", declaredType="u_longlong_t")
	public UDATA cpool_inuse() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._cpool_inuseOffset_));
	}

	// u_longlong_t cpool_inuse
	public UDATAPointer cpool_inuseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._cpool_inuseOffset_));
	}

	// u_longlong_t cpool_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpool_sizeOffset_", declaredType="u_longlong_t")
	public UDATA cpool_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._cpool_sizeOffset_));
	}

	// u_longlong_t cpool_size
	public UDATAPointer cpool_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._cpool_sizeOffset_));
	}

	// u_longlong_t cycles
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cyclesOffset_", declaredType="u_longlong_t")
	public UDATA cycles() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._cyclesOffset_));
	}

	// u_longlong_t cycles
	public UDATAPointer cyclesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._cyclesOffset_));
	}

	// u_longlong_t expanded_memory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_expanded_memoryOffset_", declaredType="u_longlong_t")
	public UDATA expanded_memory() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._expanded_memoryOffset_));
	}

	// u_longlong_t expanded_memory
	public UDATAPointer expanded_memoryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._expanded_memoryOffset_));
	}

	// u_longlong_t iohwm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iohwmOffset_", declaredType="u_longlong_t")
	public UDATA iohwm() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._iohwmOffset_));
	}

	// u_longlong_t iohwm
	public UDATAPointer iohwmEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._iohwmOffset_));
	}

	// u_longlong_t iome
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iomeOffset_", declaredType="u_longlong_t")
	public UDATA iome() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._iomeOffset_));
	}

	// u_longlong_t iome
	public UDATAPointer iomeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._iomeOffset_));
	}

	// u_longlong_t iomu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iomuOffset_", declaredType="u_longlong_t")
	public UDATA iomu() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._iomuOffset_));
	}

	// u_longlong_t iomu
	public UDATAPointer iomuEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._iomuOffset_));
	}

	// u_longlong_t max_cpool_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_cpool_sizeOffset_", declaredType="u_longlong_t")
	public UDATA max_cpool_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._max_cpool_sizeOffset_));
	}

	// u_longlong_t max_cpool_size
	public UDATAPointer max_cpool_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._max_cpool_sizeOffset_));
	}

	// u_longlong_t min_ucpool_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_min_ucpool_sizeOffset_", declaredType="u_longlong_t")
	public UDATA min_ucpool_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._min_ucpool_sizeOffset_));
	}

	// u_longlong_t min_ucpool_size
	public UDATAPointer min_ucpool_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._min_ucpool_sizeOffset_));
	}

	// u_longlong_t numperm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numpermOffset_", declaredType="u_longlong_t")
	public UDATA numperm() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._numpermOffset_));
	}

	// u_longlong_t numperm
	public UDATAPointer numpermEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._numpermOffset_));
	}

	// u_longlong_t pgbad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgbadOffset_", declaredType="u_longlong_t")
	public UDATA pgbad() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pgbadOffset_));
	}

	// u_longlong_t pgbad
	public UDATAPointer pgbadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pgbadOffset_));
	}

	// u_longlong_t pgexct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgexctOffset_", declaredType="u_longlong_t")
	public UDATA pgexct() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pgexctOffset_));
	}

	// u_longlong_t pgexct
	public UDATAPointer pgexctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pgexctOffset_));
	}

	// u_longlong_t pgins
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pginsOffset_", declaredType="u_longlong_t")
	public UDATA pgins() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pginsOffset_));
	}

	// u_longlong_t pgins
	public UDATAPointer pginsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pginsOffset_));
	}

	// u_longlong_t pgouts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgoutsOffset_", declaredType="u_longlong_t")
	public UDATA pgouts() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pgoutsOffset_));
	}

	// u_longlong_t pgouts
	public UDATAPointer pgoutsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pgoutsOffset_));
	}

	// u_longlong_t pgsp_free
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgsp_freeOffset_", declaredType="u_longlong_t")
	public UDATA pgsp_free() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pgsp_freeOffset_));
	}

	// u_longlong_t pgsp_free
	public UDATAPointer pgsp_freeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pgsp_freeOffset_));
	}

	// u_longlong_t pgsp_rsvd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgsp_rsvdOffset_", declaredType="u_longlong_t")
	public UDATA pgsp_rsvd() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pgsp_rsvdOffset_));
	}

	// u_longlong_t pgsp_rsvd
	public UDATAPointer pgsp_rsvdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pgsp_rsvdOffset_));
	}

	// u_longlong_t pgsp_total
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgsp_totalOffset_", declaredType="u_longlong_t")
	public UDATA pgsp_total() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pgsp_totalOffset_));
	}

	// u_longlong_t pgsp_total
	public UDATAPointer pgsp_totalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pgsp_totalOffset_));
	}

	// u_longlong_t pgspins
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgspinsOffset_", declaredType="u_longlong_t")
	public UDATA pgspins() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pgspinsOffset_));
	}

	// u_longlong_t pgspins
	public UDATAPointer pgspinsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pgspinsOffset_));
	}

	// u_longlong_t pgspouts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgspoutsOffset_", declaredType="u_longlong_t")
	public UDATA pgspouts() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pgspoutsOffset_));
	}

	// u_longlong_t pgspouts
	public UDATAPointer pgspoutsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pgspoutsOffset_));
	}

	// u_longlong_t pgsteals
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgstealsOffset_", declaredType="u_longlong_t")
	public UDATA pgsteals() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pgstealsOffset_));
	}

	// u_longlong_t pgsteals
	public UDATAPointer pgstealsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pgstealsOffset_));
	}

	// u_longlong_t pmem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pmemOffset_", declaredType="u_longlong_t")
	public UDATA pmem() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._pmemOffset_));
	}

	// u_longlong_t pmem
	public UDATAPointer pmemEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._pmemOffset_));
	}

	// u_longlong_t real_avail
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_availOffset_", declaredType="u_longlong_t")
	public UDATA real_avail() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._real_availOffset_));
	}

	// u_longlong_t real_avail
	public UDATAPointer real_availEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._real_availOffset_));
	}

	// u_longlong_t real_free
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_freeOffset_", declaredType="u_longlong_t")
	public UDATA real_free() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._real_freeOffset_));
	}

	// u_longlong_t real_free
	public UDATAPointer real_freeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._real_freeOffset_));
	}

	// u_longlong_t real_inuse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_inuseOffset_", declaredType="u_longlong_t")
	public UDATA real_inuse() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._real_inuseOffset_));
	}

	// u_longlong_t real_inuse
	public UDATAPointer real_inuseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._real_inuseOffset_));
	}

	// u_longlong_t real_pinned
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_pinnedOffset_", declaredType="u_longlong_t")
	public UDATA real_pinned() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._real_pinnedOffset_));
	}

	// u_longlong_t real_pinned
	public UDATAPointer real_pinnedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._real_pinnedOffset_));
	}

	// u_longlong_t real_process
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_processOffset_", declaredType="u_longlong_t")
	public UDATA real_process() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._real_processOffset_));
	}

	// u_longlong_t real_process
	public UDATAPointer real_processEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._real_processOffset_));
	}

	// u_longlong_t real_system
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_systemOffset_", declaredType="u_longlong_t")
	public UDATA real_system() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._real_systemOffset_));
	}

	// u_longlong_t real_system
	public UDATAPointer real_systemEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._real_systemOffset_));
	}

	// u_longlong_t real_total
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_totalOffset_", declaredType="u_longlong_t")
	public UDATA real_total() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._real_totalOffset_));
	}

	// u_longlong_t real_total
	public UDATAPointer real_totalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._real_totalOffset_));
	}

	// u_longlong_t real_user
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_real_userOffset_", declaredType="u_longlong_t")
	public UDATA real_user() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._real_userOffset_));
	}

	// u_longlong_t real_user
	public UDATAPointer real_userEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._real_userOffset_));
	}

	// u_longlong_t scans
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_scansOffset_", declaredType="u_longlong_t")
	public UDATA scans() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._scansOffset_));
	}

	// u_longlong_t scans
	public UDATAPointer scansEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._scansOffset_));
	}

	// u_longlong_t target_cpool_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_target_cpool_sizeOffset_", declaredType="u_longlong_t")
	public UDATA target_cpool_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._target_cpool_sizeOffset_));
	}

	// u_longlong_t target_cpool_size
	public UDATAPointer target_cpool_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._target_cpool_sizeOffset_));
	}

	// u_longlong_t true_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_true_sizeOffset_", declaredType="u_longlong_t")
	public UDATA true_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._true_sizeOffset_));
	}

	// u_longlong_t true_size
	public UDATAPointer true_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._true_sizeOffset_));
	}

	// u_longlong_t ucpool_inuse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ucpool_inuseOffset_", declaredType="u_longlong_t")
	public UDATA ucpool_inuse() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._ucpool_inuseOffset_));
	}

	// u_longlong_t ucpool_inuse
	public UDATAPointer ucpool_inuseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._ucpool_inuseOffset_));
	}

	// u_longlong_t ucpool_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ucpool_sizeOffset_", declaredType="u_longlong_t")
	public UDATA ucpool_size() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._ucpool_sizeOffset_));
	}

	// u_longlong_t ucpool_size
	public UDATAPointer ucpool_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._ucpool_sizeOffset_));
	}

	// u_longlong_t version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="u_longlong_t")
	public UDATA version() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._versionOffset_));
	}

	// u_longlong_t version
	public UDATAPointer versionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._versionOffset_));
	}

	// u_longlong_t virt_active
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_virt_activeOffset_", declaredType="u_longlong_t")
	public UDATA virt_active() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._virt_activeOffset_));
	}

	// u_longlong_t virt_active
	public UDATAPointer virt_activeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._virt_activeOffset_));
	}

	// u_longlong_t virt_total
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_virt_totalOffset_", declaredType="u_longlong_t")
	public UDATA virt_total() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_memory_total_t._virt_totalOffset_));
	}

	// u_longlong_t virt_total
	public UDATAPointer virt_totalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_memory_total_t._virt_totalOffset_));
	}

}
