/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: PlatformWalkDataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the PlatformWalkDataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=PlatformWalkData.class)
public class PlatformWalkDataPointer extends StructurePointer {

	// NULL
	public static final PlatformWalkDataPointer NULL = new PlatformWalkDataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected PlatformWalkDataPointer(long address) {
		super(address);
	}

	public static PlatformWalkDataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static PlatformWalkDataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static PlatformWalkDataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new PlatformWalkDataPointer(address);
	}

	public PlatformWalkDataPointer add(long count) {
		return PlatformWalkDataPointer.cast(address + (PlatformWalkData.SIZEOF * count));
	}

	public PlatformWalkDataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public PlatformWalkDataPointer addOffset(long offset) {
		return PlatformWalkDataPointer.cast(address + offset);
	}

	public PlatformWalkDataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public PlatformWalkDataPointer sub(long count) {
		return PlatformWalkDataPointer.cast(address - (PlatformWalkData.SIZEOF * count));
	}

	public PlatformWalkDataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public PlatformWalkDataPointer subOffset(long offset) {
		return PlatformWalkDataPointer.cast(address - offset);
	}

	public PlatformWalkDataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public PlatformWalkDataPointer untag(long mask) {
		return PlatformWalkDataPointer.cast(address & ~mask);
	}

	public PlatformWalkDataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return PlatformWalkData.SIZEOF;
	}

	// Implementation methods

	// U8 cleanupRequired
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cleanupRequiredOffset_", declaredType="U8")
	public U8 cleanupRequired() throws CorruptDataException {
		return new U8(getByteAtOffset(PlatformWalkData._cleanupRequiredOffset_));
	}

	// U8 cleanupRequired
	public U8Pointer cleanupRequiredEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(PlatformWalkData._cleanupRequiredOffset_));
	}

	// sem_t_r client_sem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_client_semOffset_", declaredType="sem_t_r")
	public sem_t_rPointer client_sem() throws CorruptDataException {
		return sem_t_rPointer.cast(nonNullFieldEA(PlatformWalkData._client_semOffset_));
	}

	// sem_t_r client_sem
	public PointerPointer client_semEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PlatformWalkData._client_semOffset_));
	}

	// volatile U8 consistent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_consistentOffset_", declaredType="volatile U8")
	public U8 consistent() throws CorruptDataException {
		return new U8(getByteAtOffset(PlatformWalkData._consistentOffset_));
	}

	// volatile U8 consistent
	public U8Pointer consistentEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(PlatformWalkData._consistentOffset_));
	}

	// U64 controllerThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_controllerThreadOffset_", declaredType="U64")
	public UDATA controllerThread() throws CorruptDataException {
		return new U64(getLongAtOffset(PlatformWalkData._controllerThreadOffset_));
	}

	// U64 controllerThread
	public UDATAPointer controllerThreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(PlatformWalkData._controllerThreadOffset_));
	}

	// sem_t_r controller_sem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_controller_semOffset_", declaredType="sem_t_r")
	public sem_t_rPointer controller_sem() throws CorruptDataException {
		return sem_t_rPointer.cast(nonNullFieldEA(PlatformWalkData._controller_semOffset_));
	}

	// sem_t_r controller_sem
	public PointerPointer controller_semEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PlatformWalkData._controller_semOffset_));
	}

	// volatile U8 error
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errorOffset_", declaredType="volatile U8")
	public U8 error() throws CorruptDataException {
		return new U8(getByteAtOffset(PlatformWalkData._errorOffset_));
	}

	// volatile U8 error
	public U8Pointer errorEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(PlatformWalkData._errorOffset_));
	}

	// U64 filterThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_filterThreadOffset_", declaredType="U64")
	public UDATA filterThread() throws CorruptDataException {
		return new U64(getLongAtOffset(PlatformWalkData._filterThreadOffset_));
	}

	// U64 filterThread
	public UDATAPointer filterThreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(PlatformWalkData._filterThreadOffset_));
	}

	// sigaction oldHandler
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_oldHandlerOffset_", declaredType="sigaction")
	public sigactionPointer oldHandler() throws CorruptDataException {
		return sigactionPointer.cast(nonNullFieldEA(PlatformWalkData._oldHandlerOffset_));
	}

	// sigaction oldHandler
	public PointerPointer oldHandlerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PlatformWalkData._oldHandlerOffset_));
	}

	// sigset_t old_mask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_old_maskOffset_", declaredType="sigset_t")
	public sigset_tPointer old_mask() throws CorruptDataException {
		return sigset_tPointer.cast(nonNullFieldEA(PlatformWalkData._old_maskOffset_));
	}

	// sigset_t old_mask
	public PointerPointer old_maskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PlatformWalkData._old_maskOffset_));
	}

	// U8 platformAllocatedContext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_platformAllocatedContextOffset_", declaredType="U8")
	public U8 platformAllocatedContext() throws CorruptDataException {
		return new U8(getByteAtOffset(PlatformWalkData._platformAllocatedContextOffset_));
	}

	// U8 platformAllocatedContext
	public U8Pointer platformAllocatedContextEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(PlatformWalkData._platformAllocatedContextOffset_));
	}

	// barrier_r release_barrier
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_release_barrierOffset_", declaredType="barrier_r")
	public barrier_rPointer release_barrier() throws CorruptDataException {
		return barrier_rPointer.cast(nonNullFieldEA(PlatformWalkData._release_barrierOffset_));
	}

	// barrier_r release_barrier
	public PointerPointer release_barrierEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PlatformWalkData._release_barrierOffset_));
	}

	// J9ThreadWalkState* state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stateOffset_", declaredType="J9ThreadWalkState*")
	public J9ThreadWalkStatePointer state() throws CorruptDataException {
		return J9ThreadWalkStatePointer.cast(getPointerAtOffset(PlatformWalkData._stateOffset_));
	}

	// J9ThreadWalkState* state
	public PointerPointer stateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PlatformWalkData._stateOffset_));
	}

	// J9PlatformThread* thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadOffset_", declaredType="J9PlatformThread*")
	public J9PlatformThreadPointer thread() throws CorruptDataException {
		return J9PlatformThreadPointer.cast(getPointerAtOffset(PlatformWalkData._threadOffset_));
	}

	// J9PlatformThread* thread
	public PointerPointer threadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(PlatformWalkData._threadOffset_));
	}

	// I32 threadCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadCountOffset_", declaredType="I32")
	public IDATA threadCount() throws CorruptDataException {
		return new I32(getIntAtOffset(PlatformWalkData._threadCountOffset_));
	}

	// I32 threadCount
	public IDATAPointer threadCountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(PlatformWalkData._threadCountOffset_));
	}

	// I32 threadsOutstanding
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadsOutstandingOffset_", declaredType="I32")
	public IDATA threadsOutstanding() throws CorruptDataException {
		return new I32(getIntAtOffset(PlatformWalkData._threadsOutstandingOffset_));
	}

	// I32 threadsOutstanding
	public IDATAPointer threadsOutstandingEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(PlatformWalkData._threadsOutstandingOffset_));
	}

	// I32 uninitializedThreads
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uninitializedThreadsOffset_", declaredType="I32")
	public IDATA uninitializedThreads() throws CorruptDataException {
		return new I32(getIntAtOffset(PlatformWalkData._uninitializedThreadsOffset_));
	}

	// I32 uninitializedThreads
	public IDATAPointer uninitializedThreadsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(PlatformWalkData._uninitializedThreadsOffset_));
	}

}
