/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: StackFramePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the StackFramePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=StackFrame.class)
public class StackFramePointer extends StructurePointer {

	// NULL
	public static final StackFramePointer NULL = new StackFramePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected StackFramePointer(long address) {
		super(address);
	}

	public static StackFramePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static StackFramePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static StackFramePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new StackFramePointer(address);
	}

	public StackFramePointer add(long count) {
		return StackFramePointer.cast(address + (StackFrame.SIZEOF * count));
	}

	public StackFramePointer add(Scalar count) {
		return add(count.longValue());
	}

	public StackFramePointer addOffset(long offset) {
		return StackFramePointer.cast(address + offset);
	}

	public StackFramePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public StackFramePointer sub(long count) {
		return StackFramePointer.cast(address - (StackFrame.SIZEOF * count));
	}

	public StackFramePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public StackFramePointer subOffset(long offset) {
		return StackFramePointer.cast(address - offset);
	}

	public StackFramePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public StackFramePointer untag(long mask) {
		return StackFramePointer.cast(address & ~mask);
	}

	public StackFramePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return StackFrame.SIZEOF;
	}

	// Implementation methods

	// I32 bytecodeIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bytecodeIndexOffset_", declaredType="I32")
	public IDATA bytecodeIndex() throws CorruptDataException {
		return new I32(getIntAtOffset(StackFrame._bytecodeIndexOffset_));
	}

	// I32 bytecodeIndex
	public IDATAPointer bytecodeIndexEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(StackFrame._bytecodeIndexOffset_));
	}

	// FrameType frameType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_frameTypeOffset_", declaredType="FrameType")
	public long frameType() throws CorruptDataException {
		if (FrameType.SIZEOF == 1) {
			return getByteAtOffset(StackFrame._frameTypeOffset_);
		} else if (FrameType.SIZEOF == 2) {
			return getShortAtOffset(StackFrame._frameTypeOffset_);
		} else if (FrameType.SIZEOF == 4) {
			return getIntAtOffset(StackFrame._frameTypeOffset_);
		} else if (FrameType.SIZEOF == 8) {
			return getLongAtOffset(StackFrame._frameTypeOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// FrameType frameType
	public EnumPointer frameTypeEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(StackFrame._frameTypeOffset_), FrameType.class);
	}

	// I32 lineNumber
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lineNumberOffset_", declaredType="I32")
	public IDATA lineNumber() throws CorruptDataException {
		return new I32(getIntAtOffset(StackFrame._lineNumberOffset_));
	}

	// I32 lineNumber
	public IDATAPointer lineNumberEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(StackFrame._lineNumberOffset_));
	}

	// U32 methodIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_methodIndexOffset_", declaredType="U32")
	public UDATA methodIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(StackFrame._methodIndexOffset_));
	}

	// U32 methodIndex
	public UDATAPointer methodIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(StackFrame._methodIndexOffset_));
	}

}
