/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: vec_extPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the vec_extPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=vec_ext.class)
public class vec_extPointer extends StructurePointer {

	// NULL
	public static final vec_extPointer NULL = new vec_extPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected vec_extPointer(long address) {
		super(address);
	}

	public static vec_extPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static vec_extPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static vec_extPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new vec_extPointer(address);
	}

	public vec_extPointer add(long count) {
		return vec_extPointer.cast(address + (vec_ext.SIZEOF * count));
	}

	public vec_extPointer add(Scalar count) {
		return add(count.longValue());
	}

	public vec_extPointer addOffset(long offset) {
		return vec_extPointer.cast(address + offset);
	}

	public vec_extPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public vec_extPointer sub(long count) {
		return vec_extPointer.cast(address - (vec_ext.SIZEOF * count));
	}

	public vec_extPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public vec_extPointer subOffset(long offset) {
		return vec_extPointer.cast(address - offset);
	}

	public vec_extPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public vec_extPointer untag(long mask) {
		return vec_extPointer.cast(address & ~mask);
	}

	public vec_extPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return vec_ext.SIZEOF;
	}

	// Implementation methods

	// U32:1 has_varargs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_has_varargsOffset_", declaredType="U32:1")
	public UDATA has_varargs() throws CorruptDataException {
		return getU32Bitfield(vec_ext._has_varargs_s_, vec_ext._has_varargs_b_);
	}

	// U32:1 saves_vrsave
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_saves_vrsaveOffset_", declaredType="U32:1")
	public UDATA saves_vrsave() throws CorruptDataException {
		return getU32Bitfield(vec_ext._saves_vrsave_s_, vec_ext._saves_vrsave_b_);
	}

	// U32:1 vec_present
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vec_presentOffset_", declaredType="U32:1")
	public UDATA vec_present() throws CorruptDataException {
		return getU32Bitfield(vec_ext._vec_present_s_, vec_ext._vec_present_b_);
	}

	// U8[] vecparminfo
	public U8Pointer vecparminfoEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(vec_ext._vecparminfoOffset_));
	}

	// U32:7 vectorparms
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vectorparmsOffset_", declaredType="U32:7")
	public UDATA vectorparms() throws CorruptDataException {
		return getU32Bitfield(vec_ext._vectorparms_s_, vec_ext._vectorparms_b_);
	}

	// U32:6 vr_saved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vr_savedOffset_", declaredType="U32:6")
	public UDATA vr_saved() throws CorruptDataException {
		return getU32Bitfield(vec_ext._vr_saved_s_, vec_ext._vr_saved_b_);
	}

}
