/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9Thread
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9Thread {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _attachcountOffset_;
	public static final int _categoryOffset_;
	public static final int _conditionOffset_;
	public static final int _destroyed_monitor_headOffset_;
	public static final int _destroyed_monitor_tailOffset_;
	public static final int _effective_categoryOffset_;
	public static final int _entryargOffset_;
	public static final int _entrypointOffset_;
	public static final int _flagsOffset_;
	public static final int _handleOffset_;
	public static final int _interrupterOffset_;
	public static final int _key_deletion_attemptsOffset_;
	public static final int _lastCategorySwitchTimeOffset_;
	public static final int _libraryOffset_;
	public static final int _lockedmonitorcountOffset_;
	public static final int _monitorOffset_;
	public static final int _mutexOffset_;
	public static final int _nextOffset_;
	public static final int _os_errnoOffset_;
	public static final int _prevOffset_;
	public static final int _priorityOffset_;
	public static final int _stacksizeOffset_;
	public static final int _tidOffset_;
	public static final int _tlsOffset_;
	public static final int _tracingOffset_;
	public static final int _waitNumberOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_attachcountOffset_ = 0;
		_categoryOffset_ = 0;
		_conditionOffset_ = 0;
		_destroyed_monitor_headOffset_ = 0;
		_destroyed_monitor_tailOffset_ = 0;
		_effective_categoryOffset_ = 0;
		_entryargOffset_ = 0;
		_entrypointOffset_ = 0;
		_flagsOffset_ = 0;
		_handleOffset_ = 0;
		_interrupterOffset_ = 0;
		_key_deletion_attemptsOffset_ = 0;
		_lastCategorySwitchTimeOffset_ = 0;
		_libraryOffset_ = 0;
		_lockedmonitorcountOffset_ = 0;
		_monitorOffset_ = 0;
		_mutexOffset_ = 0;
		_nextOffset_ = 0;
		_os_errnoOffset_ = 0;
		_prevOffset_ = 0;
		_priorityOffset_ = 0;
		_stacksizeOffset_ = 0;
		_tidOffset_ = 0;
		_tlsOffset_ = 0;
		_tracingOffset_ = 0;
		_waitNumberOffset_ = 0;
	}

}
