/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: dr_info
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class dr_info {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _acc_update_s_;
	public static final int _acc_update_b_;
	public static final int _acu_s_;
	public static final int _acu_b_;
	public static final int _add_s_;
	public static final int _add_b_;
	public static final int _bcpuOffset_;
	public static final int _bindproc_s_;
	public static final int _bindproc_b_;
	public static final int _cap_constrained_s_;
	public static final int _cap_constrained_b_;
	public static final int _capacityOffset_;
	public static final int _check_s_;
	public static final int _check_b_;
	public static final int _checkpoint_s_;
	public static final int _checkpoint_b_;
	public static final int _chlmb_s_;
	public static final int _chlmb_b_;
	public static final int _cpu_s_;
	public static final int _cpu_b_;
	public static final int _delta_capOffset_;
	public static final int _delta_mem_capacityOffset_;
	public static final int _doit_s_;
	public static final int _doit_b_;
	public static final int _dr_opOffset_;
	public static final int _dr_padOffset_;
	public static final int _dr_wlmOffset_;
	public static final int _ent_cap_s_;
	public static final int _ent_cap_b_;
	public static final int _force_s_;
	public static final int _force_b_;
	public static final int _hardpset_s_;
	public static final int _hardpset_b_;
	public static final int _hibernate_s_;
	public static final int _hibernate_b_;
	public static final int _lcpuOffset_;
	public static final int _lvupOffset_;
	public static final int _mem_s_;
	public static final int _mem_b_;
	public static final int _mem_capacityOffset_;
	public static final int _migrate_s_;
	public static final int _migrate_b_;
	public static final int _partition_s_;
	public static final int _partition_b_;
	public static final int _phase_genOffset_;
	public static final int _plock_s_;
	public static final int _plock_b_;
	public static final int _post_s_;
	public static final int _post_b_;
	public static final int _posterror_s_;
	public static final int _posterror_b_;
	public static final int _pre_s_;
	public static final int _pre_b_;
	public static final int _pshm_s_;
	public static final int _pshm_b_;
	public static final int _rem_s_;
	public static final int _rem_b_;
	public static final int _req_memsz_changeOffset_;
	public static final int _res_padOffset_;
	public static final int _reservedOffset_;
	public static final int _restart_s_;
	public static final int _restart_b_;
	public static final int _softpset_s_;
	public static final int _softpset_b_;
	public static final int _splpar_capable_s_;
	public static final int _splpar_capable_b_;
	public static final int _splpar_capped_s_;
	public static final int _splpar_capped_b_;
	public static final int _splpar_shared_s_;
	public static final int _splpar_shared_b_;
	public static final int _sys_free_framesOffset_;
	public static final int _sys_memszOffset_;
	public static final int _sys_pinnable_framesOffset_;
	public static final int _sys_total_framesOffset_;
	public static final int _topology_update_s_;
	public static final int _topology_update_b_;
	public static final int _var_wgt_s_;
	public static final int _var_wgt_b_;
	public static final int _workload_partition_s_;
	public static final int _workload_partition_b_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_acc_update_s_ = 0;
		_acc_update_b_ = 0;
		_acu_s_ = 0;
		_acu_b_ = 0;
		_add_s_ = 0;
		_add_b_ = 0;
		_bcpuOffset_ = 0;
		_bindproc_s_ = 0;
		_bindproc_b_ = 0;
		_cap_constrained_s_ = 0;
		_cap_constrained_b_ = 0;
		_capacityOffset_ = 0;
		_check_s_ = 0;
		_check_b_ = 0;
		_checkpoint_s_ = 0;
		_checkpoint_b_ = 0;
		_chlmb_s_ = 0;
		_chlmb_b_ = 0;
		_cpu_s_ = 0;
		_cpu_b_ = 0;
		_delta_capOffset_ = 0;
		_delta_mem_capacityOffset_ = 0;
		_doit_s_ = 0;
		_doit_b_ = 0;
		_dr_opOffset_ = 0;
		_dr_padOffset_ = 0;
		_dr_wlmOffset_ = 0;
		_ent_cap_s_ = 0;
		_ent_cap_b_ = 0;
		_force_s_ = 0;
		_force_b_ = 0;
		_hardpset_s_ = 0;
		_hardpset_b_ = 0;
		_hibernate_s_ = 0;
		_hibernate_b_ = 0;
		_lcpuOffset_ = 0;
		_lvupOffset_ = 0;
		_mem_s_ = 0;
		_mem_b_ = 0;
		_mem_capacityOffset_ = 0;
		_migrate_s_ = 0;
		_migrate_b_ = 0;
		_partition_s_ = 0;
		_partition_b_ = 0;
		_phase_genOffset_ = 0;
		_plock_s_ = 0;
		_plock_b_ = 0;
		_post_s_ = 0;
		_post_b_ = 0;
		_posterror_s_ = 0;
		_posterror_b_ = 0;
		_pre_s_ = 0;
		_pre_b_ = 0;
		_pshm_s_ = 0;
		_pshm_b_ = 0;
		_rem_s_ = 0;
		_rem_b_ = 0;
		_req_memsz_changeOffset_ = 0;
		_res_padOffset_ = 0;
		_reservedOffset_ = 0;
		_restart_s_ = 0;
		_restart_b_ = 0;
		_softpset_s_ = 0;
		_softpset_b_ = 0;
		_splpar_capable_s_ = 0;
		_splpar_capable_b_ = 0;
		_splpar_capped_s_ = 0;
		_splpar_capped_b_ = 0;
		_splpar_shared_s_ = 0;
		_splpar_shared_b_ = 0;
		_sys_free_framesOffset_ = 0;
		_sys_memszOffset_ = 0;
		_sys_pinnable_framesOffset_ = 0;
		_sys_total_framesOffset_ = 0;
		_topology_update_s_ = 0;
		_topology_update_b_ = 0;
		_var_wgt_s_ = 0;
		_var_wgt_b_ = 0;
		_workload_partition_s_ = 0;
		_workload_partition_b_ = 0;
	}

}
