/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: thrdentry64
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class thrdentry64 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _ti_affinityOffset_;
	public static final int _ti_codeOffset_;
	public static final int _ti_cpuOffset_;
	public static final int _ti_cpuidOffset_;
	public static final int _ti_cursigOffset_;
	public static final int _ti_dispctOffset_;
	public static final int _ti_errnoppOffset_;
	public static final int _ti_flagOffset_;
	public static final int _ti_flag2Offset_;
	public static final int _ti_fpuctOffset_;
	public static final int _ti_home_sradidOffset_;
	public static final int _ti_local_dispctOffset_;
	public static final int _ti_niceOffset_;
	public static final int _ti_oldmaskOffset_;
	public static final int _ti_padOffset_;
	public static final int _ti_pad0Offset_;
	public static final int _ti_pidOffset_;
	public static final int _ti_policyOffset_;
	public static final int _ti_priOffset_;
	public static final int _ti_ruOffset_;
	public static final int _ti_scountOffset_;
	public static final int _ti_scpOffset_;
	public static final int _ti_sigOffset_;
	public static final int _ti_sigmaskOffset_;
	public static final int _ti_sigspOffset_;
	public static final int _ti_sigsszOffset_;
	public static final int _ti_sizeOffset_;
	public static final int _ti_startOffset_;
	public static final int _ti_stateOffset_;
	public static final int _ti_stkbOffset_;
	public static final int _ti_ticksOffset_;
	public static final int _ti_tidOffset_;
	public static final int _ti_ucontextOffset_;
	public static final int _ti_userdataOffset_;
	public static final int _ti_ustkOffset_;
	public static final int _ti_watchOffset_;
	public static final int _ti_wchanOffset_;
	public static final int _ti_wtypeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_ti_affinityOffset_ = 0;
		_ti_codeOffset_ = 0;
		_ti_cpuOffset_ = 0;
		_ti_cpuidOffset_ = 0;
		_ti_cursigOffset_ = 0;
		_ti_dispctOffset_ = 0;
		_ti_errnoppOffset_ = 0;
		_ti_flagOffset_ = 0;
		_ti_flag2Offset_ = 0;
		_ti_fpuctOffset_ = 0;
		_ti_home_sradidOffset_ = 0;
		_ti_local_dispctOffset_ = 0;
		_ti_niceOffset_ = 0;
		_ti_oldmaskOffset_ = 0;
		_ti_padOffset_ = 0;
		_ti_pad0Offset_ = 0;
		_ti_pidOffset_ = 0;
		_ti_policyOffset_ = 0;
		_ti_priOffset_ = 0;
		_ti_ruOffset_ = 0;
		_ti_scountOffset_ = 0;
		_ti_scpOffset_ = 0;
		_ti_sigOffset_ = 0;
		_ti_sigmaskOffset_ = 0;
		_ti_sigspOffset_ = 0;
		_ti_sigsszOffset_ = 0;
		_ti_sizeOffset_ = 0;
		_ti_startOffset_ = 0;
		_ti_stateOffset_ = 0;
		_ti_stkbOffset_ = 0;
		_ti_ticksOffset_ = 0;
		_ti_tidOffset_ = 0;
		_ti_ucontextOffset_ = 0;
		_ti_userdataOffset_ = 0;
		_ti_ustkOffset_ = 0;
		_ti_watchOffset_ = 0;
		_ti_wchanOffset_ = 0;
		_ti_wtypeOffset_ = 0;
	}

}
