/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: hostent_dataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the hostent_dataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=hostent_data.class)
public class hostent_dataPointer extends StructurePointer {

	// NULL
	public static final hostent_dataPointer NULL = new hostent_dataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected hostent_dataPointer(long address) {
		super(address);
	}

	public static hostent_dataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static hostent_dataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static hostent_dataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new hostent_dataPointer(address);
	}

	public hostent_dataPointer add(long count) {
		return hostent_dataPointer.cast(address + (hostent_data.SIZEOF * count));
	}

	public hostent_dataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public hostent_dataPointer addOffset(long offset) {
		return hostent_dataPointer.cast(address + offset);
	}

	public hostent_dataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public hostent_dataPointer sub(long count) {
		return hostent_dataPointer.cast(address - (hostent_data.SIZEOF * count));
	}

	public hostent_dataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public hostent_dataPointer subOffset(long offset) {
		return hostent_dataPointer.cast(address - offset);
	}

	public hostent_dataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public hostent_dataPointer untag(long mask) {
		return hostent_dataPointer.cast(address & ~mask);
	}

	public hostent_dataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return hostent_data.SIZEOF;
	}

	// Implementation methods

	// void* _host_reserv1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__host_reserv1Offset_", declaredType="void*")
	public VoidPointer _host_reserv1() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(hostent_data.__host_reserv1Offset_));
	}

	// void* _host_reserv1
	public PointerPointer _host_reserv1EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(hostent_data.__host_reserv1Offset_));
	}

	// void* _host_reserv2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__host_reserv2Offset_", declaredType="void*")
	public VoidPointer _host_reserv2() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(hostent_data.__host_reserv2Offset_));
	}

	// void* _host_reserv2
	public PointerPointer _host_reserv2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(hostent_data.__host_reserv2Offset_));
	}

	// U8* current
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_currentOffset_", declaredType="U8*")
	public U8Pointer current() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(hostent_data._currentOffset_));
	}

	// U8* current
	public PointerPointer currentEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(hostent_data._currentOffset_));
	}

	// I32 currentlen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_currentlenOffset_", declaredType="I32")
	public IDATA currentlen() throws CorruptDataException {
		return new I32(getIntAtOffset(hostent_data._currentlenOffset_));
	}

	// I32 currentlen
	public IDATAPointer currentlenEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(hostent_data._currentlenOffset_));
	}

	// U8[] domain
	public U8Pointer domainEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(hostent_data._domainOffset_));
	}

	// U8*[] h_addr_ptrs
	public PointerPointer h_addr_ptrsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(hostent_data._h_addr_ptrsOffset_));
	}

	// in_addr host_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_host_addrOffset_", declaredType="in_addr")
	public in_addrPointer host_addr() throws CorruptDataException {
		return in_addrPointer.cast(nonNullFieldEA(hostent_data._host_addrOffset_));
	}

	// in_addr host_addr
	public PointerPointer host_addrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(hostent_data._host_addrOffset_));
	}

	// ulong[] host_addresses
	public UDATAPointer host_addressesEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(hostent_data._host_addressesOffset_));
	}

	// U8*[] host_addrs
	public PointerPointer host_addrsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(hostent_data._host_addrsOffset_));
	}

	// U8*[] host_aliases
	public PointerPointer host_aliasesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(hostent_data._host_aliasesOffset_));
	}

	// U8[] hostaddr
	public U8Pointer hostaddrEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(hostent_data._hostaddrOffset_));
	}

	// U8[] hostbuf
	public U8Pointer hostbufEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(hostent_data._hostbufOffset_));
	}

	// FILE* hostf
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hostfOffset_", declaredType="FILE*")
	public FILEPointer hostf() throws CorruptDataException {
		return FILEPointer.cast(getPointerAtOffset(hostent_data._hostfOffset_));
	}

	// FILE* hostf
	public PointerPointer hostfEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(hostent_data._hostfOffset_));
	}

	// I32 stayopen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stayopenOffset_", declaredType="I32")
	public IDATA stayopen() throws CorruptDataException {
		return new I32(getIntAtOffset(hostent_data._stayopenOffset_));
	}

	// I32 stayopen
	public IDATAPointer stayopenEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(hostent_data._stayopenOffset_));
	}

	// I32 this_service
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_this_serviceOffset_", declaredType="I32")
	public IDATA this_service() throws CorruptDataException {
		return new I32(getIntAtOffset(hostent_data._this_serviceOffset_));
	}

	// I32 this_service
	public IDATAPointer this_serviceEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(hostent_data._this_serviceOffset_));
	}

}
