/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: perfstat_partition_total_t
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class perfstat_partition_total_t {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _IOHighWaterMarkOffset_;
	public static final int _IOMemEntFreeOffset_;
	public static final int _IOMemEntInUseOffset_;
	public static final int _MemPoolSizeOffset_;
	public static final int _ame_deficit_sizeOffset_;
	public static final int _ame_versionOffset_;
	public static final int _ams_pool_idOffset_;
	public static final int _busy_donated_purrOffset_;
	public static final int _busy_donated_spurrOffset_;
	public static final int _busy_stolen_purrOffset_;
	public static final int _busy_stolen_spurrOffset_;
	public static final int _cmcs_total_timeOffset_;
	public static final int _current_memexp_factrOffset_;
	public static final int _entitled_pool_capacityOffset_;
	public static final int _entitled_proc_capacityOffset_;
	public static final int _expanded_memoryOffset_;
	public static final int _group_idOffset_;
	public static final int _hardwareidOffset_;
	public static final int _hpiOffset_;
	public static final int _hpitOffset_;
	public static final int _hypv_pagesizeOffset_;
	public static final int _idle_donated_purrOffset_;
	public static final int _idle_donated_spurrOffset_;
	public static final int _idle_stolen_purrOffset_;
	public static final int _idle_stolen_spurrOffset_;
	public static final int _invol_virt_cswitchOffset_;
	public static final int _iomeOffset_;
	public static final int _lpar_idOffset_;
	public static final int _max_cpool_sizeOffset_;
	public static final int _max_cpusOffset_;
	public static final int _max_memoryOffset_;
	public static final int _max_phys_cpus_sysOffset_;
	public static final int _max_pool_capacityOffset_;
	public static final int _max_proc_capacityOffset_;
	public static final int _min_cpusOffset_;
	public static final int _min_memoryOffset_;
	public static final int _min_proc_capacityOffset_;
	public static final int _min_ucpool_sizeOffset_;
	public static final int _nameOffset_;
	public static final int _online_cpusOffset_;
	public static final int _online_lcpusOffset_;
	public static final int _online_memoryOffset_;
	public static final int _online_phys_cpus_sysOffset_;
	public static final int _phantintrsOffset_;
	public static final int _phys_cpus_poolOffset_;
	public static final int _pidleOffset_;
	public static final int _pidle_spurrOffset_;
	public static final int _pmemOffset_;
	public static final int _pool_busy_timeOffset_;
	public static final int _pool_idOffset_;
	public static final int _pool_idle_timeOffset_;
	public static final int _pool_max_timeOffset_;
	public static final int _pool_scaled_busy_timeOffset_;
	public static final int _power_save_modeOffset_;
	public static final int _proc_capacity_incrementOffset_;
	public static final int _psysOffset_;
	public static final int _psys_spurrOffset_;
	public static final int _purr_coalescingOffset_;
	public static final int _purr_counterOffset_;
	public static final int _puserOffset_;
	public static final int _puser_spurrOffset_;
	public static final int _pwaitOffset_;
	public static final int _pwait_spurrOffset_;
	public static final int _real_availOffset_;
	public static final int _real_freeOffset_;
	public static final int _reserved_pagesOffset_;
	public static final int _reserved_pagesizeOffset_;
	public static final int _shcpu_busy_timeOffset_;
	public static final int _shcpu_scaled_busy_timeOffset_;
	public static final int _shcpu_tot_timeOffset_;
	public static final int _shcpus_in_sysOffset_;
	public static final int _smt_thrdsOffset_;
	public static final int _spurr_coalescingOffset_;
	public static final int _spurr_counterOffset_;
	public static final int _spurrflagOffset_;
	public static final int _target_cpool_sizeOffset_;
	public static final int _target_memexp_factrOffset_;
	public static final int _timebase_lastOffset_;
	public static final int _true_memoryOffset_;
	public static final int _typeOffset_;
	public static final int _unalloc_proc_capacityOffset_;
	public static final int _unalloc_var_proc_capacity_weightOffset_;
	public static final int _var_mem_weightOffset_;
	public static final int _var_proc_capacity_weightOffset_;
	public static final int _versionOffset_;
	public static final int _vol_virt_cswitchOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_IOHighWaterMarkOffset_ = 0;
		_IOMemEntFreeOffset_ = 0;
		_IOMemEntInUseOffset_ = 0;
		_MemPoolSizeOffset_ = 0;
		_ame_deficit_sizeOffset_ = 0;
		_ame_versionOffset_ = 0;
		_ams_pool_idOffset_ = 0;
		_busy_donated_purrOffset_ = 0;
		_busy_donated_spurrOffset_ = 0;
		_busy_stolen_purrOffset_ = 0;
		_busy_stolen_spurrOffset_ = 0;
		_cmcs_total_timeOffset_ = 0;
		_current_memexp_factrOffset_ = 0;
		_entitled_pool_capacityOffset_ = 0;
		_entitled_proc_capacityOffset_ = 0;
		_expanded_memoryOffset_ = 0;
		_group_idOffset_ = 0;
		_hardwareidOffset_ = 0;
		_hpiOffset_ = 0;
		_hpitOffset_ = 0;
		_hypv_pagesizeOffset_ = 0;
		_idle_donated_purrOffset_ = 0;
		_idle_donated_spurrOffset_ = 0;
		_idle_stolen_purrOffset_ = 0;
		_idle_stolen_spurrOffset_ = 0;
		_invol_virt_cswitchOffset_ = 0;
		_iomeOffset_ = 0;
		_lpar_idOffset_ = 0;
		_max_cpool_sizeOffset_ = 0;
		_max_cpusOffset_ = 0;
		_max_memoryOffset_ = 0;
		_max_phys_cpus_sysOffset_ = 0;
		_max_pool_capacityOffset_ = 0;
		_max_proc_capacityOffset_ = 0;
		_min_cpusOffset_ = 0;
		_min_memoryOffset_ = 0;
		_min_proc_capacityOffset_ = 0;
		_min_ucpool_sizeOffset_ = 0;
		_nameOffset_ = 0;
		_online_cpusOffset_ = 0;
		_online_lcpusOffset_ = 0;
		_online_memoryOffset_ = 0;
		_online_phys_cpus_sysOffset_ = 0;
		_phantintrsOffset_ = 0;
		_phys_cpus_poolOffset_ = 0;
		_pidleOffset_ = 0;
		_pidle_spurrOffset_ = 0;
		_pmemOffset_ = 0;
		_pool_busy_timeOffset_ = 0;
		_pool_idOffset_ = 0;
		_pool_idle_timeOffset_ = 0;
		_pool_max_timeOffset_ = 0;
		_pool_scaled_busy_timeOffset_ = 0;
		_power_save_modeOffset_ = 0;
		_proc_capacity_incrementOffset_ = 0;
		_psysOffset_ = 0;
		_psys_spurrOffset_ = 0;
		_purr_coalescingOffset_ = 0;
		_purr_counterOffset_ = 0;
		_puserOffset_ = 0;
		_puser_spurrOffset_ = 0;
		_pwaitOffset_ = 0;
		_pwait_spurrOffset_ = 0;
		_real_availOffset_ = 0;
		_real_freeOffset_ = 0;
		_reserved_pagesOffset_ = 0;
		_reserved_pagesizeOffset_ = 0;
		_shcpu_busy_timeOffset_ = 0;
		_shcpu_scaled_busy_timeOffset_ = 0;
		_shcpu_tot_timeOffset_ = 0;
		_shcpus_in_sysOffset_ = 0;
		_smt_thrdsOffset_ = 0;
		_spurr_coalescingOffset_ = 0;
		_spurr_counterOffset_ = 0;
		_spurrflagOffset_ = 0;
		_target_cpool_sizeOffset_ = 0;
		_target_memexp_factrOffset_ = 0;
		_timebase_lastOffset_ = 0;
		_true_memoryOffset_ = 0;
		_typeOffset_ = 0;
		_unalloc_proc_capacityOffset_ = 0;
		_unalloc_var_proc_capacity_weightOffset_ = 0;
		_var_mem_weightOffset_ = 0;
		_var_proc_capacity_weightOffset_ = 0;
		_versionOffset_ = 0;
		_vol_virt_cswitchOffset_ = 0;
	}

}
