/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java2d.DemoImages;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Intro
extends JPanel {
    private static final Color myBlack = new Color(20, 20, 20);
    private static final Color myWhite = new Color(240, 240, 255);
    private static final Color myRed = new Color(149, 43, 42);
    private static final Color myBlue = new Color(94, 105, 176);
    private static final Color myYellow = new Color(255, 255, 140);
    private ScenesTable scenesTable;
    private boolean doTable;
    private final Surface surface;

    public Intro() {
        EmptyBorder eb = new EmptyBorder(80, 110, 80, 110);
        BevelBorder bb = new BevelBorder(1);
        this.setBorder(new CompoundBorder(eb, bb));
        this.setLayout(new BorderLayout());
        this.setBackground(Color.GRAY);
        this.setToolTipText("click for scene table");
        this.surface = new Surface();
        this.add(this.surface);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intro.this.removeAll();
                Intro.this.doTable = !Intro.this.doTable;
                if (Intro.this.doTable) {
                    Intro.this.setToolTipText("click for animation");
                    Intro.this.surface.stop();
                    if (Intro.this.scenesTable == null) {
                        Intro.this.scenesTable = new ScenesTable(Intro.this);
                    }
                    Intro.this.add(Intro.this.scenesTable);
                } else {
                    Intro.this.setToolTipText("click for scene table");
                    Intro.this.surface.start();
                    Intro.this.add(Intro.this.surface);
                }
                Intro.this.revalidate();
                Intro.this.repaint();
            }
        });
    }

    public void start() {
        if (!this.doTable) {
            this.surface.start();
        }
    }

    public void stop() {
        if (!this.doTable) {
            this.surface.stop();
        }
    }

    public static void main(String[] argv) {
        final Intro intro = new Intro();
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                intro.start();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                intro.stop();
            }
        };
        JFrame f = new JFrame("Java2D(TM) Demo - Intro");
        f.addWindowListener(l);
        f.getContentPane().add("Center", intro);
        f.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 720;
        int h = 510;
        f.setLocation(screenSize.width / 2 - w / 2, screenSize.height / 2 - h / 2);
        f.setSize(w, h);
        f.setVisible(true);
        intro.start();
    }

    static class Surface
    extends JPanel
    implements Runnable {
        private final Image dukeanim;
        private final Image duke;
        private BufferedImage bimg;
        public Director director;
        public int index;
        public long sleepAmt = 30L;
        private Thread thread;

        public Surface() {
            this.setBackground(myBlack);
            this.setLayout(new BorderLayout());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (thread == null) {
                        this.start();
                    } else {
                        this.stop();
                    }
                }
            });
            this.dukeanim = DemoImages.getImage("duke.running.gif", this);
            this.duke = DemoImages.getImage("duke.png", this);
            this.director = new Director(this);
        }

        public FontMetrics getMetrics(Font font) {
            return this.getFontMetrics(font);
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            if (d.width <= 0 || d.height <= 0) {
                return;
            }
            if (this.bimg == null || this.bimg.getWidth() != d.width || this.bimg.getHeight() != d.height) {
                this.bimg = this.getGraphicsConfiguration().createCompatibleImage(d.width, d.height);
                for (int i = this.index + 1; i < this.director.size(); ++i) {
                    ((Scene)this.director.get(i)).reset(d.width, d.height);
                }
            }
            Scene scene = (Scene)this.director.get(this.index);
            if (scene.index <= scene.length) {
                if (this.thread != null) {
                    scene.step(d.width, d.height);
                }
                Graphics2D g2 = this.bimg.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setBackground(this.getBackground());
                g2.clearRect(0, 0, d.width, d.height);
                scene.render(d.width, d.height, g2);
                if (this.thread != null) {
                    ++scene.index;
                }
                g2.dispose();
            }
            g.drawImage(this.bimg, 0, 0, this);
        }

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setPriority(1);
                this.thread.setName("Intro");
                this.thread.start();
            }
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
            this.notifyAll();
        }

        public void reset() {
            this.index = 0;
            Dimension d = this.getSize();
            for (Scene scene : this.director) {
                scene.reset(d.width, d.height);
            }
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me && !this.isShowing() || this.getSize().width <= 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (this.index == 0) {
                this.reset();
            }
            while (this.thread == me) {
                Scene scene = (Scene)this.director.get(this.index);
                if (((Boolean)scene.participate).booleanValue()) {
                    this.repaint();
                    try {
                        Thread.sleep(this.sleepAmt);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (scene.index <= scene.length) continue;
                    scene.pause();
                    if (++this.index < this.director.size()) continue;
                    this.reset();
                    continue;
                }
                if (++this.index < this.director.size()) continue;
                this.reset();
            }
            this.thread = null;
        }

        static class Contributors
        implements Part {
            private static final String[] members = new String[]{"Brian Lichtenwalter", "Jeannette Hung", "Thanh Nguyen", "Jim Graham", "Jerry Evans", "John Raley", "Michael Peirce", "Robert Kim", "Jennifer Ball", "Deborah Adair", "Paul Charlton", "Dmitry Feld", "Gregory Stone", "Richard Blanchard", "Link Perry", "Phil Race", "Vincent Hardy", "Parry Kejriwal", "Doug Felt", "Rekha Rangarajan", "Paula Patel", "Michael Bundschuh", "Joe Warzecha", "Joey Beheler", "Aastha Bhardwaj", "Daniel Rice", "Chris Campbell", "Shinsuke Fukuda", "Dmitri Trembovetski", "Chet Haase", "Jennifer Godinez", "Nicholas Talian", "Raul Vera", "Ankit Patel", "Ilya Bagrak", "Praveen Mohan", "Rakesh Menon"};
            private static final Font font = new Font("Serif", 0, 26);
            private final FontMetrics fm;
            private int beginning;
            private int ending;
            private int nStrs;
            private int strH;
            private int index;
            private int yh;
            private int height;
            private List<String> v = new ArrayList<String>();
            private List<String> cast = new ArrayList<String>(members.length + 3);
            private int counter;
            private int cntMod;
            private GradientPaint gp;

            public Contributors(int beg, int end, Surface surf) {
                this.beginning = beg;
                this.ending = end;
                this.fm = surf.getMetrics(font);
                Arrays.sort(members);
                this.cast.add("CONTRIBUTORS");
                this.cast.add(" ");
                this.cast.addAll(Arrays.asList(members));
                this.cast.add(" ");
                this.cast.add(" ");
                this.cntMod = (this.ending - this.beginning) / this.cast.size() - 1;
            }

            @Override
            public void reset(int w, int h) {
                this.v.clear();
                this.strH = this.fm.getAscent() + this.fm.getDescent();
                this.nStrs = (h - 40) / this.strH + 1;
                this.height = this.strH * (this.nStrs - 1) + 48;
                this.index = 0;
                this.gp = new GradientPaint(0.0f, h / 2, Color.WHITE, 0.0f, h + 20, Color.BLACK);
                this.counter = 0;
            }

            @Override
            public void step(int w, int h) {
                if (this.counter++ % this.cntMod == 0) {
                    if (this.index < this.cast.size()) {
                        this.v.add(this.cast.get(this.index));
                    }
                    if (!(this.v.size() != this.nStrs && this.index < this.cast.size() || this.v.isEmpty())) {
                        this.v.remove(0);
                    }
                    ++this.index;
                }
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                g2.setPaint(this.gp);
                g2.setFont(font);
                double remainder = this.counter % this.cntMod;
                double incr = 1.0 - remainder / (double)this.cntMod;
                incr = incr == 1.0 ? 0.0 : incr;
                int y = (int)(incr * (double)this.strH);
                y = this.index >= this.cast.size() ? this.yh + y : (this.yh = this.height - this.v.size() * this.strH + y);
                for (String s : this.v) {
                    g2.drawString(s, w / 2 - this.fm.stringWidth(s) / 2, y += this.strH);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class Features
        implements Part {
            static final int GRAPHICS = 0;
            static final int TEXT = 1;
            static final int IMAGES = 2;
            static final int COLOR = 3;
            static final Font font1 = new Font("Serif", 1, 38);
            static final Font font2 = new Font("Serif", 0, 24);
            private final FontMetrics fm1;
            private final FontMetrics fm2;
            private static final String[][] table = new String[][]{{"Graphics", "Antialiased rendering", "Bezier paths", "Transforms", "Compositing", "Stroking parameters"}, {"Text", "Extended font support", "Advanced text layout", "Dynamic font loading", "AttributeSets for font customization"}, {"Images", "Flexible image layouts", "Extended imaging operations", "   Convolutions, Lookup Tables", "RenderableImage interface"}, {"Color", "ICC profile support", "Color conversion", "Arbitrary color spaces"}};
            private String[] list;
            private int beginning;
            private int ending;
            private int strH;
            private int endIndex;
            private int listIndex;
            private List<String> v = new ArrayList<String>();

            public Features(int type, int beg, int end, Surface surf) {
                this.list = table[type];
                this.beginning = beg;
                this.ending = end;
                this.fm1 = surf.getMetrics(font1);
                this.fm2 = surf.getMetrics(font2);
            }

            @Override
            public void reset(int w, int h) {
                this.strH = this.fm2.getAscent() + this.fm2.getDescent();
                this.endIndex = 1;
                this.listIndex = 0;
                this.v.clear();
                this.v.add(this.list[this.listIndex].substring(0, this.endIndex));
            }

            @Override
            public void step(int w, int h) {
                if (this.listIndex < this.list.length) {
                    if (++this.endIndex > this.list[this.listIndex].length()) {
                        if (++this.listIndex < this.list.length) {
                            this.endIndex = 1;
                            this.v.add(this.list[this.listIndex].substring(0, this.endIndex));
                        }
                    } else {
                        this.v.set(this.listIndex, this.list[this.listIndex].substring(0, this.endIndex));
                    }
                }
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                g2.setColor(myWhite);
                g2.setFont(font1);
                g2.drawString(this.v.get(0), 90, 85);
                g2.setFont(font2);
                int y = 90;
                for (int i = 1; i < this.v.size(); ++i) {
                    g2.drawString(this.v.get(i), 120, y += this.strH);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class Temp
        implements Part {
            static final int NOANIM = 1;
            static final int RECT = 2;
            static final int IMG = 4;
            static final int RNA = 3;
            static final int INA = 5;
            private int beginning;
            private int ending;
            private float alpha;
            private float aIncr;
            private int type;
            private Rectangle rect1;
            private Rectangle rect2;
            private int x;
            private int y;
            private int xIncr;
            private int yIncr;
            private Image img;

            public Temp(int type, Image img, int beg, int end) {
                this.type = type;
                this.img = img;
                this.beginning = beg;
                this.ending = end;
                this.aIncr = 0.9f / (float)(this.ending - this.beginning);
                if ((type & 1) != 0) {
                    this.alpha = 1.0f;
                }
            }

            @Override
            public void reset(int w, int h) {
                this.rect1 = new Rectangle(8, 20, w - 20, 30);
                this.rect2 = new Rectangle(20, 8, 30, h - 20);
                if ((this.type & 1) == 0) {
                    this.alpha = 0.0f;
                    this.xIncr = w / (this.ending - this.beginning);
                    this.yIncr = h / (this.ending - this.beginning);
                    this.x = w + (int)((double)this.xIncr * 1.4);
                    this.y = h + (int)((double)this.yIncr * 1.4);
                }
            }

            @Override
            public void step(int w, int h) {
                if ((this.type & 1) != 0) {
                    return;
                }
                if ((this.type & 2) != 0) {
                    this.rect1.setLocation(this.x -= this.xIncr, 20);
                    this.rect2.setLocation(20, this.y -= this.yIncr);
                }
                if ((this.type & 4) != 0) {
                    this.alpha += this.aIncr;
                }
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                if ((this.type & 2) != 0) {
                    g2.setColor(myBlue);
                    g2.fill(this.rect1);
                    g2.setColor(myRed);
                    g2.fill(this.rect2);
                }
                if ((this.type & 4) != 0) {
                    Composite saveAC = g2.getComposite();
                    if (this.alpha >= 0.0f && this.alpha <= 1.0f) {
                        g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    }
                    g2.drawImage(this.img, 30, 30, null);
                    g2.setComposite(saveAC);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class LnE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int R = 4;
            static final int ZOOM = 8;
            static final int AC = 32;
            static final int RI = 5;
            static final int RD = 6;
            static final int ZOOMI = 9;
            static final int ZOOMD = 10;
            static final int ACI = 33;
            static final int ACD = 34;
            private int beginning;
            private int ending;
            private double rIncr;
            private double rotate;
            private double zIncr;
            private double zoom;
            private List<Point2D.Double> pts = new ArrayList<Point2D.Double>();
            private float alpha;
            private float aIncr;
            private int type;

            public LnE(int type, int beg, int end) {
                this.type = type;
                this.beginning = beg;
                this.ending = end;
                float range = this.ending - this.beginning;
                this.rIncr = 360.0f / range;
                this.aIncr = 0.9f / range;
                this.zIncr = 2.0f / range;
                if ((type & 2) != 0) {
                    this.rIncr = -this.rIncr;
                    this.aIncr = -this.aIncr;
                    this.zIncr = -this.zIncr;
                }
            }

            public void generatePts(int w, int h, double sizeF) {
                this.pts.clear();
                double size = (double)Math.min(w, h) * sizeF;
                Ellipse2D.Double ellipse = new Ellipse2D.Double((double)(w / 2) - size / 2.0, (double)(h / 2) - size / 2.0, size, size);
                PathIterator pi = ellipse.getPathIterator(null, 0.8);
                while (!pi.isDone()) {
                    double[] pt = new double[6];
                    switch (pi.currentSegment(pt)) {
                        case 0: 
                        case 1: {
                            this.pts.add(new Point2D.Double(pt[0], pt[1]));
                        }
                    }
                    pi.next();
                }
            }

            @Override
            public void reset(int w, int h) {
                if ((this.type & 2) != 0) {
                    this.rotate = 360.0;
                    this.alpha = 1.0f;
                    this.zoom = 2.0;
                } else {
                    this.alpha = 0.0f;
                    this.rotate = 0.0f;
                    this.zoom = 0.0;
                }
                if ((this.type & 8) == 0) {
                    this.generatePts(w, h, 0.5);
                }
            }

            @Override
            public void step(int w, int h) {
                if ((this.type & 8) != 0) {
                    this.generatePts(w, h, this.zoom += this.zIncr);
                }
                if ((this.type & 5) != 0 || (this.type & 5) != 0) {
                    this.rotate += this.rIncr;
                }
                if ((this.type & 0x21) != 0 || (this.type & 0x22) != 0) {
                    this.alpha += this.aIncr;
                }
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                Composite saveAC = null;
                if ((this.type & 0x20) != 0 && this.alpha >= 0.0f && this.alpha <= 1.0f) {
                    saveAC = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
                }
                AffineTransform saveTx = null;
                if ((this.type & 4) != 0) {
                    saveTx = g2.getTransform();
                    AffineTransform at = new AffineTransform();
                    at.rotate(Math.toRadians(this.rotate), w / 2, h / 2);
                    g2.setTransform(at);
                }
                Point2D.Double p1 = new Point2D.Double(w / 2, h / 2);
                g2.setColor(Color.YELLOW);
                for (Point2D point2D : this.pts) {
                    g2.draw(new Line2D.Float(p1, point2D));
                }
                if (saveTx != null) {
                    g2.setTransform(saveTx);
                }
                if (saveAC != null) {
                    g2.setComposite(saveAC);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class SiE
        implements Part {
            private final Surface surf;
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private double rIncr;
            private double sIncr;
            private double scale;
            private double rotate;
            private int siw;
            private int sih;
            private List<BufferedImage> subs = new ArrayList<BufferedImage>(20);
            private List<Point> pts = new ArrayList<Point>(20);

            public SiE(int siw, int sih, int beg, int end, Surface surf) {
                this.siw = siw;
                this.sih = sih;
                this.beginning = beg;
                this.ending = end;
                this.surf = surf;
                this.rIncr = 360.0 / (double)(this.ending - this.beginning);
                this.sIncr = 1.0 / (double)(this.ending - this.beginning);
            }

            @Override
            public void reset(int w, int h) {
                this.scale = 1.0;
                this.rotate = 0.0;
                this.bimg = null;
                this.subs.clear();
                this.pts.clear();
            }

            @Override
            public void step(int w, int h) {
                if (this.bimg == null) {
                    int biw = this.surf.bimg.getWidth();
                    int bih = this.surf.bimg.getHeight();
                    this.bimg = new BufferedImage(biw, bih, 1);
                    Graphics2D big = this.bimg.createGraphics();
                    big.drawImage((Image)this.surf.bimg, 0, 0, null);
                    for (int x = 0; x < w && this.scale > 0.0; x += this.siw) {
                        int ww = x + this.siw < w ? this.siw : w - x;
                        for (int y = 0; y < h; y += this.sih) {
                            int hh = y + this.sih < h ? this.sih : h - y;
                            this.subs.add(this.bimg.getSubimage(x, y, ww, hh));
                            this.pts.add(new Point(x, y));
                        }
                    }
                }
                this.rotate += this.rIncr;
                this.scale -= this.sIncr;
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                AffineTransform saveTx = g2.getTransform();
                g2.setColor(myBlue);
                for (int i = 0; i < this.subs.size() && this.scale > 0.0; ++i) {
                    BufferedImage bi = this.subs.get(i);
                    Point p = this.pts.get(i);
                    int ww = bi.getWidth();
                    int hh = bi.getHeight();
                    AffineTransform at = new AffineTransform();
                    at.rotate(Math.toRadians(this.rotate), p.x + ww / 2, p.y + hh / 2);
                    at.translate(p.x, p.y);
                    at.scale(this.scale, this.scale);
                    Rectangle b1 = new Rectangle(0, 0, ww, hh);
                    Shape shape = at.createTransformedShape(b1);
                    Rectangle2D b2 = shape.getBounds2D();
                    double xx = (double)(p.x + ww / 2) - (b2.getX() + b2.getWidth() / 2.0);
                    double yy = (double)(p.y + hh / 2) - (b2.getY() + b2.getHeight() / 2.0);
                    AffineTransform toCenterAT = new AffineTransform();
                    toCenterAT.translate(xx, yy);
                    toCenterAT.concatenate(at);
                    g2.setTransform(toCenterAT);
                    g2.drawImage((Image)bi, 0, 0, null);
                    g2.draw(b1);
                }
                g2.setTransform(saveTx);
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class DdE
        implements Part {
            private final Surface surf;
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private Graphics2D big;
            private List<Integer> list;
            private List<Integer> xlist;
            private List<Integer> ylist;
            private int xeNum;
            private int yeNum;
            private int xcSize;
            private int ycSize;
            private int inc;
            private int blocksize;

            public DdE(int beg, int end, int blocksize, Surface surf) {
                this.beginning = beg;
                this.ending = end;
                this.blocksize = blocksize;
                this.surf = surf;
            }

            private void createShuffledLists() {
                int i;
                int width = this.bimg.getWidth();
                int height = this.bimg.getHeight();
                this.xlist = new ArrayList<Integer>(width);
                this.ylist = new ArrayList<Integer>(height);
                this.list = new ArrayList<Integer>(this.ending - this.beginning + 1);
                for (i = 0; i < width; ++i) {
                    this.xlist.add(i, i);
                }
                for (i = 0; i < height; ++i) {
                    this.ylist.add(i, i);
                }
                for (i = 0; i < this.ending - this.beginning + 1; ++i) {
                    this.list.add(i, i);
                }
                Collections.shuffle(this.xlist);
                Collections.shuffle(this.ylist);
                Collections.shuffle(this.list);
            }

            @Override
            public void reset(int w, int h) {
                this.bimg = null;
            }

            @Override
            public void step(int w, int h) {
                if (this.inc > this.ending) {
                    this.bimg = null;
                }
                if (this.bimg == null) {
                    int biw = this.surf.bimg.getWidth();
                    int bih = this.surf.bimg.getHeight();
                    this.bimg = new BufferedImage(biw, bih, 1);
                    this.createShuffledLists();
                    this.big = this.bimg.createGraphics();
                    this.big.drawImage((Image)this.surf.bimg, 0, 0, null);
                    this.xcSize = this.xlist.size() / (this.ending - this.beginning) + 1;
                    this.ycSize = this.ylist.size() / (this.ending - this.beginning) + 1;
                    this.xeNum = 0;
                    this.inc = 0;
                }
                this.xeNum = this.xcSize * this.list.get(this.inc);
                this.yeNum = -this.ycSize;
                ++this.inc;
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                this.big.setColor(myBlack);
                for (int k = 0; k <= this.ending - this.beginning; ++k) {
                    this.xeNum = this.xeNum + this.xcSize > this.xlist.size() ? 0 : (this.xeNum += this.xcSize);
                    this.yeNum += this.ycSize;
                    for (int i = this.xeNum; i < this.xeNum + this.xcSize && i < this.xlist.size(); ++i) {
                        for (int j = this.yeNum; j < this.yeNum + this.ycSize && j < this.ylist.size(); ++j) {
                            int xval = this.xlist.get(i);
                            int yval = this.ylist.get(j);
                            if (xval % this.blocksize != 0 || yval % this.blocksize != 0) continue;
                            this.big.fillRect(xval, yval, this.blocksize, this.blocksize);
                        }
                    }
                }
                g2.drawImage((Image)this.bimg, 0, 0, null);
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class CoE
        implements Part {
            private final Surface surf;
            static final int WID = 1;
            static final int HEI = 2;
            static final int OVAL = 4;
            static final int RECT = 8;
            static final int RAND = 16;
            static final int ARC = 32;
            private int type;
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private Shape shape;
            private double zoom;
            private double extent;
            private double zIncr;
            private double eIncr;
            private boolean doRandom;

            public CoE(int type, int beg, int end, Surface surf) {
                this.type = type;
                this.beginning = beg;
                this.ending = end;
                this.surf = surf;
                this.zIncr = -(2.0 / (double)(this.ending - this.beginning));
                this.eIncr = 360.0 / (double)(this.ending - this.beginning);
                this.doRandom = (type & 0x10) != 0;
            }

            @Override
            public void reset(int w, int h) {
                if (this.doRandom) {
                    int num = (int)(Math.random() * 5.0);
                    switch (num) {
                        case 0: {
                            this.type = 4;
                            break;
                        }
                        case 1: {
                            this.type = 8;
                            break;
                        }
                        case 2: {
                            this.type = 9;
                            break;
                        }
                        case 3: {
                            this.type = 10;
                            break;
                        }
                        case 4: {
                            this.type = 32;
                            break;
                        }
                        default: {
                            this.type = 4;
                        }
                    }
                }
                this.shape = null;
                this.bimg = null;
                this.extent = 360.0;
                this.zoom = 2.0;
            }

            @Override
            public void step(int w, int h) {
                if (this.bimg == null) {
                    int biw = this.surf.bimg.getWidth();
                    int bih = this.surf.bimg.getHeight();
                    this.bimg = new BufferedImage(biw, bih, 1);
                    Graphics2D big = this.bimg.createGraphics();
                    big.drawImage((Image)this.surf.bimg, 0, 0, null);
                }
                double z = (double)Math.min(w, h) * this.zoom;
                if ((this.type & 4) != 0) {
                    this.shape = new Ellipse2D.Double((double)(w / 2) - z / 2.0, (double)(h / 2) - z / 2.0, z, z);
                } else if ((this.type & 0x20) != 0) {
                    this.shape = new Arc2D.Double(-100.0, -100.0, w + 200, h + 200, 90.0, this.extent, 2);
                    this.extent -= this.eIncr;
                } else if ((this.type & 8) != 0) {
                    this.shape = (this.type & 1) != 0 ? new Rectangle2D.Double((double)(w / 2) - z / 2.0, 0.0, z, h) : ((this.type & 2) != 0 ? new Rectangle2D.Double(0.0, (double)(h / 2) - z / 2.0, w, z) : new Rectangle2D.Double((double)(w / 2) - z / 2.0, (double)(h / 2) - z / 2.0, z, z));
                }
                this.zoom += this.zIncr;
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                g2.clip(this.shape);
                g2.drawImage((Image)this.bimg, 0, 0, null);
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static final class TpE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int OVAL = 4;
            static final int RECT = 8;
            static final int HAF = 16;
            static final int NF = 32;
            static final int OI = 5;
            static final int OD = 6;
            static final int RI = 9;
            static final int RD = 10;
            private Paint p1;
            private Paint p2;
            private int beginning;
            private int ending;
            private float incr;
            private float index;
            private TexturePaint texture;
            private int type;
            private int size;
            private BufferedImage bimg;
            private Rectangle rect;

            public TpE(int type, Paint p1, Paint p2, int size, int beg, int end) {
                this.type = type;
                this.p1 = p1;
                this.p2 = p2;
                this.beginning = beg;
                this.ending = end;
                this.setTextureSize(size);
            }

            public void setTextureSize(int size) {
                this.size = size;
                this.bimg = new BufferedImage(size, size, 1);
                this.rect = new Rectangle(0, 0, size, size);
            }

            @Override
            public void reset(int w, int h) {
                this.incr = (float)this.size / (float)(this.ending - this.beginning);
                if ((this.type & 0x10) != 0) {
                    this.incr /= 2.0f;
                }
                if ((this.type & 2) != 0) {
                    this.index = this.size;
                    if ((this.type & 0x10) != 0) {
                        this.index /= 2.0f;
                    }
                    this.incr = -this.incr;
                } else {
                    this.index = 0.0f;
                }
                this.index += this.incr;
            }

            @Override
            public void step(int w, int h) {
                Graphics2D g2 = this.bimg.createGraphics();
                g2.setPaint(this.p1);
                g2.fillRect(0, 0, this.size, this.size);
                g2.setPaint(this.p2);
                if ((this.type & 4) != 0) {
                    g2.fill(new Ellipse2D.Float(0.0f, 0.0f, this.index, this.index));
                } else if ((this.type & 8) != 0) {
                    g2.fill(new Rectangle2D.Float(0.0f, 0.0f, this.index, this.index));
                }
                this.texture = new TexturePaint(this.bimg, this.rect);
                g2.dispose();
                this.index += this.incr;
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                g2.setPaint(this.texture);
                if ((this.type & 0x20) == 0) {
                    g2.fillRect(0, 0, w, h);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class GpE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int CNT = 4;
            static final int WID = 8;
            static final int WI = 9;
            static final int WD = 10;
            static final int HEI = 16;
            static final int HI = 17;
            static final int HD = 18;
            static final int SPL = 36;
            static final int SIW = 45;
            static final int SDW = 46;
            static final int SIH = 53;
            static final int SDH = 54;
            static final int BUR = 68;
            static final int BURI = 69;
            static final int BURD = 70;
            static final int NF = 128;
            private Color c1;
            private Color c2;
            private int beginning;
            private int ending;
            private float incr;
            private float index;
            private List<Rectangle2D> rect = new ArrayList<Rectangle2D>();
            private List<GradientPaint> grad = new ArrayList<GradientPaint>();
            private int type;

            public GpE(int type, Color c1, Color c2, int beg, int end) {
                this.type = type;
                this.c1 = c1;
                this.c2 = c2;
                this.beginning = beg;
                this.ending = end;
            }

            @Override
            public void reset(int w, int h) {
                this.incr = 1.0f / (float)(this.ending - this.beginning);
                if ((this.type & 4) != 0) {
                    this.incr /= 2.3f;
                }
                if ((this.type & 4) != 0 && (this.type & 1) != 0) {
                    this.index = 0.5f;
                } else if ((this.type & 2) != 0) {
                    this.index = 1.0f;
                    this.incr = -this.incr;
                } else {
                    this.index = 0.0f;
                }
                this.index += this.incr;
            }

            @Override
            public void step(int w, int h) {
                this.rect.clear();
                this.grad.clear();
                if ((this.type & 8) != 0) {
                    float w2 = 0.0f;
                    float x1 = 0.0f;
                    float x2 = 0.0f;
                    if ((this.type & 0x24) != 0) {
                        w2 = (float)w * 0.5f;
                        x1 = (float)w * (1.0f - this.index);
                        x2 = (float)w * this.index;
                    } else {
                        x1 = x2 = (w2 = (float)w * this.index);
                    }
                    this.rect.add(new Rectangle2D.Float(0.0f, 0.0f, w2, h));
                    this.rect.add(new Rectangle2D.Float(w2, 0.0f, (float)w - w2, h));
                    this.grad.add(new GradientPaint(0.0f, 0.0f, this.c1, x1, 0.0f, this.c2));
                    this.grad.add(new GradientPaint(x2, 0.0f, this.c2, w, 0.0f, this.c1));
                } else if ((this.type & 0x10) != 0) {
                    float h2 = 0.0f;
                    float y1 = 0.0f;
                    float y2 = 0.0f;
                    if ((this.type & 0x24) != 0) {
                        h2 = (float)h * 0.5f;
                        y1 = (float)h * (1.0f - this.index);
                        y2 = (float)h * this.index;
                    } else {
                        y1 = y2 = (h2 = (float)h * this.index);
                    }
                    this.rect.add(new Rectangle2D.Float(0.0f, 0.0f, w, h2));
                    this.rect.add(new Rectangle2D.Float(0.0f, h2, w, (float)h - h2));
                    this.grad.add(new GradientPaint(0.0f, 0.0f, this.c1, 0.0f, y1, this.c2));
                    this.grad.add(new GradientPaint(0.0f, y2, this.c2, 0.0f, h, this.c1));
                } else if ((this.type & 0x44) != 0) {
                    float w2 = w / 2;
                    float h2 = h / 2;
                    this.rect.add(new Rectangle2D.Float(0.0f, 0.0f, w2, h2));
                    this.rect.add(new Rectangle2D.Float(w2, 0.0f, w2, h2));
                    this.rect.add(new Rectangle2D.Float(0.0f, h2, w2, h2));
                    this.rect.add(new Rectangle2D.Float(w2, h2, w2, h2));
                    float x1 = (float)w * (1.0f - this.index);
                    float x2 = (float)w * this.index;
                    float y1 = (float)h * (1.0f - this.index);
                    float y2 = (float)h * this.index;
                    this.grad.add(new GradientPaint(0.0f, 0.0f, this.c1, x1, y1, this.c2));
                    this.grad.add(new GradientPaint(w, 0.0f, this.c1, x2, y1, this.c2));
                    this.grad.add(new GradientPaint(0.0f, h, this.c1, x1, y2, this.c2));
                    this.grad.add(new GradientPaint(w, h, this.c1, x2, y2, this.c2));
                } else if ((this.type & 0x80) != 0) {
                    float y = (float)h * this.index;
                    this.grad.add(new GradientPaint(0.0f, 0.0f, this.c1, 0.0f, y, this.c2));
                }
                if ((this.type & 1) != 0 || (this.type & 2) != 0) {
                    this.index += this.incr;
                }
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                for (int i = 0; i < this.grad.size(); ++i) {
                    g2.setPaint(this.grad.get(i));
                    if ((this.type & 0x80) != 0) continue;
                    g2.fill(this.rect.get(i));
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static final class TxE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int R = 4;
            static final int RI = 5;
            static final int RD = 6;
            static final int SC = 8;
            static final int SCI = 9;
            static final int SCD = 10;
            static final int SCX = 16;
            static final int SCXI = 25;
            static final int SCXD = 26;
            static final int SCY = 32;
            static final int SCYI = 41;
            static final int SCYD = 42;
            static final int AC = 64;
            static final int CLIP = 128;
            static final int NOP = 512;
            private int beginning;
            private int ending;
            private int type;
            private double rIncr;
            private double sIncr;
            private double sx;
            private double sy;
            private double rotate;
            private Shape[] shapes;
            private Shape[] txShapes;
            private int sw;
            private int numRev;
            private Paint paint;

            public TxE(String text, Font font, int type, Paint paint, int beg, int end) {
                this.type = type;
                this.paint = paint;
                this.beginning = beg;
                this.ending = end;
                this.setIncrements(2.0);
                char[] chars = text.toCharArray();
                this.shapes = new Shape[chars.length];
                this.txShapes = new Shape[chars.length];
                FontRenderContext frc = new FontRenderContext(null, true, true);
                TextLayout tl = new TextLayout(text, font, frc);
                this.sw = (int)tl.getOutline(null).getBounds().getWidth();
                for (int j = 0; j < chars.length; ++j) {
                    String s = String.valueOf(chars[j]);
                    this.shapes[j] = new TextLayout(s, font, frc).getOutline(null);
                }
            }

            public void setIncrements(double numRevolutions) {
                this.numRev = (int)numRevolutions;
                this.rIncr = 360.0 / ((double)(this.ending - this.beginning) / numRevolutions);
                this.sIncr = 1.0 / (double)(this.ending - this.beginning);
                if ((this.type & 0x10) != 0 || (this.type & 0x20) != 0) {
                    this.sIncr *= 2.0;
                }
                if ((this.type & 2) != 0) {
                    this.rIncr = -this.rIncr;
                    this.sIncr = -this.sIncr;
                }
            }

            @Override
            public void reset(int w, int h) {
                if (this.type == 25) {
                    this.sx = -1.0;
                    this.sy = 1.0;
                } else if (this.type == 41) {
                    this.sx = 1.0;
                    this.sy = -1.0;
                } else {
                    this.sy = (this.type & 2) != 0 ? 1.0 : 0.0;
                    this.sx = this.sy;
                }
                this.rotate = 0.0;
            }

            @Override
            public void step(int w, int h) {
                float charWidth = w / 2 - this.sw / 2;
                for (int i = 0; i < this.shapes.length; ++i) {
                    AffineTransform at = new AffineTransform();
                    Rectangle maxBounds = this.shapes[i].getBounds();
                    at.translate(charWidth, (double)(h / 2) + ((RectangularShape)maxBounds).getHeight() / 2.0);
                    charWidth += (float)((RectangularShape)maxBounds).getWidth() + 1.0f;
                    Shape shape = at.createTransformedShape(this.shapes[i]);
                    Rectangle2D b1 = shape.getBounds2D();
                    if ((this.type & 4) != 0) {
                        at.rotate(Math.toRadians(this.rotate));
                    }
                    if ((this.type & 8) != 0) {
                        at.scale(this.sx, this.sy);
                    }
                    shape = at.createTransformedShape(this.shapes[i]);
                    Rectangle2D b2 = shape.getBounds2D();
                    double xx = b1.getX() + b1.getWidth() / 2.0 - (b2.getX() + b2.getWidth() / 2.0);
                    double yy = b1.getY() + b1.getHeight() / 2.0 - (b2.getY() + b2.getHeight() / 2.0);
                    AffineTransform toCenterAT = new AffineTransform();
                    toCenterAT.translate(xx, yy);
                    toCenterAT.concatenate(at);
                    this.txShapes[i] = toCenterAT.createTransformedShape(this.shapes[i]);
                }
                if (Math.abs(this.rotate) <= (double)(this.numRev * 360)) {
                    this.rotate += this.rIncr;
                    if ((this.type & 0x10) != 0) {
                        this.sx += this.sIncr;
                    } else if ((this.type & 0x20) != 0) {
                        this.sy += this.sIncr;
                    } else {
                        this.sx += this.sIncr;
                        this.sy += this.sIncr;
                    }
                }
            }

            @Override
            public void render(int w, int h, Graphics2D g2) {
                Composite saveAC = null;
                if ((this.type & 0x40) != 0 && this.sx > 0.0 && this.sx < 1.0) {
                    saveAC = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, (float)this.sx));
                }
                GeneralPath path = null;
                if ((this.type & 0x80) != 0) {
                    path = new GeneralPath();
                }
                if (this.paint != null) {
                    g2.setPaint(this.paint);
                }
                for (int i = 0; i < this.txShapes.length; ++i) {
                    if ((this.type & 0x80) != 0) {
                        path.append(this.txShapes[i], false);
                        continue;
                    }
                    g2.fill(this.txShapes[i]);
                }
                if ((this.type & 0x80) != 0) {
                    g2.clip(path);
                }
                if (saveAC != null) {
                    g2.setComposite(saveAC);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class Scene {
            public Object name;
            public Object participate = Boolean.TRUE;
            public Object pauseAmt;
            public List<Part> parts;
            public int index;
            public int length;

            public Scene(List<Part> parts, Object name, Object pauseAmt) {
                this.name = name;
                this.parts = parts;
                this.pauseAmt = pauseAmt;
                for (Part part : parts) {
                    int partLength = part.getEnd();
                    if (partLength <= this.length) continue;
                    this.length = partLength;
                }
            }

            public void reset(int w, int h) {
                this.index = 0;
                for (int i = 0; i < this.parts.size(); ++i) {
                    this.parts.get(i).reset(w, h);
                }
            }

            public void step(int w, int h) {
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = this.parts.get(i);
                    if (this.index < part.getBegin() || this.index > part.getEnd()) continue;
                    part.step(w, h);
                }
            }

            public void render(int w, int h, Graphics2D g2) {
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = this.parts.get(i);
                    if (this.index < part.getBegin() || this.index > part.getEnd()) continue;
                    part.render(w, h, g2);
                }
            }

            public void pause() {
                try {
                    Thread.sleep(Long.parseLong((String)this.pauseAmt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.gc();
            }
        }

        static class Director
        extends ArrayList<Scene> {
            GradientPaint gp = new GradientPaint(0.0f, 40.0f, myBlue, 38.0f, 2.0f, myBlack);
            Font f1 = new Font("Serif", 0, 200);
            Font f2 = new Font("Serif", 0, 120);
            Font f3 = new Font("Serif", 0, 72);

            public Director(Surface surf) {
                Object[][][] partsInfo;
                for (Object[][] partInfo : partsInfo = new Object[][][]{{{"J  -  scale text on gradient", "0"}, {new GpE(69, myBlack, myBlue, 0, 20), new TxE("J", this.f1, 9, myYellow, 2, 20)}}, {{"2  -  scale & rotate text on gradient", "0"}, {new GpE(69, myBlue, myBlack, 0, 22), new TxE("2", this.f1, 13, myYellow, 2, 22)}}, {{"D  -  scale text on gradient", "0"}, {new GpE(69, myBlack, myBlue, 0, 20), new TxE("D", this.f1, 9, myYellow, 2, 20)}}, {{"J2D demo  -  scale & rotate text on gradient", "1000"}, {new GpE(53, myBlue, myBlack, 0, 40), new TxE("J2D demo", this.f2, 13, myYellow, 0, 40)}}, {{"Previous scene dither dissolve out", "0"}, {new DdE(0, 20, 1, surf)}}, {{"Graphics Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, surf.duke, 2, 15), new Temp(7, surf.duke, 16, 130), new Features(0, 16, 130, surf)}}, {{"J2D demo  -  texture text on gradient", "1000"}, {new GpE(9, myBlue, myBlack, 0, 20), new GpE(10, myBlue, myBlack, 21, 40), new TpE(37, myBlack, myYellow, 4, 0, 10), new TpE(38, myBlack, myYellow, 4, 11, 20), new TpE(53, myBlack, myYellow, 5, 21, 40), new TxE("J2D demo", this.f2, 0, null, 0, 40)}}, {{"Previous scene random close out", "0"}, {new CoE(16, 0, 20, surf)}}, {{"Text Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, surf.duke, 2, 15), new Temp(7, surf.duke, 16, 130), new Features(1, 16, 130, surf)}}, {{"J2D demo  -  composite text on texture", "1000"}, {new TpE(9, myBlack, this.gp, 40, 0, 20), new TpE(10, myBlack, this.gp, 40, 21, 40), new TpE(9, myBlack, this.gp, 40, 41, 60), new TxE("J2D demo", this.f2, 64, myYellow, 0, 60)}}, {{"Previous scene dither dissolve out", "0"}, {new DdE(0, 20, 4, surf)}}, {{"Imaging Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, surf.duke, 2, 15), new Temp(7, surf.duke, 16, 130), new Features(2, 16, 130, surf)}}, {{"J2D demo  -  text on gradient", "1000"}, {new GpE(54, myBlue, myBlack, 0, 20), new GpE(53, myBlue, myBlack, 21, 40), new GpE(54, myBlue, myBlack, 41, 50), new GpE(129, myRed, myYellow, 0, 50), new TxE("J2D demo", this.f2, 512, null, 0, 50)}}, {{"Previous scene ellipse close out", "0"}, {new CoE(4, 0, 20, surf)}}, {{"Color Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, surf.duke, 2, 15), new Temp(7, surf.duke, 16, 99), new Features(3, 16, 99, surf)}}, {{"J2D demo  -  composite and rotate text on paints", "2000"}, {new GpE(69, myBlack, myBlue, 0, 20), new GpE(70, myBlack, myBlue, 21, 30), new TpE(21, myBlack, myBlue, 10, 31, 40), new TxE("J2D demo", this.f2, 69, myYellow, 0, 40)}}, {{"Previous scene subimage transform out", "0"}, {new SiE(60, 60, 0, 40, surf)}}, {{"CREDITS  -  transform in", "1000"}, {new LnE(45, 0, 60), new TxE("CREDITS", this.f3, 73, Color.RED, 20, 30), new TxE("CREDITS", this.f3, 26, Color.RED, 31, 38), new TxE("CREDITS", this.f3, 25, Color.RED, 39, 48), new TxE("CREDITS", this.f3, 26, Color.RED, 49, 54), new TxE("CREDITS", this.f3, 25, Color.RED, 55, 60)}}, {{"CREDITS  -  transform out", "0"}, {new LnE(46, 0, 45), new TxE("CREDITS", this.f3, 0, Color.RED, 0, 9), new TxE("CREDITS", this.f3, 14, Color.RED, 10, 30)}}, {{"Contributors", "1000"}, {new Temp(2, null, 0, 30), new Temp(4, surf.dukeanim, 4, 30), new Temp(7, surf.dukeanim, 31, 200), new Contributors(34, 200, surf)}}}) {
                    ArrayList<Part> parts = new ArrayList<Part>();
                    for (Object part : partInfo[1]) {
                        parts.add((Part)part);
                    }
                    this.add(new Scene(parts, partInfo[0][0], partInfo[0][1]));
                }
            }
        }

        static interface Part {
            public void reset(int var1, int var2);

            public void step(int var1, int var2);

            public void render(int var1, int var2, Graphics2D var3);

            public int getBegin();

            public int getEnd();
        }
    }

    static class ScenesTable
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private final Intro intro;
        private JTable table;
        private TableModel dataModel;

        public ScenesTable(final Intro intro) {
            this.intro = intro;
            this.setBackground(Color.WHITE);
            this.setLayout(new BorderLayout());
            final String[] names = new String[]{"", "Scenes", "Pause"};
            this.dataModel = new AbstractTableModel(){

                @Override
                public int getColumnCount() {
                    return names.length;
                }

                @Override
                public int getRowCount() {
                    return intro.surface.director.size();
                }

                @Override
                public Object getValueAt(int row, int col) {
                    Surface.Scene scene = (Surface.Scene)intro.surface.director.get(row);
                    if (col == 0) {
                        return scene.participate;
                    }
                    if (col == 1) {
                        return scene.name;
                    }
                    return scene.pauseAmt;
                }

                @Override
                public String getColumnName(int col) {
                    return names[col];
                }

                @Override
                public Class<?> getColumnClass(int c) {
                    return this.getValueAt(0, c).getClass();
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col != 1;
                }

                @Override
                public void setValueAt(Object aValue, int row, int col) {
                    Surface.Scene scene = (Surface.Scene)intro.surface.director.get(row);
                    if (col == 0) {
                        scene.participate = aValue;
                    } else if (col == 1) {
                        scene.name = aValue;
                    } else {
                        scene.pauseAmt = aValue;
                    }
                }
            };
            this.table = new JTable(this.dataModel);
            TableColumn col = this.table.getColumn("");
            col.setWidth(16);
            col.setMinWidth(16);
            col.setMaxWidth(20);
            col = this.table.getColumn("Pause");
            col.setWidth(60);
            col.setMinWidth(60);
            col.setMaxWidth(60);
            this.table.sizeColumnsToFit(0);
            JScrollPane scrollpane = new JScrollPane(this.table);
            this.add(scrollpane);
            JPanel panel = new JPanel(new BorderLayout());
            JButton b = new JButton("Unselect All");
            b.setHorizontalAlignment(2);
            Font font = new Font("Serif", 0, 10);
            b.setFont(font);
            b.addActionListener(this);
            panel.add("West", b);
            JSlider slider = new JSlider(0, 0, 200, (int)intro.surface.sleepAmt);
            slider.addChangeListener(this);
            TitledBorder tb = new TitledBorder(new EtchedBorder());
            tb.setTitleFont(font);
            tb.setTitle("Anim delay = " + String.valueOf(intro.surface.sleepAmt) + " ms");
            slider.setBorder(tb);
            slider.setPreferredSize(new Dimension(140, 40));
            slider.setMinimumSize(new Dimension(100, 40));
            slider.setMaximumSize(new Dimension(180, 40));
            panel.add("East", slider);
            this.add("South", panel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b;
            b.setSelected(!(b = (JButton)e.getSource()).isSelected());
            b.setText(b.isSelected() ? "Select All" : "Unselect All");
            for (int i = 0; i < this.intro.surface.director.size(); ++i) {
                Surface.Scene scene = (Surface.Scene)this.intro.surface.director.get(i);
                scene.participate = !b.isSelected();
            }
            this.table.tableChanged(new TableModelEvent(this.dataModel));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider slider = (JSlider)e.getSource();
            int value = slider.getValue();
            TitledBorder tb = (TitledBorder)slider.getBorder();
            tb.setTitle("Anim delay = " + String.valueOf(value) + " ms");
            this.intro.surface.sleepAmt = value;
            slider.repaint();
        }
    }
}

