/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: OSCache_header1Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the OSCache_header1Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=OSCache_header1.class)
public class OSCache_header1Pointer extends StructurePointer {

	// NULL
	public static final OSCache_header1Pointer NULL = new OSCache_header1Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected OSCache_header1Pointer(long address) {
		super(address);
	}

	public static OSCache_header1Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static OSCache_header1Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static OSCache_header1Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new OSCache_header1Pointer(address);
	}

	public OSCache_header1Pointer add(long count) {
		return OSCache_header1Pointer.cast(address + (OSCache_header1.SIZEOF * count));
	}

	public OSCache_header1Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public OSCache_header1Pointer addOffset(long offset) {
		return OSCache_header1Pointer.cast(address + offset);
	}

	public OSCache_header1Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public OSCache_header1Pointer sub(long count) {
		return OSCache_header1Pointer.cast(address - (OSCache_header1.SIZEOF * count));
	}

	public OSCache_header1Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public OSCache_header1Pointer subOffset(long offset) {
		return OSCache_header1Pointer.cast(address - offset);
	}

	public OSCache_header1Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public OSCache_header1Pointer untag(long mask) {
		return OSCache_header1Pointer.cast(address & ~mask);
	}

	public OSCache_header1Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return OSCache_header1.SIZEOF;
	}

	// Implementation methods

	// U64 buildID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_buildIDOffset_", declaredType="U64")
	public UDATA buildID() throws CorruptDataException {
		return new U64(getLongAtOffset(OSCache_header1._buildIDOffset_));
	}

	// U64 buildID
	public UDATAPointer buildIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OSCache_header1._buildIDOffset_));
	}

	// U32 dataLength
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dataLengthOffset_", declaredType="U32")
	public UDATA dataLength() throws CorruptDataException {
		return new U32(getIntAtOffset(OSCache_header1._dataLengthOffset_));
	}

	// U32 dataLength
	public UDATAPointer dataLengthEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OSCache_header1._dataLengthOffset_));
	}

	// J9SRP dataStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dataStartOffset_", declaredType="J9SRP")
	public VoidPointer dataStart() throws CorruptDataException {
		long nextAddress = getIntAtOffset(OSCache_header1._dataStartOffset_);
		if (nextAddress == 0) {
			return VoidPointer.NULL;
		}
		return VoidPointer.cast(address + (OSCache_header1._dataStartOffset_ + nextAddress));
	}

	// J9SRP dataStart
	public SelfRelativePointer dataStartEA() throws CorruptDataException {
		return SelfRelativePointer.cast(nonNullFieldEA(OSCache_header1._dataStartOffset_));
	}

	// U32 generation
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_generationOffset_", declaredType="U32")
	public UDATA generation() throws CorruptDataException {
		return new U32(getIntAtOffset(OSCache_header1._generationOffset_));
	}

	// U32 generation
	public UDATAPointer generationEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OSCache_header1._generationOffset_));
	}

	// U32 size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sizeOffset_", declaredType="U32")
	public UDATA size() throws CorruptDataException {
		return new U32(getIntAtOffset(OSCache_header1._sizeOffset_));
	}

	// U32 size
	public UDATAPointer sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OSCache_header1._sizeOffset_));
	}

	// U32 unused1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unused1Offset_", declaredType="U32")
	public UDATA unused1() throws CorruptDataException {
		return new U32(getIntAtOffset(OSCache_header1._unused1Offset_));
	}

	// U32 unused1
	public UDATAPointer unused1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OSCache_header1._unused1Offset_));
	}

	// U32 unused2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unused2Offset_", declaredType="U32")
	public UDATA unused2() throws CorruptDataException {
		return new U32(getIntAtOffset(OSCache_header1._unused2Offset_));
	}

	// U32 unused2
	public UDATAPointer unused2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OSCache_header1._unused2Offset_));
	}

	// J9PortShcVersion versionData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionDataOffset_", declaredType="J9PortShcVersion")
	public J9PortShcVersionPointer versionData() throws CorruptDataException {
		return J9PortShcVersionPointer.cast(nonNullFieldEA(OSCache_header1._versionDataOffset_));
	}

	// J9PortShcVersion versionData
	public PointerPointer versionDataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OSCache_header1._versionDataOffset_));
	}

}
