/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __jmp_buf_tagPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __jmp_buf_tagPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__jmp_buf_tag.class)
public class __jmp_buf_tagPointer extends StructurePointer {

	// NULL
	public static final __jmp_buf_tagPointer NULL = new __jmp_buf_tagPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __jmp_buf_tagPointer(long address) {
		super(address);
	}

	public static __jmp_buf_tagPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __jmp_buf_tagPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __jmp_buf_tagPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __jmp_buf_tagPointer(address);
	}

	public __jmp_buf_tagPointer add(long count) {
		return __jmp_buf_tagPointer.cast(address + (__jmp_buf_tag.SIZEOF * count));
	}

	public __jmp_buf_tagPointer add(Scalar count) {
		return add(count.longValue());
	}

	public __jmp_buf_tagPointer addOffset(long offset) {
		return __jmp_buf_tagPointer.cast(address + offset);
	}

	public __jmp_buf_tagPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __jmp_buf_tagPointer sub(long count) {
		return __jmp_buf_tagPointer.cast(address - (__jmp_buf_tag.SIZEOF * count));
	}

	public __jmp_buf_tagPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __jmp_buf_tagPointer subOffset(long offset) {
		return __jmp_buf_tagPointer.cast(address - offset);
	}

	public __jmp_buf_tagPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __jmp_buf_tagPointer untag(long mask) {
		return __jmp_buf_tagPointer.cast(address & ~mask);
	}

	public __jmp_buf_tagPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __jmp_buf_tag.SIZEOF;
	}

	// Implementation methods

	// __jmp_buf __jmpbuf
	public __s390_jmp_bufPointer __jmpbufEA() throws CorruptDataException {
		return __s390_jmp_bufPointer.cast(nonNullFieldEA(__jmp_buf_tag.___jmpbufOffset_));
	}

	// I32 __mask_was_saved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___mask_was_savedOffset_", declaredType="I32")
	public IDATA __mask_was_saved() throws CorruptDataException {
		return new I32(getIntAtOffset(__jmp_buf_tag.___mask_was_savedOffset_));
	}

	// I32 __mask_was_saved
	public IDATAPointer __mask_was_savedEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__jmp_buf_tag.___mask_was_savedOffset_));
	}

	// __sigset_t __saved_mask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___saved_maskOffset_", declaredType="__sigset_t")
	public __sigset_tPointer __saved_mask() throws CorruptDataException {
		return __sigset_tPointer.cast(nonNullFieldEA(__jmp_buf_tag.___saved_maskOffset_));
	}

	// __sigset_t __saved_mask
	public PointerPointer __saved_maskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__jmp_buf_tag.___saved_maskOffset_));
	}

}
