/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: LinuxzVMInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the LinuxzVMInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=LinuxzVMInfo.class)
public class LinuxzVMInfoPointer extends StructurePointer {

	// NULL
	public static final LinuxzVMInfoPointer NULL = new LinuxzVMInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected LinuxzVMInfoPointer(long address) {
		super(address);
	}

	public static LinuxzVMInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static LinuxzVMInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static LinuxzVMInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new LinuxzVMInfoPointer(address);
	}

	public LinuxzVMInfoPointer add(long count) {
		return LinuxzVMInfoPointer.cast(address + (LinuxzVMInfo.SIZEOF * count));
	}

	public LinuxzVMInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public LinuxzVMInfoPointer addOffset(long offset) {
		return LinuxzVMInfoPointer.cast(address + offset);
	}

	public LinuxzVMInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public LinuxzVMInfoPointer sub(long count) {
		return LinuxzVMInfoPointer.cast(address - (LinuxzVMInfo.SIZEOF * count));
	}

	public LinuxzVMInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public LinuxzVMInfoPointer subOffset(long offset) {
		return LinuxzVMInfoPointer.cast(address - offset);
	}

	public LinuxzVMInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public LinuxzVMInfoPointer untag(long mask) {
		return LinuxzVMInfoPointer.cast(address & ~mask);
	}

	public LinuxzVMInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return LinuxzVMInfo.SIZEOF;
	}

	// Implementation methods

	// U64 cpuTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpuTimeOffset_", declaredType="U64")
	public UDATA cpuTime() throws CorruptDataException {
		return new U64(getLongAtOffset(LinuxzVMInfo._cpuTimeOffset_));
	}

	// U64 cpuTime
	public UDATAPointer cpuTimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LinuxzVMInfo._cpuTimeOffset_));
	}

	// U32 cpuWeightMax
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpuWeightMaxOffset_", declaredType="U32")
	public UDATA cpuWeightMax() throws CorruptDataException {
		return new U32(getIntAtOffset(LinuxzVMInfo._cpuWeightMaxOffset_));
	}

	// U32 cpuWeightMax
	public UDATAPointer cpuWeightMaxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LinuxzVMInfo._cpuWeightMaxOffset_));
	}

	// U32 dedicatedCpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dedicatedCpuOffset_", declaredType="U32")
	public UDATA dedicatedCpu() throws CorruptDataException {
		return new U32(getIntAtOffset(LinuxzVMInfo._dedicatedCpuOffset_));
	}

	// U32 dedicatedCpu
	public UDATAPointer dedicatedCpuEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LinuxzVMInfo._dedicatedCpuOffset_));
	}

	// U64 entitledCapacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entitledCapacityOffset_", declaredType="U64")
	public UDATA entitledCapacity() throws CorruptDataException {
		return new U64(getLongAtOffset(LinuxzVMInfo._entitledCapacityOffset_));
	}

	// U64 entitledCapacity
	public UDATAPointer entitledCapacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LinuxzVMInfo._entitledCapacityOffset_));
	}

	// U64 maxMemLimit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxMemLimitOffset_", declaredType="U64")
	public UDATA maxMemLimit() throws CorruptDataException {
		return new U64(getLongAtOffset(LinuxzVMInfo._maxMemLimitOffset_));
	}

	// U64 maxMemLimit
	public UDATAPointer maxMemLimitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LinuxzVMInfo._maxMemLimitOffset_));
	}

	// U64 memUsed
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memUsedOffset_", declaredType="U64")
	public UDATA memUsed() throws CorruptDataException {
		return new U64(getLongAtOffset(LinuxzVMInfo._memUsedOffset_));
	}

	// U64 memUsed
	public UDATAPointer memUsedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LinuxzVMInfo._memUsedOffset_));
	}

	// U64 timestamp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timestampOffset_", declaredType="U64")
	public UDATA timestamp() throws CorruptDataException {
		return new U64(getLongAtOffset(LinuxzVMInfo._timestampOffset_));
	}

	// U64 timestamp
	public UDATAPointer timestampEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LinuxzVMInfo._timestampOffset_));
	}

	// time_t updateLastStat
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_updateLastStatOffset_", declaredType="time_t")
	public IDATA updateLastStat() throws CorruptDataException {
		return new I64(getLongAtOffset(LinuxzVMInfo._updateLastStatOffset_));
	}

	// time_t updateLastStat
	public IDATAPointer updateLastStatEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(LinuxzVMInfo._updateLastStatOffset_));
	}

	// U32 vcpuCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vcpuCountOffset_", declaredType="U32")
	public UDATA vcpuCount() throws CorruptDataException {
		return new U32(getIntAtOffset(LinuxzVMInfo._vcpuCountOffset_));
	}

	// U32 vcpuCount
	public UDATAPointer vcpuCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LinuxzVMInfo._vcpuCountOffset_));
	}

}
