/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: StackTraceEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the StackTraceEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=StackTraceEntry.class)
public class StackTraceEntryPointer extends StructurePointer {

	// NULL
	public static final StackTraceEntryPointer NULL = new StackTraceEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected StackTraceEntryPointer(long address) {
		super(address);
	}

	public static StackTraceEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static StackTraceEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static StackTraceEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new StackTraceEntryPointer(address);
	}

	public StackTraceEntryPointer add(long count) {
		return StackTraceEntryPointer.cast(address + (StackTraceEntry.SIZEOF * count));
	}

	public StackTraceEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public StackTraceEntryPointer addOffset(long offset) {
		return StackTraceEntryPointer.cast(address + offset);
	}

	public StackTraceEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public StackTraceEntryPointer sub(long count) {
		return StackTraceEntryPointer.cast(address - (StackTraceEntry.SIZEOF * count));
	}

	public StackTraceEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public StackTraceEntryPointer subOffset(long offset) {
		return StackTraceEntryPointer.cast(address - offset);
	}

	public StackTraceEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public StackTraceEntryPointer untag(long mask) {
		return StackTraceEntryPointer.cast(address & ~mask);
	}

	public StackTraceEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return StackTraceEntry.SIZEOF;
	}

	// Implementation methods

	// StackFrame* frames
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_framesOffset_", declaredType="StackFrame*")
	public StackFramePointer frames() throws CorruptDataException {
		return StackFramePointer.cast(getPointerAtOffset(StackTraceEntry._framesOffset_));
	}

	// StackFrame* frames
	public PointerPointer framesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackTraceEntry._framesOffset_));
	}

	// U32 index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="U32")
	public UDATA index() throws CorruptDataException {
		return new U32(getIntAtOffset(StackTraceEntry._indexOffset_));
	}

	// U32 index
	public UDATAPointer indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(StackTraceEntry._indexOffset_));
	}

	// StackTraceEntry* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="StackTraceEntry*")
	public StackTraceEntryPointer next() throws CorruptDataException {
		return StackTraceEntryPointer.cast(getPointerAtOffset(StackTraceEntry._nextOffset_));
	}

	// StackTraceEntry* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackTraceEntry._nextOffset_));
	}

	// U32 numOfFrames
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numOfFramesOffset_", declaredType="U32")
	public UDATA numOfFrames() throws CorruptDataException {
		return new U32(getIntAtOffset(StackTraceEntry._numOfFramesOffset_));
	}

	// U32 numOfFrames
	public UDATAPointer numOfFramesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(StackTraceEntry._numOfFramesOffset_));
	}

	// I64 ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
	public IDATA ticks() throws CorruptDataException {
		return new I64(getLongAtOffset(StackTraceEntry._ticksOffset_));
	}

	// I64 ticks
	public IDATAPointer ticksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(StackTraceEntry._ticksOffset_));
	}

	// BOOLEAN truncated
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_truncatedOffset_", declaredType="BOOLEAN")
	public UDATA truncated() throws CorruptDataException {
		return new U32(getIntAtOffset(StackTraceEntry._truncatedOffset_));
	}

	// BOOLEAN truncated
	public UDATAPointer truncatedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(StackTraceEntry._truncatedOffset_));
	}

	// J9VMThread* vmThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer vmThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(StackTraceEntry._vmThreadOffset_));
	}

	// J9VMThread* vmThread
	public PointerPointer vmThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackTraceEntry._vmThreadOffset_));
	}

}
