/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ThreadContextSwitchRateEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ThreadContextSwitchRateEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ThreadContextSwitchRateEntry.class)
public class ThreadContextSwitchRateEntryPointer extends StructurePointer {

	// NULL
	public static final ThreadContextSwitchRateEntryPointer NULL = new ThreadContextSwitchRateEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ThreadContextSwitchRateEntryPointer(long address) {
		super(address);
	}

	public static ThreadContextSwitchRateEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ThreadContextSwitchRateEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ThreadContextSwitchRateEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ThreadContextSwitchRateEntryPointer(address);
	}

	public ThreadContextSwitchRateEntryPointer add(long count) {
		return ThreadContextSwitchRateEntryPointer.cast(address + (ThreadContextSwitchRateEntry.SIZEOF * count));
	}

	public ThreadContextSwitchRateEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ThreadContextSwitchRateEntryPointer addOffset(long offset) {
		return ThreadContextSwitchRateEntryPointer.cast(address + offset);
	}

	public ThreadContextSwitchRateEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ThreadContextSwitchRateEntryPointer sub(long count) {
		return ThreadContextSwitchRateEntryPointer.cast(address - (ThreadContextSwitchRateEntry.SIZEOF * count));
	}

	public ThreadContextSwitchRateEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ThreadContextSwitchRateEntryPointer subOffset(long offset) {
		return ThreadContextSwitchRateEntryPointer.cast(address - offset);
	}

	public ThreadContextSwitchRateEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ThreadContextSwitchRateEntryPointer untag(long mask) {
		return ThreadContextSwitchRateEntryPointer.cast(address & ~mask);
	}

	public ThreadContextSwitchRateEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ThreadContextSwitchRateEntry.SIZEOF;
	}

	// Implementation methods

	// float switchRate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_switchRateOffset_", declaredType="float")
	public float switchRate() throws CorruptDataException {
		return getFloatAtOffset(ThreadContextSwitchRateEntry._switchRateOffset_);
	}

	// float switchRate
	public FloatPointer switchRateEA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(ThreadContextSwitchRateEntry._switchRateOffset_));
	}

	// I64 ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
	public IDATA ticks() throws CorruptDataException {
		return new I64(getLongAtOffset(ThreadContextSwitchRateEntry._ticksOffset_));
	}

	// I64 ticks
	public IDATAPointer ticksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ThreadContextSwitchRateEntry._ticksOffset_));
	}

}
