/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9ClassPathEntry
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9ClassPathEntry {

	// VM Constants

	public static final long SIZEOF;
	public static final long CPE_CLASSPATH_TYPE_MASK;
	public static final long CPE_FLAG_BOOTSTRAP;
	public static final long CPE_FLAG_USER;
	public static final long CPE_STATUS_ASSUME_JXE;
	public static final long CPE_STATUS_IGNORE_ZIP_LOAD_STATE;
	public static final long CPE_STATUS_JXE_CORRUPT_IMAGE_HEADER;
	public static final long CPE_STATUS_JXE_MISSING_ROM_CLASSES;
	public static final long CPE_STATUS_JXE_OE_NOT_SUPPORTED;
	public static final long CPE_TYPE_DIRECTORY;
	public static final long CPE_TYPE_JAR;
	public static final long CPE_TYPE_JIMAGE;
	public static final long CPE_TYPE_UNKNOWN;
	public static final long CPE_TYPE_UNUSABLE;

	// Offsets

	public static final int _extraInfoOffset_;
	public static final int _flagsOffset_;
	public static final int _paddingToPowerOf2Offset_;
	public static final int _pathOffset_;
	public static final int _pathLengthOffset_;
	public static final int _statusOffset_;
	public static final int _typeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CPE_CLASSPATH_TYPE_MASK = 0;
		CPE_FLAG_BOOTSTRAP = 0;
		CPE_FLAG_USER = 0;
		CPE_STATUS_ASSUME_JXE = 0;
		CPE_STATUS_IGNORE_ZIP_LOAD_STATE = 0;
		CPE_STATUS_JXE_CORRUPT_IMAGE_HEADER = 0;
		CPE_STATUS_JXE_MISSING_ROM_CLASSES = 0;
		CPE_STATUS_JXE_OE_NOT_SUPPORTED = 0;
		CPE_TYPE_DIRECTORY = 0;
		CPE_TYPE_JAR = 0;
		CPE_TYPE_JIMAGE = 0;
		CPE_TYPE_UNKNOWN = 0;
		CPE_TYPE_UNUSABLE = 0;
		_extraInfoOffset_ = 0;
		_flagsOffset_ = 0;
		_paddingToPowerOf2Offset_ = 0;
		_pathOffset_ = 0;
		_pathLengthOffset_ = 0;
		_statusOffset_ = 0;
		_typeOffset_ = 0;
	}

}
