/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9SharedClassConfig
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9SharedClassConfig {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _acquirePrivateSharedDataOffset_;
	public static final int _bootstrapCPIOffset_;
	public static final int _cacheDescriptorListOffset_;
	public static final int _cacheNameOffset_;
	public static final int _classnameFilterPoolOffset_;
	public static final int _configLockWordOffset_;
	public static final int _configMonitorOffset_;
	public static final int _ctrlDirNameOffset_;
	public static final int _disableSharedClassCacheForCriuRestoreOffset_;
	public static final int _existsCachedCodeForROMMethodOffset_;
	public static final int _findAttachedDataOffset_;
	public static final int _findClassCntrOffset_;
	public static final int _findCompiledMethodEx1Offset_;
	public static final int _findGCHintsOffset_;
	public static final int _findSharedDataOffset_;
	public static final int _freeAttachedDataDescriptorOffset_;
	public static final int _freeClasspathDataOffset_;
	public static final int _getCacheSizeBytesOffset_;
	public static final int _getFreeSpaceBytesOffset_;
	public static final int _getJavacoreDataOffset_;
	public static final int _getMinMaxBytesOffset_;
	public static final int _getSharedClassCacheModeOffset_;
	public static final int _getTotalUsableCacheBytesOffset_;
	public static final int _getUnstoredBytesOffset_;
	public static final int _increaseUnstoredBytesOffset_;
	public static final int _isBCIEnabledOffset_;
	public static final int _jclCacheMutexOffset_;
	public static final int _jclClasspathCacheOffset_;
	public static final int _jclJ9ClassPathEntryPoolOffset_;
	public static final int _jclStringFarmOffset_;
	public static final int _jclTokenCacheOffset_;
	public static final int _jclURLCacheOffset_;
	public static final int _jclURLHashTableOffset_;
	public static final int _jclUTF8HashTableOffset_;
	public static final int _jvmPhaseChangeOffset_;
	public static final int _lastBootstrapCPEOffset_;
	public static final int _layerOffset_;
	public static final int _localStartupHintsOffset_;
	public static final int _maxAOTOffset_;
	public static final int _maxJITOffset_;
	public static final int _metadataMemorySegmentOffset_;
	public static final int _minAOTOffset_;
	public static final int _minJITOffset_;
	public static final int _modContextOffset_;
	public static final int _readOnlyCacheRuntimeFlagsOffset_;
	public static final int _releasePrivateSharedDataOffset_;
	public static final int _romToRamHashTableOffset_;
	public static final int _romToRamHashTableMutexOffset_;
	public static final int _runtimeFlagsOffset_;
	public static final int _runtimeFlags2Offset_;
	public static final int _setMinMaxBytesOffset_;
	public static final int _sharedAPIObjectOffset_;
	public static final int _sharedClassCacheOffset_;
	public static final int _softMaxBytesOffset_;
	public static final int _storeAttachedDataOffset_;
	public static final int _storeCompiledMethodOffset_;
	public static final int _storeGCHintsOffset_;
	public static final int _storeSharedDataOffset_;
	public static final int _updateAttachedDataOffset_;
	public static final int _updateAttachedUDATAOffset_;
	public static final int _updateClasspathOpenStateOffset_;
	public static final int _verboseFlagsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_acquirePrivateSharedDataOffset_ = 0;
		_bootstrapCPIOffset_ = 0;
		_cacheDescriptorListOffset_ = 0;
		_cacheNameOffset_ = 0;
		_classnameFilterPoolOffset_ = 0;
		_configLockWordOffset_ = 0;
		_configMonitorOffset_ = 0;
		_ctrlDirNameOffset_ = 0;
		_disableSharedClassCacheForCriuRestoreOffset_ = 0;
		_existsCachedCodeForROMMethodOffset_ = 0;
		_findAttachedDataOffset_ = 0;
		_findClassCntrOffset_ = 0;
		_findCompiledMethodEx1Offset_ = 0;
		_findGCHintsOffset_ = 0;
		_findSharedDataOffset_ = 0;
		_freeAttachedDataDescriptorOffset_ = 0;
		_freeClasspathDataOffset_ = 0;
		_getCacheSizeBytesOffset_ = 0;
		_getFreeSpaceBytesOffset_ = 0;
		_getJavacoreDataOffset_ = 0;
		_getMinMaxBytesOffset_ = 0;
		_getSharedClassCacheModeOffset_ = 0;
		_getTotalUsableCacheBytesOffset_ = 0;
		_getUnstoredBytesOffset_ = 0;
		_increaseUnstoredBytesOffset_ = 0;
		_isBCIEnabledOffset_ = 0;
		_jclCacheMutexOffset_ = 0;
		_jclClasspathCacheOffset_ = 0;
		_jclJ9ClassPathEntryPoolOffset_ = 0;
		_jclStringFarmOffset_ = 0;
		_jclTokenCacheOffset_ = 0;
		_jclURLCacheOffset_ = 0;
		_jclURLHashTableOffset_ = 0;
		_jclUTF8HashTableOffset_ = 0;
		_jvmPhaseChangeOffset_ = 0;
		_lastBootstrapCPEOffset_ = 0;
		_layerOffset_ = 0;
		_localStartupHintsOffset_ = 0;
		_maxAOTOffset_ = 0;
		_maxJITOffset_ = 0;
		_metadataMemorySegmentOffset_ = 0;
		_minAOTOffset_ = 0;
		_minJITOffset_ = 0;
		_modContextOffset_ = 0;
		_readOnlyCacheRuntimeFlagsOffset_ = 0;
		_releasePrivateSharedDataOffset_ = 0;
		_romToRamHashTableOffset_ = 0;
		_romToRamHashTableMutexOffset_ = 0;
		_runtimeFlagsOffset_ = 0;
		_runtimeFlags2Offset_ = 0;
		_setMinMaxBytesOffset_ = 0;
		_sharedAPIObjectOffset_ = 0;
		_sharedClassCacheOffset_ = 0;
		_softMaxBytesOffset_ = 0;
		_storeAttachedDataOffset_ = 0;
		_storeCompiledMethodOffset_ = 0;
		_storeGCHintsOffset_ = 0;
		_storeSharedDataOffset_ = 0;
		_updateAttachedDataOffset_ = 0;
		_updateAttachedUDATAOffset_ = 0;
		_updateClasspathOpenStateOffset_ = 0;
		_verboseFlagsOffset_ = 0;
	}

}
