/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_InitializedEvent
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_InitializedEvent {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _architectureOffset_;
	public static final int _arrayletLeafSizeOffset_;
	public static final int _beatOffset_;
	public static final int _compressedPointersShiftOffset_;
	public static final int _currentThreadOffset_;
	public static final int _gcPolicyOffset_;
	public static final int _gcThreadsOffset_;
	public static final int _gcTriggerOffset_;
	public static final int _headRoomOffset_;
	public static final int _heapPageSizeOffset_;
	public static final int _heapPageTypeOffset_;
	public static final int _heapRequestedPageSizeOffset_;
	public static final int _heapRequestedPageTypeOffset_;
	public static final int _initialHeapSizeOffset_;
	public static final int _maxHeapSizeOffset_;
	public static final int _numCPUsOffset_;
	public static final int _numaNodesOffset_;
	public static final int _osOffset_;
	public static final int _osVersionOffset_;
	public static final int _physicalMemoryOffset_;
	public static final int _regionCountOffset_;
	public static final int _regionSizeOffset_;
	public static final int _targetUtilizationOffset_;
	public static final int _timeWindowOffset_;
	public static final int _timestampOffset_;
	public static final int _unusedOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_architectureOffset_ = 0;
		_arrayletLeafSizeOffset_ = 0;
		_beatOffset_ = 0;
		_compressedPointersShiftOffset_ = 0;
		_currentThreadOffset_ = 0;
		_gcPolicyOffset_ = 0;
		_gcThreadsOffset_ = 0;
		_gcTriggerOffset_ = 0;
		_headRoomOffset_ = 0;
		_heapPageSizeOffset_ = 0;
		_heapPageTypeOffset_ = 0;
		_heapRequestedPageSizeOffset_ = 0;
		_heapRequestedPageTypeOffset_ = 0;
		_initialHeapSizeOffset_ = 0;
		_maxHeapSizeOffset_ = 0;
		_numCPUsOffset_ = 0;
		_numaNodesOffset_ = 0;
		_osOffset_ = 0;
		_osVersionOffset_ = 0;
		_physicalMemoryOffset_ = 0;
		_regionCountOffset_ = 0;
		_regionSizeOffset_ = 0;
		_targetUtilizationOffset_ = 0;
		_timeWindowOffset_ = 0;
		_timestampOffset_ = 0;
		_unusedOffset_ = 0;
	}

}
