/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9VMDllLoadInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9VMDllLoadInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9VMDllLoadInfo.class)
public class J9VMDllLoadInfoPointer extends StructurePointer {

	// NULL
	public static final J9VMDllLoadInfoPointer NULL = new J9VMDllLoadInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9VMDllLoadInfoPointer(long address) {
		super(address);
	}

	public static J9VMDllLoadInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9VMDllLoadInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9VMDllLoadInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9VMDllLoadInfoPointer(address);
	}

	public J9VMDllLoadInfoPointer add(long count) {
		return J9VMDllLoadInfoPointer.cast(address + (J9VMDllLoadInfo.SIZEOF * count));
	}

	public J9VMDllLoadInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9VMDllLoadInfoPointer addOffset(long offset) {
		return J9VMDllLoadInfoPointer.cast(address + offset);
	}

	public J9VMDllLoadInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9VMDllLoadInfoPointer sub(long count) {
		return J9VMDllLoadInfoPointer.cast(address - (J9VMDllLoadInfo.SIZEOF * count));
	}

	public J9VMDllLoadInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9VMDllLoadInfoPointer subOffset(long offset) {
		return J9VMDllLoadInfoPointer.cast(address - offset);
	}

	public J9VMDllLoadInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9VMDllLoadInfoPointer untag(long mask) {
		return J9VMDllLoadInfoPointer.cast(address & ~mask);
	}

	public J9VMDllLoadInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9VMDllLoadInfo.SIZEOF;
	}

	// Implementation methods

	// U8[] alternateDllName
	public U8Pointer alternateDllNameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(J9VMDllLoadInfo._alternateDllNameOffset_));
	}

	// U32 completedBits
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_completedBitsOffset_", declaredType="U32")
	public UDATA completedBits() throws CorruptDataException {
		return new U32(getIntAtOffset(J9VMDllLoadInfo._completedBitsOffset_));
	}

	// U32 completedBits
	public UDATAPointer completedBitsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9VMDllLoadInfo._completedBitsOffset_));
	}

	// UDATA descriptor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_descriptorOffset_", declaredType="UDATA")
	public UDATA descriptor() throws CorruptDataException {
		return getUDATAAtOffset(J9VMDllLoadInfo._descriptorOffset_);
	}

	// UDATA descriptor
	public UDATAPointer descriptorEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9VMDllLoadInfo._descriptorOffset_));
	}

	// U8[] dllName
	public U8Pointer dllNameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(J9VMDllLoadInfo._dllNameOffset_));
	}

	// const U8* fatalErrorStr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fatalErrorStrOffset_", declaredType="const U8*")
	public U8Pointer fatalErrorStr() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9VMDllLoadInfo._fatalErrorStrOffset_));
	}

	// const U8* fatalErrorStr
	public PointerPointer fatalErrorStrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMDllLoadInfo._fatalErrorStrOffset_));
	}

	// void* j9vmdllmain
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_j9vmdllmainOffset_", declaredType="void*")
	public VoidPointer j9vmdllmain() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9VMDllLoadInfo._j9vmdllmainOffset_));
	}

	// void* j9vmdllmain
	public PointerPointer j9vmdllmainEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMDllLoadInfo._j9vmdllmainOffset_));
	}

	// U32 loadFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_loadFlagsOffset_", declaredType="U32")
	public UDATA loadFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(J9VMDllLoadInfo._loadFlagsOffset_));
	}

	// U32 loadFlags
	public UDATAPointer loadFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9VMDllLoadInfo._loadFlagsOffset_));
	}

	// void* reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedOffset_", declaredType="void*")
	public VoidPointer reserved() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9VMDllLoadInfo._reservedOffset_));
	}

	// void* reserved
	public PointerPointer reservedEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMDllLoadInfo._reservedOffset_));
	}

}
