/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9GSParameters
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9GSParameters {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _accessRegNum_s_;
	public static final int _accessRegNum_b_;
	public static final int _addressSpaceIndication_s_;
	public static final int _addressSpaceIndication_b_;
	public static final int _addressingMode_s_;
	public static final int _addressingMode_b_;
	public static final int _controlBlockOffset_;
	public static final int _flagsOffset_;
	public static final int _handlerAddrOffset_;
	public static final int _instructionAddrOffset_;
	public static final int _instructionCause_s_;
	public static final int _instructionCause_b_;
	public static final int _intermediateResultOffset_;
	public static final int _notUsed2Offset_;
	public static final int _operandAddrOffset_;
	public static final int _reserved8_s_;
	public static final int _reserved8_b_;
	public static final int _reservedBit1_s_;
	public static final int _reservedBit1_b_;
	public static final int _reservedMode5_s_;
	public static final int _reservedMode5_b_;
	public static final int _reservedMode6_s_;
	public static final int _reservedMode6_b_;
	public static final int _returnAddrOffset_;
	public static final int _transactionalExecutionMode_s_;
	public static final int _transactionalExecutionMode_b_;
	public static final int _translationMode_s_;
	public static final int _translationMode_b_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_accessRegNum_s_ = 0;
		_accessRegNum_b_ = 0;
		_addressSpaceIndication_s_ = 0;
		_addressSpaceIndication_b_ = 0;
		_addressingMode_s_ = 0;
		_addressingMode_b_ = 0;
		_controlBlockOffset_ = 0;
		_flagsOffset_ = 0;
		_handlerAddrOffset_ = 0;
		_instructionAddrOffset_ = 0;
		_instructionCause_s_ = 0;
		_instructionCause_b_ = 0;
		_intermediateResultOffset_ = 0;
		_notUsed2Offset_ = 0;
		_operandAddrOffset_ = 0;
		_reserved8_s_ = 0;
		_reserved8_b_ = 0;
		_reservedBit1_s_ = 0;
		_reservedBit1_b_ = 0;
		_reservedMode5_s_ = 0;
		_reservedMode5_b_ = 0;
		_reservedMode6_s_ = 0;
		_reservedMode6_b_ = 0;
		_returnAddrOffset_ = 0;
		_transactionalExecutionMode_s_ = 0;
		_transactionalExecutionMode_b_ = 0;
		_translationMode_s_ = 0;
		_translationMode_b_ = 0;
	}

}
