/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9JITExceptionTable
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9JITExceptionTable {

	// VM Constants

	public static final long SIZEOF;
	public static final long JIT_METADATA_FLAGS_USED_FOR_SIZE;
	public static final long JIT_METADATA_GC_MAP_32_BIT_OFFSETS;
	public static final long JIT_METADATA_IS_STUB;

	// Offsets

	public static final int _bodyInfoOffset_;
	public static final int _classNameOffset_;
	public static final int _codeCacheAllocOffset_;
	public static final int _constantPoolOffset_;
	public static final int _debugSlot1Offset_;
	public static final int _debugSlot2Offset_;
	public static final int _endPCOffset_;
	public static final int _endWarmPCOffset_;
	public static final int _flagsOffset_;
	public static final int _gcStackAtlasOffset_;
	public static final int _gpuCodeOffset_;
	public static final int _hotnessOffset_;
	public static final int _inlinedCallsOffset_;
	public static final int _invokeBasicCallInfoOffset_;
	public static final int _methodNameOffset_;
	public static final int _methodSignatureOffset_;
	public static final int _nextMethodOffset_;
	public static final int _numExcptionRangesOffset_;
	public static final int _objectTempSlotsOffset_;
	public static final int _osrInfoOffset_;
	public static final int _prevMethodOffset_;
	public static final int _prologuePushesOffset_;
	public static final int _ramMethodOffset_;
	public static final int _registerSaveDescriptionOffset_;
	public static final int _riDataOffset_;
	public static final int _runtimeAssumptionListOffset_;
	public static final int _scalarTempSlotsOffset_;
	public static final int _sizeOffset_;
	public static final int _slotsOffset_;
	public static final int _startColdPCOffset_;
	public static final int _startPCOffset_;
	public static final int _tempOffsetOffset_;
	public static final int _totalFrameSizeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		JIT_METADATA_FLAGS_USED_FOR_SIZE = 0;
		JIT_METADATA_GC_MAP_32_BIT_OFFSETS = 0;
		JIT_METADATA_IS_STUB = 0;
		_bodyInfoOffset_ = 0;
		_classNameOffset_ = 0;
		_codeCacheAllocOffset_ = 0;
		_constantPoolOffset_ = 0;
		_debugSlot1Offset_ = 0;
		_debugSlot2Offset_ = 0;
		_endPCOffset_ = 0;
		_endWarmPCOffset_ = 0;
		_flagsOffset_ = 0;
		_gcStackAtlasOffset_ = 0;
		_gpuCodeOffset_ = 0;
		_hotnessOffset_ = 0;
		_inlinedCallsOffset_ = 0;
		_invokeBasicCallInfoOffset_ = 0;
		_methodNameOffset_ = 0;
		_methodSignatureOffset_ = 0;
		_nextMethodOffset_ = 0;
		_numExcptionRangesOffset_ = 0;
		_objectTempSlotsOffset_ = 0;
		_osrInfoOffset_ = 0;
		_prevMethodOffset_ = 0;
		_prologuePushesOffset_ = 0;
		_ramMethodOffset_ = 0;
		_registerSaveDescriptionOffset_ = 0;
		_riDataOffset_ = 0;
		_runtimeAssumptionListOffset_ = 0;
		_scalarTempSlotsOffset_ = 0;
		_sizeOffset_ = 0;
		_slotsOffset_ = 0;
		_startColdPCOffset_ = 0;
		_startPCOffset_ = 0;
		_tempOffsetOffset_ = 0;
		_totalFrameSizeOffset_ = 0;
	}

}
