/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ClassloaderEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ClassloaderEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ClassloaderEntry.class)
public class ClassloaderEntryPointer extends StructurePointer {

	// NULL
	public static final ClassloaderEntryPointer NULL = new ClassloaderEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ClassloaderEntryPointer(long address) {
		super(address);
	}

	public static ClassloaderEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ClassloaderEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ClassloaderEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ClassloaderEntryPointer(address);
	}

	public ClassloaderEntryPointer add(long count) {
		return ClassloaderEntryPointer.cast(address + (ClassloaderEntry.SIZEOF * count));
	}

	public ClassloaderEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ClassloaderEntryPointer addOffset(long offset) {
		return ClassloaderEntryPointer.cast(address + offset);
	}

	public ClassloaderEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ClassloaderEntryPointer sub(long count) {
		return ClassloaderEntryPointer.cast(address - (ClassloaderEntry.SIZEOF * count));
	}

	public ClassloaderEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ClassloaderEntryPointer subOffset(long offset) {
		return ClassloaderEntryPointer.cast(address - offset);
	}

	public ClassloaderEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ClassloaderEntryPointer untag(long mask) {
		return ClassloaderEntryPointer.cast(address & ~mask);
	}

	public ClassloaderEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ClassloaderEntry.SIZEOF;
	}

	// Implementation methods

	// U32 classIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classIndexOffset_", declaredType="U32")
	public UDATA classIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ClassloaderEntry._classIndexOffset_));
	}

	// U32 classIndex
	public UDATAPointer classIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ClassloaderEntry._classIndexOffset_));
	}

	// J9ClassLoader* classLoader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classLoaderOffset_", declaredType="J9ClassLoader*")
	public J9ClassLoaderPointer classLoader() throws CorruptDataException {
		return J9ClassLoaderPointer.cast(getPointerAtOffset(ClassloaderEntry._classLoaderOffset_));
	}

	// J9ClassLoader* classLoader
	public PointerPointer classLoaderEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ClassloaderEntry._classLoaderOffset_));
	}

	// U32 index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="U32")
	public UDATA index() throws CorruptDataException {
		return new U32(getIntAtOffset(ClassloaderEntry._indexOffset_));
	}

	// U32 index
	public UDATAPointer indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ClassloaderEntry._indexOffset_));
	}

	// U32 nameIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nameIndexOffset_", declaredType="U32")
	public UDATA nameIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ClassloaderEntry._nameIndexOffset_));
	}

	// U32 nameIndex
	public UDATAPointer nameIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ClassloaderEntry._nameIndexOffset_));
	}

	// ClassloaderEntry* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="ClassloaderEntry*")
	public ClassloaderEntryPointer next() throws CorruptDataException {
		return ClassloaderEntryPointer.cast(getPointerAtOffset(ClassloaderEntry._nextOffset_));
	}

	// ClassloaderEntry* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ClassloaderEntry._nextOffset_));
	}

}
