/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: semid_dsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the semid_dsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=semid_ds.class)
public class semid_dsPointer extends StructurePointer {

	// NULL
	public static final semid_dsPointer NULL = new semid_dsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected semid_dsPointer(long address) {
		super(address);
	}

	public static semid_dsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static semid_dsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static semid_dsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new semid_dsPointer(address);
	}

	public semid_dsPointer add(long count) {
		return semid_dsPointer.cast(address + (semid_ds.SIZEOF * count));
	}

	public semid_dsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public semid_dsPointer addOffset(long offset) {
		return semid_dsPointer.cast(address + offset);
	}

	public semid_dsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public semid_dsPointer sub(long count) {
		return semid_dsPointer.cast(address - (semid_ds.SIZEOF * count));
	}

	public semid_dsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public semid_dsPointer subOffset(long offset) {
		return semid_dsPointer.cast(address - offset);
	}

	public semid_dsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public semid_dsPointer untag(long mask) {
		return semid_dsPointer.cast(address & ~mask);
	}

	public semid_dsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return semid_ds.SIZEOF;
	}

	// Implementation methods

	// U64 __unused1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___unused1Offset_", declaredType="U64")
	public UDATA __unused1() throws CorruptDataException {
		return new U64(getLongAtOffset(semid_ds.___unused1Offset_));
	}

	// U64 __unused1
	public UDATAPointer __unused1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(semid_ds.___unused1Offset_));
	}

	// U64 __unused2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___unused2Offset_", declaredType="U64")
	public UDATA __unused2() throws CorruptDataException {
		return new U64(getLongAtOffset(semid_ds.___unused2Offset_));
	}

	// U64 __unused2
	public UDATAPointer __unused2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(semid_ds.___unused2Offset_));
	}

	// U64 __unused3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___unused3Offset_", declaredType="U64")
	public UDATA __unused3() throws CorruptDataException {
		return new U64(getLongAtOffset(semid_ds.___unused3Offset_));
	}

	// U64 __unused3
	public UDATAPointer __unused3EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(semid_ds.___unused3Offset_));
	}

	// U64 __unused4
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___unused4Offset_", declaredType="U64")
	public UDATA __unused4() throws CorruptDataException {
		return new U64(getLongAtOffset(semid_ds.___unused4Offset_));
	}

	// U64 __unused4
	public UDATAPointer __unused4EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(semid_ds.___unused4Offset_));
	}

	// __time_t sem_ctime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sem_ctimeOffset_", declaredType="__time_t")
	public IDATA sem_ctime() throws CorruptDataException {
		return new I64(getLongAtOffset(semid_ds._sem_ctimeOffset_));
	}

	// __time_t sem_ctime
	public IDATAPointer sem_ctimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(semid_ds._sem_ctimeOffset_));
	}

	// U64 sem_nsems
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sem_nsemsOffset_", declaredType="U64")
	public UDATA sem_nsems() throws CorruptDataException {
		return new U64(getLongAtOffset(semid_ds._sem_nsemsOffset_));
	}

	// U64 sem_nsems
	public UDATAPointer sem_nsemsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(semid_ds._sem_nsemsOffset_));
	}

	// __time_t sem_otime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sem_otimeOffset_", declaredType="__time_t")
	public IDATA sem_otime() throws CorruptDataException {
		return new I64(getLongAtOffset(semid_ds._sem_otimeOffset_));
	}

	// __time_t sem_otime
	public IDATAPointer sem_otimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(semid_ds._sem_otimeOffset_));
	}

	// ipc_perm sem_perm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sem_permOffset_", declaredType="ipc_perm")
	public ipc_permPointer sem_perm() throws CorruptDataException {
		return ipc_permPointer.cast(nonNullFieldEA(semid_ds._sem_permOffset_));
	}

	// ipc_perm sem_perm
	public PointerPointer sem_permEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(semid_ds._sem_permOffset_));
	}

}
