/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: sigcontextPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the sigcontextPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=sigcontext.class)
public class sigcontextPointer extends StructurePointer {

	// NULL
	public static final sigcontextPointer NULL = new sigcontextPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected sigcontextPointer(long address) {
		super(address);
	}

	public static sigcontextPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static sigcontextPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static sigcontextPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new sigcontextPointer(address);
	}

	public sigcontextPointer add(long count) {
		return sigcontextPointer.cast(address + (sigcontext.SIZEOF * count));
	}

	public sigcontextPointer add(Scalar count) {
		return add(count.longValue());
	}

	public sigcontextPointer addOffset(long offset) {
		return sigcontextPointer.cast(address + offset);
	}

	public sigcontextPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public sigcontextPointer sub(long count) {
		return sigcontextPointer.cast(address - (sigcontext.SIZEOF * count));
	}

	public sigcontextPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public sigcontextPointer subOffset(long offset) {
		return sigcontextPointer.cast(address - offset);
	}

	public sigcontextPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public sigcontextPointer untag(long mask) {
		return sigcontextPointer.cast(address & ~mask);
	}

	public sigcontextPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return sigcontext.SIZEOF;
	}

	// Implementation methods

	// U16 __pad0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pad0Offset_", declaredType="U16")
	public U16 __pad0() throws CorruptDataException {
		return new U16(getShortAtOffset(sigcontext.___pad0Offset_));
	}

	// U16 __pad0
	public U16Pointer __pad0EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(sigcontext.___pad0Offset_));
	}

	// U64[] __reserved1
	public UDATAPointer __reserved1EA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(sigcontext.___reserved1Offset_));
	}

	// U64 cr2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr2Offset_", declaredType="U64")
	public UDATA cr2() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._cr2Offset_));
	}

	// U64 cr2
	public UDATAPointer cr2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._cr2Offset_));
	}

	// U16 cs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_csOffset_", declaredType="U16")
	public U16 cs() throws CorruptDataException {
		return new U16(getShortAtOffset(sigcontext._csOffset_));
	}

	// U16 cs
	public U16Pointer csEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(sigcontext._csOffset_));
	}

	// U64 eflags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_eflagsOffset_", declaredType="U64")
	public UDATA eflags() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._eflagsOffset_));
	}

	// U64 eflags
	public UDATAPointer eflagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._eflagsOffset_));
	}

	// U64 err
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errOffset_", declaredType="U64")
	public UDATA err() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._errOffset_));
	}

	// U64 err
	public UDATAPointer errEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._errOffset_));
	}

	// _fpstate* fpstate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpstateOffset_", declaredType="_fpstate*")
	public _fpstatePointer fpstate() throws CorruptDataException {
		return _fpstatePointer.cast(getPointerAtOffset(sigcontext._fpstateOffset_));
	}

	// _fpstate* fpstate
	public PointerPointer fpstateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sigcontext._fpstateOffset_));
	}

	// U16 fs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fsOffset_", declaredType="U16")
	public U16 fs() throws CorruptDataException {
		return new U16(getShortAtOffset(sigcontext._fsOffset_));
	}

	// U16 fs
	public U16Pointer fsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(sigcontext._fsOffset_));
	}

	// U16 gs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gsOffset_", declaredType="U16")
	public U16 gs() throws CorruptDataException {
		return new U16(getShortAtOffset(sigcontext._gsOffset_));
	}

	// U16 gs
	public U16Pointer gsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(sigcontext._gsOffset_));
	}

	// U64 oldmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_oldmaskOffset_", declaredType="U64")
	public UDATA oldmask() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._oldmaskOffset_));
	}

	// U64 oldmask
	public UDATAPointer oldmaskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._oldmaskOffset_));
	}

	// U64 r10
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_r10Offset_", declaredType="U64")
	public UDATA r10() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._r10Offset_));
	}

	// U64 r10
	public UDATAPointer r10EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._r10Offset_));
	}

	// U64 r11
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_r11Offset_", declaredType="U64")
	public UDATA r11() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._r11Offset_));
	}

	// U64 r11
	public UDATAPointer r11EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._r11Offset_));
	}

	// U64 r12
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_r12Offset_", declaredType="U64")
	public UDATA r12() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._r12Offset_));
	}

	// U64 r12
	public UDATAPointer r12EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._r12Offset_));
	}

	// U64 r13
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_r13Offset_", declaredType="U64")
	public UDATA r13() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._r13Offset_));
	}

	// U64 r13
	public UDATAPointer r13EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._r13Offset_));
	}

	// U64 r14
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_r14Offset_", declaredType="U64")
	public UDATA r14() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._r14Offset_));
	}

	// U64 r14
	public UDATAPointer r14EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._r14Offset_));
	}

	// U64 r15
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_r15Offset_", declaredType="U64")
	public UDATA r15() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._r15Offset_));
	}

	// U64 r15
	public UDATAPointer r15EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._r15Offset_));
	}

	// U64 r8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_r8Offset_", declaredType="U64")
	public UDATA r8() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._r8Offset_));
	}

	// U64 r8
	public UDATAPointer r8EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._r8Offset_));
	}

	// U64 r9
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_r9Offset_", declaredType="U64")
	public UDATA r9() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._r9Offset_));
	}

	// U64 r9
	public UDATAPointer r9EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._r9Offset_));
	}

	// U64 rax
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_raxOffset_", declaredType="U64")
	public UDATA rax() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._raxOffset_));
	}

	// U64 rax
	public UDATAPointer raxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._raxOffset_));
	}

	// U64 rbp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rbpOffset_", declaredType="U64")
	public UDATA rbp() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._rbpOffset_));
	}

	// U64 rbp
	public UDATAPointer rbpEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._rbpOffset_));
	}

	// U64 rbx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rbxOffset_", declaredType="U64")
	public UDATA rbx() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._rbxOffset_));
	}

	// U64 rbx
	public UDATAPointer rbxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._rbxOffset_));
	}

	// U64 rcx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rcxOffset_", declaredType="U64")
	public UDATA rcx() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._rcxOffset_));
	}

	// U64 rcx
	public UDATAPointer rcxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._rcxOffset_));
	}

	// U64 rdi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rdiOffset_", declaredType="U64")
	public UDATA rdi() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._rdiOffset_));
	}

	// U64 rdi
	public UDATAPointer rdiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._rdiOffset_));
	}

	// U64 rdx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rdxOffset_", declaredType="U64")
	public UDATA rdx() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._rdxOffset_));
	}

	// U64 rdx
	public UDATAPointer rdxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._rdxOffset_));
	}

	// U64 rip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ripOffset_", declaredType="U64")
	public UDATA rip() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._ripOffset_));
	}

	// U64 rip
	public UDATAPointer ripEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._ripOffset_));
	}

	// U64 rsi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rsiOffset_", declaredType="U64")
	public UDATA rsi() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._rsiOffset_));
	}

	// U64 rsi
	public UDATAPointer rsiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._rsiOffset_));
	}

	// U64 rsp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rspOffset_", declaredType="U64")
	public UDATA rsp() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._rspOffset_));
	}

	// U64 rsp
	public UDATAPointer rspEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._rspOffset_));
	}

	// U64 trapno
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_trapnoOffset_", declaredType="U64")
	public UDATA trapno() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._trapnoOffset_));
	}

	// U64 trapno
	public UDATAPointer trapnoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._trapnoOffset_));
	}

}
