/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9ArrayROMClasses
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9ArrayROMClasses {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _booleanArrayClassName$dataOffset_;
	public static final int _booleanArrayClassName$lengthOffset_;
	public static final int _booleanArrayROMClassOffset_;
	public static final int _byteArrayClassName$dataOffset_;
	public static final int _byteArrayClassName$lengthOffset_;
	public static final int _byteArrayROMClassOffset_;
	public static final int _charArrayClassName$dataOffset_;
	public static final int _charArrayClassName$lengthOffset_;
	public static final int _charArrayROMClassOffset_;
	public static final int _cloneableClassName$dataOffset_;
	public static final int _cloneableClassName$lengthOffset_;
	public static final int _doubleArrayClassName$dataOffset_;
	public static final int _doubleArrayClassName$lengthOffset_;
	public static final int _doubleArrayROMClassOffset_;
	public static final int _floatArrayClassName$dataOffset_;
	public static final int _floatArrayClassName$lengthOffset_;
	public static final int _floatArrayROMClassOffset_;
	public static final int _headerOffset_;
	public static final int _intArrayClassName$dataOffset_;
	public static final int _intArrayClassName$lengthOffset_;
	public static final int _intArrayROMClassOffset_;
	public static final int _interfaceClasses$cloneableOffset_;
	public static final int _interfaceClasses$serializeableOffset_;
	public static final int _longArrayClassName$dataOffset_;
	public static final int _longArrayClassName$lengthOffset_;
	public static final int _longArrayROMClassOffset_;
	public static final int _objectArrayClassName$dataOffset_;
	public static final int _objectArrayClassName$lengthOffset_;
	public static final int _objectArrayROMClassOffset_;
	public static final int _objectClassName$dataOffset_;
	public static final int _objectClassName$lengthOffset_;
	public static final int _serializeableClassName$dataOffset_;
	public static final int _serializeableClassName$lengthOffset_;
	public static final int _shortArrayClassName$dataOffset_;
	public static final int _shortArrayClassName$lengthOffset_;
	public static final int _shortArrayROMClassOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_booleanArrayClassName$dataOffset_ = 0;
		_booleanArrayClassName$lengthOffset_ = 0;
		_booleanArrayROMClassOffset_ = 0;
		_byteArrayClassName$dataOffset_ = 0;
		_byteArrayClassName$lengthOffset_ = 0;
		_byteArrayROMClassOffset_ = 0;
		_charArrayClassName$dataOffset_ = 0;
		_charArrayClassName$lengthOffset_ = 0;
		_charArrayROMClassOffset_ = 0;
		_cloneableClassName$dataOffset_ = 0;
		_cloneableClassName$lengthOffset_ = 0;
		_doubleArrayClassName$dataOffset_ = 0;
		_doubleArrayClassName$lengthOffset_ = 0;
		_doubleArrayROMClassOffset_ = 0;
		_floatArrayClassName$dataOffset_ = 0;
		_floatArrayClassName$lengthOffset_ = 0;
		_floatArrayROMClassOffset_ = 0;
		_headerOffset_ = 0;
		_intArrayClassName$dataOffset_ = 0;
		_intArrayClassName$lengthOffset_ = 0;
		_intArrayROMClassOffset_ = 0;
		_interfaceClasses$cloneableOffset_ = 0;
		_interfaceClasses$serializeableOffset_ = 0;
		_longArrayClassName$dataOffset_ = 0;
		_longArrayClassName$lengthOffset_ = 0;
		_longArrayROMClassOffset_ = 0;
		_objectArrayClassName$dataOffset_ = 0;
		_objectArrayClassName$lengthOffset_ = 0;
		_objectArrayROMClassOffset_ = 0;
		_objectClassName$dataOffset_ = 0;
		_objectClassName$lengthOffset_ = 0;
		_serializeableClassName$dataOffset_ = 0;
		_serializeableClassName$lengthOffset_ = 0;
		_shortArrayClassName$dataOffset_ = 0;
		_shortArrayClassName$lengthOffset_ = 0;
		_shortArrayROMClassOffset_ = 0;
	}

}
