/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: GCHeapConfigurationEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the GCHeapConfigurationEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=GCHeapConfigurationEntry.class)
public class GCHeapConfigurationEntryPointer extends StructurePointer {

	// NULL
	public static final GCHeapConfigurationEntryPointer NULL = new GCHeapConfigurationEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected GCHeapConfigurationEntryPointer(long address) {
		super(address);
	}

	public static GCHeapConfigurationEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static GCHeapConfigurationEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static GCHeapConfigurationEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new GCHeapConfigurationEntryPointer(address);
	}

	public GCHeapConfigurationEntryPointer add(long count) {
		return GCHeapConfigurationEntryPointer.cast(address + (GCHeapConfigurationEntry.SIZEOF * count));
	}

	public GCHeapConfigurationEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public GCHeapConfigurationEntryPointer addOffset(long offset) {
		return GCHeapConfigurationEntryPointer.cast(address + offset);
	}

	public GCHeapConfigurationEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public GCHeapConfigurationEntryPointer sub(long count) {
		return GCHeapConfigurationEntryPointer.cast(address - (GCHeapConfigurationEntry.SIZEOF * count));
	}

	public GCHeapConfigurationEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public GCHeapConfigurationEntryPointer subOffset(long offset) {
		return GCHeapConfigurationEntryPointer.cast(address - offset);
	}

	public GCHeapConfigurationEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public GCHeapConfigurationEntryPointer untag(long mask) {
		return GCHeapConfigurationEntryPointer.cast(address & ~mask);
	}

	public GCHeapConfigurationEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return GCHeapConfigurationEntry.SIZEOF;
	}

	// Implementation methods

	// OOPModeType compressedOopsMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_compressedOopsModeOffset_", declaredType="OOPModeType")
	public long compressedOopsMode() throws CorruptDataException {
		if (OOPModeType.SIZEOF == 1) {
			return getByteAtOffset(GCHeapConfigurationEntry._compressedOopsModeOffset_);
		} else if (OOPModeType.SIZEOF == 2) {
			return getShortAtOffset(GCHeapConfigurationEntry._compressedOopsModeOffset_);
		} else if (OOPModeType.SIZEOF == 4) {
			return getIntAtOffset(GCHeapConfigurationEntry._compressedOopsModeOffset_);
		} else if (OOPModeType.SIZEOF == 8) {
			return getLongAtOffset(GCHeapConfigurationEntry._compressedOopsModeOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// OOPModeType compressedOopsMode
	public EnumPointer compressedOopsModeEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(GCHeapConfigurationEntry._compressedOopsModeOffset_), OOPModeType.class);
	}

	// U64 heapAddressBits
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_heapAddressBitsOffset_", declaredType="U64")
	public UDATA heapAddressBits() throws CorruptDataException {
		return new U64(getLongAtOffset(GCHeapConfigurationEntry._heapAddressBitsOffset_));
	}

	// U64 heapAddressBits
	public UDATAPointer heapAddressBitsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GCHeapConfigurationEntry._heapAddressBitsOffset_));
	}

	// U64 initialSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_initialSizeOffset_", declaredType="U64")
	public UDATA initialSize() throws CorruptDataException {
		return new U64(getLongAtOffset(GCHeapConfigurationEntry._initialSizeOffset_));
	}

	// U64 initialSize
	public UDATAPointer initialSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GCHeapConfigurationEntry._initialSizeOffset_));
	}

	// U64 maxSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxSizeOffset_", declaredType="U64")
	public UDATA maxSize() throws CorruptDataException {
		return new U64(getLongAtOffset(GCHeapConfigurationEntry._maxSizeOffset_));
	}

	// U64 maxSize
	public UDATAPointer maxSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GCHeapConfigurationEntry._maxSizeOffset_));
	}

	// U64 minSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_minSizeOffset_", declaredType="U64")
	public UDATA minSize() throws CorruptDataException {
		return new U64(getLongAtOffset(GCHeapConfigurationEntry._minSizeOffset_));
	}

	// U64 minSize
	public UDATAPointer minSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GCHeapConfigurationEntry._minSizeOffset_));
	}

	// U64 objectAlignment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_objectAlignmentOffset_", declaredType="U64")
	public UDATA objectAlignment() throws CorruptDataException {
		return new U64(getLongAtOffset(GCHeapConfigurationEntry._objectAlignmentOffset_));
	}

	// U64 objectAlignment
	public UDATAPointer objectAlignmentEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GCHeapConfigurationEntry._objectAlignmentOffset_));
	}

	// U64 usesCompressedOops
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_usesCompressedOopsOffset_", declaredType="U64")
	public UDATA usesCompressedOops() throws CorruptDataException {
		return new U64(getLongAtOffset(GCHeapConfigurationEntry._usesCompressedOopsOffset_));
	}

	// U64 usesCompressedOops
	public UDATAPointer usesCompressedOopsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GCHeapConfigurationEntry._usesCompressedOopsOffset_));
	}

}
