/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: KNOWNFOLDER_DEFINITIONPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the KNOWNFOLDER_DEFINITIONPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=KNOWNFOLDER_DEFINITION.class)
public class KNOWNFOLDER_DEFINITIONPointer extends StructurePointer {

	// NULL
	public static final KNOWNFOLDER_DEFINITIONPointer NULL = new KNOWNFOLDER_DEFINITIONPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected KNOWNFOLDER_DEFINITIONPointer(long address) {
		super(address);
	}

	public static KNOWNFOLDER_DEFINITIONPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static KNOWNFOLDER_DEFINITIONPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static KNOWNFOLDER_DEFINITIONPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new KNOWNFOLDER_DEFINITIONPointer(address);
	}

	public KNOWNFOLDER_DEFINITIONPointer add(long count) {
		return KNOWNFOLDER_DEFINITIONPointer.cast(address + (KNOWNFOLDER_DEFINITION.SIZEOF * count));
	}

	public KNOWNFOLDER_DEFINITIONPointer add(Scalar count) {
		return add(count.longValue());
	}

	public KNOWNFOLDER_DEFINITIONPointer addOffset(long offset) {
		return KNOWNFOLDER_DEFINITIONPointer.cast(address + offset);
	}

	public KNOWNFOLDER_DEFINITIONPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public KNOWNFOLDER_DEFINITIONPointer sub(long count) {
		return KNOWNFOLDER_DEFINITIONPointer.cast(address - (KNOWNFOLDER_DEFINITION.SIZEOF * count));
	}

	public KNOWNFOLDER_DEFINITIONPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public KNOWNFOLDER_DEFINITIONPointer subOffset(long offset) {
		return KNOWNFOLDER_DEFINITIONPointer.cast(address - offset);
	}

	public KNOWNFOLDER_DEFINITIONPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public KNOWNFOLDER_DEFINITIONPointer untag(long mask) {
		return KNOWNFOLDER_DEFINITIONPointer.cast(address & ~mask);
	}

	public KNOWNFOLDER_DEFINITIONPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return KNOWNFOLDER_DEFINITION.SIZEOF;
	}

	// Implementation methods

	// KF_CATEGORY category
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_categoryOffset_", declaredType="KF_CATEGORY")
	public long category() throws CorruptDataException {
		if (KF_CATEGORY.SIZEOF == 1) {
			return getByteAtOffset(KNOWNFOLDER_DEFINITION._categoryOffset_);
		} else if (KF_CATEGORY.SIZEOF == 2) {
			return getShortAtOffset(KNOWNFOLDER_DEFINITION._categoryOffset_);
		} else if (KF_CATEGORY.SIZEOF == 4) {
			return getIntAtOffset(KNOWNFOLDER_DEFINITION._categoryOffset_);
		} else if (KF_CATEGORY.SIZEOF == 8) {
			return getLongAtOffset(KNOWNFOLDER_DEFINITION._categoryOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// KF_CATEGORY category
	public EnumPointer categoryEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._categoryOffset_), KF_CATEGORY.class);
	}

	// U32 dwAttributes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwAttributesOffset_", declaredType="U32")
	public UDATA dwAttributes() throws CorruptDataException {
		return new U32(getIntAtOffset(KNOWNFOLDER_DEFINITION._dwAttributesOffset_));
	}

	// U32 dwAttributes
	public UDATAPointer dwAttributesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._dwAttributesOffset_));
	}

	// _GUID fidParent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fidParentOffset_", declaredType="_GUID")
	public _GUIDPointer fidParent() throws CorruptDataException {
		return _GUIDPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._fidParentOffset_));
	}

	// _GUID fidParent
	public PointerPointer fidParentEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._fidParentOffset_));
	}

	// _GUID ftidType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ftidTypeOffset_", declaredType="_GUID")
	public _GUIDPointer ftidType() throws CorruptDataException {
		return _GUIDPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._ftidTypeOffset_));
	}

	// _GUID ftidType
	public PointerPointer ftidTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._ftidTypeOffset_));
	}

	// U32 kfdFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_kfdFlagsOffset_", declaredType="U32")
	public UDATA kfdFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(KNOWNFOLDER_DEFINITION._kfdFlagsOffset_));
	}

	// U32 kfdFlags
	public UDATAPointer kfdFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._kfdFlagsOffset_));
	}

	// U16* pszDescription
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pszDescriptionOffset_", declaredType="U16*")
	public U16Pointer pszDescription() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(KNOWNFOLDER_DEFINITION._pszDescriptionOffset_));
	}

	// U16* pszDescription
	public PointerPointer pszDescriptionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._pszDescriptionOffset_));
	}

	// U16* pszIcon
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pszIconOffset_", declaredType="U16*")
	public U16Pointer pszIcon() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(KNOWNFOLDER_DEFINITION._pszIconOffset_));
	}

	// U16* pszIcon
	public PointerPointer pszIconEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._pszIconOffset_));
	}

	// U16* pszLocalizedName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pszLocalizedNameOffset_", declaredType="U16*")
	public U16Pointer pszLocalizedName() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(KNOWNFOLDER_DEFINITION._pszLocalizedNameOffset_));
	}

	// U16* pszLocalizedName
	public PointerPointer pszLocalizedNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._pszLocalizedNameOffset_));
	}

	// U16* pszName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pszNameOffset_", declaredType="U16*")
	public U16Pointer pszName() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(KNOWNFOLDER_DEFINITION._pszNameOffset_));
	}

	// U16* pszName
	public PointerPointer pszNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._pszNameOffset_));
	}

	// U16* pszParsingName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pszParsingNameOffset_", declaredType="U16*")
	public U16Pointer pszParsingName() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(KNOWNFOLDER_DEFINITION._pszParsingNameOffset_));
	}

	// U16* pszParsingName
	public PointerPointer pszParsingNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._pszParsingNameOffset_));
	}

	// U16* pszRelativePath
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pszRelativePathOffset_", declaredType="U16*")
	public U16Pointer pszRelativePath() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(KNOWNFOLDER_DEFINITION._pszRelativePathOffset_));
	}

	// U16* pszRelativePath
	public PointerPointer pszRelativePathEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._pszRelativePathOffset_));
	}

	// U16* pszSecurity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pszSecurityOffset_", declaredType="U16*")
	public U16Pointer pszSecurity() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(KNOWNFOLDER_DEFINITION._pszSecurityOffset_));
	}

	// U16* pszSecurity
	public PointerPointer pszSecurityEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._pszSecurityOffset_));
	}

	// U16* pszTooltip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pszTooltipOffset_", declaredType="U16*")
	public U16Pointer pszTooltip() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(KNOWNFOLDER_DEFINITION._pszTooltipOffset_));
	}

	// U16* pszTooltip
	public PointerPointer pszTooltipEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(KNOWNFOLDER_DEFINITION._pszTooltipOffset_));
	}

}
