/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_GlobalVLHGCStats$MM_HeapSizingDataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_GlobalVLHGCStats$MM_HeapSizingDataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_GlobalVLHGCStats$MM_HeapSizingData.class)
public class MM_GlobalVLHGCStats$MM_HeapSizingDataPointer extends StructurePointer {

	// NULL
	public static final MM_GlobalVLHGCStats$MM_HeapSizingDataPointer NULL = new MM_GlobalVLHGCStats$MM_HeapSizingDataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_GlobalVLHGCStats$MM_HeapSizingDataPointer(long address) {
		super(address);
	}

	public static MM_GlobalVLHGCStats$MM_HeapSizingDataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_GlobalVLHGCStats$MM_HeapSizingDataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_GlobalVLHGCStats$MM_HeapSizingDataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_GlobalVLHGCStats$MM_HeapSizingDataPointer(address);
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer add(long count) {
		return MM_GlobalVLHGCStats$MM_HeapSizingDataPointer.cast(address + (MM_GlobalVLHGCStats$MM_HeapSizingData.SIZEOF * count));
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer addOffset(long offset) {
		return MM_GlobalVLHGCStats$MM_HeapSizingDataPointer.cast(address + offset);
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer sub(long count) {
		return MM_GlobalVLHGCStats$MM_HeapSizingDataPointer.cast(address - (MM_GlobalVLHGCStats$MM_HeapSizingData.SIZEOF * count));
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer subOffset(long offset) {
		return MM_GlobalVLHGCStats$MM_HeapSizingDataPointer.cast(address - offset);
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer untag(long mask) {
		return MM_GlobalVLHGCStats$MM_HeapSizingDataPointer.cast(address & ~mask);
	}

	public MM_GlobalVLHGCStats$MM_HeapSizingDataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_GlobalVLHGCStats$MM_HeapSizingData.SIZEOF;
	}

	// Implementation methods

	// U64 avgPgcIntervalUs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_avgPgcIntervalUsOffset_", declaredType="U64")
	public UDATA avgPgcIntervalUs() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GlobalVLHGCStats$MM_HeapSizingData._avgPgcIntervalUsOffset_));
	}

	// U64 avgPgcIntervalUs
	public UDATAPointer avgPgcIntervalUsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GlobalVLHGCStats$MM_HeapSizingData._avgPgcIntervalUsOffset_));
	}

	// U64 avgPgcTimeUs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_avgPgcTimeUsOffset_", declaredType="U64")
	public UDATA avgPgcTimeUs() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GlobalVLHGCStats$MM_HeapSizingData._avgPgcTimeUsOffset_));
	}

	// U64 avgPgcTimeUs
	public UDATAPointer avgPgcTimeUsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GlobalVLHGCStats$MM_HeapSizingData._avgPgcTimeUsOffset_));
	}

	// I64 edenRegionChange
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_edenRegionChangeOffset_", declaredType="I64")
	public IDATA edenRegionChange() throws CorruptDataException {
		return new I64(getLongAtOffset(MM_GlobalVLHGCStats$MM_HeapSizingData._edenRegionChangeOffset_));
	}

	// I64 edenRegionChange
	public IDATAPointer edenRegionChangeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(MM_GlobalVLHGCStats$MM_HeapSizingData._edenRegionChangeOffset_));
	}

	// U64 freeTenure
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_freeTenureOffset_", declaredType="U64")
	public UDATA freeTenure() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GlobalVLHGCStats$MM_HeapSizingData._freeTenureOffset_));
	}

	// U64 freeTenure
	public UDATAPointer freeTenureEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GlobalVLHGCStats$MM_HeapSizingData._freeTenureOffset_));
	}

	// U64 gmpTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gmpTimeOffset_", declaredType="U64")
	public UDATA gmpTime() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GlobalVLHGCStats$MM_HeapSizingData._gmpTimeOffset_));
	}

	// U64 gmpTime
	public UDATAPointer gmpTimeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GlobalVLHGCStats$MM_HeapSizingData._gmpTimeOffset_));
	}

	// U64 pgcCountSinceGMPEnd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgcCountSinceGMPEndOffset_", declaredType="U64")
	public UDATA pgcCountSinceGMPEnd() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GlobalVLHGCStats$MM_HeapSizingData._pgcCountSinceGMPEndOffset_));
	}

	// U64 pgcCountSinceGMPEnd
	public UDATAPointer pgcCountSinceGMPEndEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GlobalVLHGCStats$MM_HeapSizingData._pgcCountSinceGMPEndOffset_));
	}

	// bool readyToResizeAtGlobalEnd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_readyToResizeAtGlobalEndOffset_", declaredType="bool")
	public boolean readyToResizeAtGlobalEnd() throws CorruptDataException {
		return getBoolAtOffset(MM_GlobalVLHGCStats$MM_HeapSizingData._readyToResizeAtGlobalEndOffset_);
	}

	// bool readyToResizeAtGlobalEnd
	public BoolPointer readyToResizeAtGlobalEndEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_GlobalVLHGCStats$MM_HeapSizingData._readyToResizeAtGlobalEndOffset_));
	}

	// U64 reservedSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedSizeOffset_", declaredType="U64")
	public UDATA reservedSize() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_GlobalVLHGCStats$MM_HeapSizingData._reservedSizeOffset_));
	}

	// U64 reservedSize
	public UDATAPointer reservedSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_GlobalVLHGCStats$MM_HeapSizingData._reservedSizeOffset_));
	}

}
