/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MonitorWaitEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MonitorWaitEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MonitorWaitEntry.class)
public class MonitorWaitEntryPointer extends StructurePointer {

	// NULL
	public static final MonitorWaitEntryPointer NULL = new MonitorWaitEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MonitorWaitEntryPointer(long address) {
		super(address);
	}

	public static MonitorWaitEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MonitorWaitEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MonitorWaitEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MonitorWaitEntryPointer(address);
	}

	public MonitorWaitEntryPointer add(long count) {
		return MonitorWaitEntryPointer.cast(address + (MonitorWaitEntry.SIZEOF * count));
	}

	public MonitorWaitEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MonitorWaitEntryPointer addOffset(long offset) {
		return MonitorWaitEntryPointer.cast(address + offset);
	}

	public MonitorWaitEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MonitorWaitEntryPointer sub(long count) {
		return MonitorWaitEntryPointer.cast(address - (MonitorWaitEntry.SIZEOF * count));
	}

	public MonitorWaitEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MonitorWaitEntryPointer subOffset(long offset) {
		return MonitorWaitEntryPointer.cast(address - offset);
	}

	public MonitorWaitEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MonitorWaitEntryPointer untag(long mask) {
		return MonitorWaitEntryPointer.cast(address & ~mask);
	}

	public MonitorWaitEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MonitorWaitEntry.SIZEOF;
	}

	// Implementation methods

	// I64 duration
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_durationOffset_", declaredType="I64")
	public IDATA duration() throws CorruptDataException {
		return new I64(getLongAtOffset(MonitorWaitEntry._durationOffset_));
	}

	// I64 duration
	public IDATAPointer durationEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._durationOffset_));
	}

	// U32 eventThreadIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_eventThreadIndexOffset_", declaredType="U32")
	public UDATA eventThreadIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(MonitorWaitEntry._eventThreadIndexOffset_));
	}

	// U32 eventThreadIndex
	public UDATAPointer eventThreadIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._eventThreadIndexOffset_));
	}

	// I64 monitorAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_monitorAddressOffset_", declaredType="I64")
	public IDATA monitorAddress() throws CorruptDataException {
		return new I64(getLongAtOffset(MonitorWaitEntry._monitorAddressOffset_));
	}

	// I64 monitorAddress
	public IDATAPointer monitorAddressEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._monitorAddressOffset_));
	}

	// U32 monitorClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_monitorClassOffset_", declaredType="U32")
	public UDATA monitorClass() throws CorruptDataException {
		return new U32(getIntAtOffset(MonitorWaitEntry._monitorClassOffset_));
	}

	// U32 monitorClass
	public UDATAPointer monitorClassEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._monitorClassOffset_));
	}

	// U32 notifierThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_notifierThreadOffset_", declaredType="U32")
	public UDATA notifierThread() throws CorruptDataException {
		return new U32(getIntAtOffset(MonitorWaitEntry._notifierThreadOffset_));
	}

	// U32 notifierThread
	public UDATAPointer notifierThreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._notifierThreadOffset_));
	}

	// U32 stackTraceIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stackTraceIndexOffset_", declaredType="U32")
	public UDATA stackTraceIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(MonitorWaitEntry._stackTraceIndexOffset_));
	}

	// U32 stackTraceIndex
	public UDATAPointer stackTraceIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._stackTraceIndexOffset_));
	}

	// U32 threadIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadIndexOffset_", declaredType="U32")
	public UDATA threadIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(MonitorWaitEntry._threadIndexOffset_));
	}

	// U32 threadIndex
	public UDATAPointer threadIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._threadIndexOffset_));
	}

	// I64 ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
	public IDATA ticks() throws CorruptDataException {
		return new I64(getLongAtOffset(MonitorWaitEntry._ticksOffset_));
	}

	// I64 ticks
	public IDATAPointer ticksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._ticksOffset_));
	}

	// I64 timeOut
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timeOutOffset_", declaredType="I64")
	public IDATA timeOut() throws CorruptDataException {
		return new I64(getLongAtOffset(MonitorWaitEntry._timeOutOffset_));
	}

	// I64 timeOut
	public IDATAPointer timeOutEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._timeOutOffset_));
	}

	// U64 timedOut
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timedOutOffset_", declaredType="U64")
	public UDATA timedOut() throws CorruptDataException {
		return new U64(getLongAtOffset(MonitorWaitEntry._timedOutOffset_));
	}

	// U64 timedOut
	public UDATAPointer timedOutEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MonitorWaitEntry._timedOutOffset_));
	}

}
