/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: NativeLibraryEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the NativeLibraryEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=NativeLibraryEntry.class)
public class NativeLibraryEntryPointer extends StructurePointer {

	// NULL
	public static final NativeLibraryEntryPointer NULL = new NativeLibraryEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected NativeLibraryEntryPointer(long address) {
		super(address);
	}

	public static NativeLibraryEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static NativeLibraryEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static NativeLibraryEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new NativeLibraryEntryPointer(address);
	}

	public NativeLibraryEntryPointer add(long count) {
		return NativeLibraryEntryPointer.cast(address + (NativeLibraryEntry.SIZEOF * count));
	}

	public NativeLibraryEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public NativeLibraryEntryPointer addOffset(long offset) {
		return NativeLibraryEntryPointer.cast(address + offset);
	}

	public NativeLibraryEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public NativeLibraryEntryPointer sub(long count) {
		return NativeLibraryEntryPointer.cast(address - (NativeLibraryEntry.SIZEOF * count));
	}

	public NativeLibraryEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public NativeLibraryEntryPointer subOffset(long offset) {
		return NativeLibraryEntryPointer.cast(address - offset);
	}

	public NativeLibraryEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public NativeLibraryEntryPointer untag(long mask) {
		return NativeLibraryEntryPointer.cast(address & ~mask);
	}

	public NativeLibraryEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return NativeLibraryEntry.SIZEOF;
	}

	// Implementation methods

	// U64 addressHigh
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_addressHighOffset_", declaredType="U64")
	public UDATA addressHigh() throws CorruptDataException {
		return new U64(getLongAtOffset(NativeLibraryEntry._addressHighOffset_));
	}

	// U64 addressHigh
	public UDATAPointer addressHighEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(NativeLibraryEntry._addressHighOffset_));
	}

	// U64 addressLow
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_addressLowOffset_", declaredType="U64")
	public UDATA addressLow() throws CorruptDataException {
		return new U64(getLongAtOffset(NativeLibraryEntry._addressLowOffset_));
	}

	// U64 addressLow
	public UDATAPointer addressLowEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(NativeLibraryEntry._addressLowOffset_));
	}

	// U8* name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nameOffset_", declaredType="U8*")
	public U8Pointer name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(NativeLibraryEntry._nameOffset_));
	}

	// U8* name
	public PointerPointer nameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(NativeLibraryEntry._nameOffset_));
	}

	// NativeLibraryEntry* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="NativeLibraryEntry*")
	public NativeLibraryEntryPointer next() throws CorruptDataException {
		return NativeLibraryEntryPointer.cast(getPointerAtOffset(NativeLibraryEntry._nextOffset_));
	}

	// NativeLibraryEntry* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(NativeLibraryEntry._nextOffset_));
	}

	// I64 ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
	public IDATA ticks() throws CorruptDataException {
		return new I64(getLongAtOffset(NativeLibraryEntry._ticksOffset_));
	}

	// I64 ticks
	public IDATAPointer ticksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(NativeLibraryEntry._ticksOffset_));
	}

}
