/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: OMRPortPlatformGlobalsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the OMRPortPlatformGlobalsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=OMRPortPlatformGlobals.class)
public class OMRPortPlatformGlobalsPointer extends StructurePointer {

	// NULL
	public static final OMRPortPlatformGlobalsPointer NULL = new OMRPortPlatformGlobalsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected OMRPortPlatformGlobalsPointer(long address) {
		super(address);
	}

	public static OMRPortPlatformGlobalsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static OMRPortPlatformGlobalsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static OMRPortPlatformGlobalsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new OMRPortPlatformGlobalsPointer(address);
	}

	public OMRPortPlatformGlobalsPointer add(long count) {
		return OMRPortPlatformGlobalsPointer.cast(address + (OMRPortPlatformGlobals.SIZEOF * count));
	}

	public OMRPortPlatformGlobalsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public OMRPortPlatformGlobalsPointer addOffset(long offset) {
		return OMRPortPlatformGlobalsPointer.cast(address + offset);
	}

	public OMRPortPlatformGlobalsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public OMRPortPlatformGlobalsPointer sub(long count) {
		return OMRPortPlatformGlobalsPointer.cast(address - (OMRPortPlatformGlobals.SIZEOF * count));
	}

	public OMRPortPlatformGlobalsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public OMRPortPlatformGlobalsPointer subOffset(long offset) {
		return OMRPortPlatformGlobalsPointer.cast(address - offset);
	}

	public OMRPortPlatformGlobalsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public OMRPortPlatformGlobalsPointer untag(long mask) {
		return OMRPortPlatformGlobalsPointer.cast(address & ~mask);
	}

	public OMRPortPlatformGlobalsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return OMRPortPlatformGlobals.SIZEOF;
	}

	// Implementation methods

	// void* GetNumaNodeProcessorMaskExProc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GetNumaNodeProcessorMaskExProcOffset_", declaredType="void*")
	public VoidPointer GetNumaNodeProcessorMaskExProc() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._GetNumaNodeProcessorMaskExProcOffset_));
	}

	// void* GetNumaNodeProcessorMaskExProc
	public PointerPointer GetNumaNodeProcessorMaskExProcEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._GetNumaNodeProcessorMaskExProcOffset_));
	}

	// void* GetThreadIdealProcessorExProc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GetThreadIdealProcessorExProcOffset_", declaredType="void*")
	public VoidPointer GetThreadIdealProcessorExProc() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._GetThreadIdealProcessorExProcOffset_));
	}

	// void* GetThreadIdealProcessorExProc
	public PointerPointer GetThreadIdealProcessorExProcEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._GetThreadIdealProcessorExProcOffset_));
	}

	// void* SetThreadIdealProcessorExProc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SetThreadIdealProcessorExProcOffset_", declaredType="void*")
	public VoidPointer SetThreadIdealProcessorExProc() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._SetThreadIdealProcessorExProcOffset_));
	}

	// void* SetThreadIdealProcessorExProc
	public PointerPointer SetThreadIdealProcessorExProcEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._SetThreadIdealProcessorExProcOffset_));
	}

	// J9ThreadMonitor* bindingAccessMonitor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bindingAccessMonitorOffset_", declaredType="J9ThreadMonitor*")
	public J9ThreadMonitorPointer bindingAccessMonitor() throws CorruptDataException {
		return J9ThreadMonitorPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._bindingAccessMonitorOffset_));
	}

	// J9ThreadMonitor* bindingAccessMonitor
	public PointerPointer bindingAccessMonitorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._bindingAccessMonitorOffset_));
	}

	// J9Pool* bindingPool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bindingPoolOffset_", declaredType="J9Pool*")
	public J9PoolPointer bindingPool() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._bindingPoolOffset_));
	}

	// J9Pool* bindingPool
	public PointerPointer bindingPoolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._bindingPoolOffset_));
	}

	// J9AVLTree bindingTree
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bindingTreeOffset_", declaredType="J9AVLTree")
	public J9AVLTreePointer bindingTree() throws CorruptDataException {
		return J9AVLTreePointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._bindingTreeOffset_));
	}

	// J9AVLTree bindingTree
	public PointerPointer bindingTreeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._bindingTreeOffset_));
	}

	// void* dbgAllocator
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dbgAllocatorOffset_", declaredType="void*")
	public VoidPointer dbgAllocator() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._dbgAllocatorOffset_));
	}

	// void* dbgAllocator
	public PointerPointer dbgAllocatorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._dbgAllocatorOffset_));
	}

	// _dbg_entrypoints* dbgHlpLibraryFunctions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dbgHlpLibraryFunctionsOffset_", declaredType="_dbg_entrypoints*")
	public _dbg_entrypointsPointer dbgHlpLibraryFunctions() throws CorruptDataException {
		return _dbg_entrypointsPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._dbgHlpLibraryFunctionsOffset_));
	}

	// _dbg_entrypoints* dbgHlpLibraryFunctions
	public PointerPointer dbgHlpLibraryFunctionsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._dbgHlpLibraryFunctionsOffset_));
	}

	// void* hLoggingEventSource
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hLoggingEventSourceOffset_", declaredType="void*")
	public VoidPointer hLoggingEventSource() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._hLoggingEventSourceOffset_));
	}

	// void* hLoggingEventSource
	public PointerPointer hLoggingEventSourceEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._hLoggingEventSourceOffset_));
	}

	// U8[] managementCounterPath
	public U8Pointer managementCounterPathEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._managementCounterPathOffset_));
	}

	// U64 managementCounterPathStatus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_managementCounterPathStatusOffset_", declaredType="U64")
	public UDATA managementCounterPathStatus() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRPortPlatformGlobals._managementCounterPathStatusOffset_));
	}

	// U64 managementCounterPathStatus
	public UDATAPointer managementCounterPathStatusEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._managementCounterPathStatusOffset_));
	}

	// _RTL_CRITICAL_SECTION managementDataLock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_managementDataLockOffset_", declaredType="_RTL_CRITICAL_SECTION")
	public _RTL_CRITICAL_SECTIONPointer managementDataLock() throws CorruptDataException {
		return _RTL_CRITICAL_SECTIONPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._managementDataLockOffset_));
	}

	// _RTL_CRITICAL_SECTION managementDataLock
	public PointerPointer managementDataLockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._managementDataLockOffset_));
	}

	// void* mem_heap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mem_heapOffset_", declaredType="void*")
	public VoidPointer mem_heap() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._mem_heapOffset_));
	}

	// void* mem_heap
	public PointerPointer mem_heapEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._mem_heapOffset_));
	}

	// U64 numa_platform_interleave_memory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numa_platform_interleave_memoryOffset_", declaredType="U64")
	public UDATA numa_platform_interleave_memory() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRPortPlatformGlobals._numa_platform_interleave_memoryOffset_));
	}

	// U64 numa_platform_interleave_memory
	public UDATAPointer numa_platform_interleave_memoryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._numa_platform_interleave_memoryOffset_));
	}

	// U64 numa_platform_supports_numa
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numa_platform_supports_numaOffset_", declaredType="U64")
	public UDATA numa_platform_supports_numa() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRPortPlatformGlobals._numa_platform_supports_numaOffset_));
	}

	// U64 numa_platform_supports_numa
	public UDATAPointer numa_platform_supports_numaEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._numa_platform_supports_numaOffset_));
	}

	// void* osBacktrace_Mutex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_osBacktrace_MutexOffset_", declaredType="void*")
	public VoidPointer osBacktrace_Mutex() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._osBacktrace_MutexOffset_));
	}

	// void* osBacktrace_Mutex
	public PointerPointer osBacktrace_MutexEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._osBacktrace_MutexOffset_));
	}

	// _dbg_pdbPath pdbData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pdbDataOffset_", declaredType="_dbg_pdbPath")
	public _dbg_pdbPathPointer pdbData() throws CorruptDataException {
		return _dbg_pdbPathPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._pdbDataOffset_));
	}

	// _dbg_pdbPath pdbData
	public PointerPointer pdbDataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._pdbDataOffset_));
	}

	// U8* si_executableName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_si_executableNameOffset_", declaredType="U8*")
	public U8Pointer si_executableName() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._si_executableNameOffset_));
	}

	// U8* si_executableName
	public PointerPointer si_executableNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._si_executableNameOffset_));
	}

	// U8* si_osType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_si_osTypeOffset_", declaredType="U8*")
	public U8Pointer si_osType() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._si_osTypeOffset_));
	}

	// U8* si_osType
	public PointerPointer si_osTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._si_osTypeOffset_));
	}

	// U8* si_osTypeOnHeap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_si_osTypeOnHeapOffset_", declaredType="U8*")
	public U8Pointer si_osTypeOnHeap() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._si_osTypeOnHeapOffset_));
	}

	// U8* si_osTypeOnHeap
	public PointerPointer si_osTypeOnHeapEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._si_osTypeOnHeapOffset_));
	}

	// U8* si_osVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_si_osVersionOffset_", declaredType="U8*")
	public U8Pointer si_osVersion() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._si_osVersionOffset_));
	}

	// U8* si_osVersion
	public PointerPointer si_osVersionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._si_osVersionOffset_));
	}

	// U8* si_osVersionOnHeap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_si_osVersionOnHeapOffset_", declaredType="U8*")
	public U8Pointer si_osVersionOnHeap() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._si_osVersionOnHeapOffset_));
	}

	// U8* si_osVersionOnHeap
	public PointerPointer si_osVersionOnHeapEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._si_osVersionOnHeapOffset_));
	}

	// J9SubAllocateHeapMem32 subAllocHeapMem32
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_subAllocHeapMem32Offset_", declaredType="J9SubAllocateHeapMem32")
	public J9SubAllocateHeapMem32Pointer subAllocHeapMem32() throws CorruptDataException {
		return J9SubAllocateHeapMem32Pointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._subAllocHeapMem32Offset_));
	}

	// J9SubAllocateHeapMem32 subAllocHeapMem32
	public PointerPointer subAllocHeapMem32EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._subAllocHeapMem32Offset_));
	}

	// U64 systemLoggingFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_systemLoggingFlagsOffset_", declaredType="U64")
	public UDATA systemLoggingFlags() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRPortPlatformGlobals._systemLoggingFlagsOffset_));
	}

	// U64 systemLoggingFlags
	public UDATAPointer systemLoggingFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._systemLoggingFlagsOffset_));
	}

	// U64 time_hiresClockFrequency
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_time_hiresClockFrequencyOffset_", declaredType="U64")
	public UDATA time_hiresClockFrequency() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRPortPlatformGlobals._time_hiresClockFrequencyOffset_));
	}

	// U64 time_hiresClockFrequency
	public UDATAPointer time_hiresClockFrequencyEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._time_hiresClockFrequencyOffset_));
	}

	// J9ThreadMonitor* tty_consoleBufferMonitor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tty_consoleBufferMonitorOffset_", declaredType="J9ThreadMonitor*")
	public J9ThreadMonitorPointer tty_consoleBufferMonitor() throws CorruptDataException {
		return J9ThreadMonitorPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._tty_consoleBufferMonitorOffset_));
	}

	// J9ThreadMonitor* tty_consoleBufferMonitor
	public PointerPointer tty_consoleBufferMonitorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._tty_consoleBufferMonitorOffset_));
	}

	// void* tty_consoleErrorHd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tty_consoleErrorHdOffset_", declaredType="void*")
	public VoidPointer tty_consoleErrorHd() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._tty_consoleErrorHdOffset_));
	}

	// void* tty_consoleErrorHd
	public PointerPointer tty_consoleErrorHdEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._tty_consoleErrorHdOffset_));
	}

	// void* tty_consoleEventBuffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tty_consoleEventBufferOffset_", declaredType="void*")
	public VoidPointer tty_consoleEventBuffer() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._tty_consoleEventBufferOffset_));
	}

	// void* tty_consoleEventBuffer
	public PointerPointer tty_consoleEventBufferEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._tty_consoleEventBufferOffset_));
	}

	// void* tty_consoleInputHd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tty_consoleInputHdOffset_", declaredType="void*")
	public VoidPointer tty_consoleInputHd() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._tty_consoleInputHdOffset_));
	}

	// void* tty_consoleInputHd
	public PointerPointer tty_consoleInputHdEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._tty_consoleInputHdOffset_));
	}

	// void* tty_consoleOutputHd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tty_consoleOutputHdOffset_", declaredType="void*")
	public VoidPointer tty_consoleOutputHd() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(OMRPortPlatformGlobals._tty_consoleOutputHdOffset_));
	}

	// void* tty_consoleOutputHd
	public PointerPointer tty_consoleOutputHdEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._tty_consoleOutputHdOffset_));
	}

	// U64 vmem_initialized
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmem_initializedOffset_", declaredType="U64")
	public UDATA vmem_initialized() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRPortPlatformGlobals._vmem_initializedOffset_));
	}

	// U64 vmem_initialized
	public UDATAPointer vmem_initializedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._vmem_initializedOffset_));
	}

	// U64[] vmem_pageFlags
	public UDATAPointer vmem_pageFlagsEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._vmem_pageFlagsOffset_));
	}

	// U64[] vmem_pageSize
	public UDATAPointer vmem_pageSizeEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(OMRPortPlatformGlobals._vmem_pageSizeOffset_));
	}

}
