/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: StringUTF8EntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the StringUTF8EntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=StringUTF8Entry.class)
public class StringUTF8EntryPointer extends StructurePointer {

	// NULL
	public static final StringUTF8EntryPointer NULL = new StringUTF8EntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected StringUTF8EntryPointer(long address) {
		super(address);
	}

	public static StringUTF8EntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static StringUTF8EntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static StringUTF8EntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new StringUTF8EntryPointer(address);
	}

	public StringUTF8EntryPointer add(long count) {
		return StringUTF8EntryPointer.cast(address + (StringUTF8Entry.SIZEOF * count));
	}

	public StringUTF8EntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public StringUTF8EntryPointer addOffset(long offset) {
		return StringUTF8EntryPointer.cast(address + offset);
	}

	public StringUTF8EntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public StringUTF8EntryPointer sub(long count) {
		return StringUTF8EntryPointer.cast(address - (StringUTF8Entry.SIZEOF * count));
	}

	public StringUTF8EntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public StringUTF8EntryPointer subOffset(long offset) {
		return StringUTF8EntryPointer.cast(address - offset);
	}

	public StringUTF8EntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public StringUTF8EntryPointer untag(long mask) {
		return StringUTF8EntryPointer.cast(address & ~mask);
	}

	public StringUTF8EntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return StringUTF8Entry.SIZEOF;
	}

	// Implementation methods

	// U64 free
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_freeOffset_", declaredType="U64")
	public UDATA free() throws CorruptDataException {
		return new U64(getLongAtOffset(StringUTF8Entry._freeOffset_));
	}

	// U64 free
	public UDATAPointer freeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(StringUTF8Entry._freeOffset_));
	}

	// U32 index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="U32")
	public UDATA index() throws CorruptDataException {
		return new U32(getIntAtOffset(StringUTF8Entry._indexOffset_));
	}

	// U32 index
	public UDATAPointer indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(StringUTF8Entry._indexOffset_));
	}

	// J9UTF8* string
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stringOffset_", declaredType="J9UTF8*")
	public J9UTF8Pointer string() throws CorruptDataException {
		return J9UTF8Pointer.cast(getPointerAtOffset(StringUTF8Entry._stringOffset_));
	}

	// J9UTF8* string
	public PointerPointer stringEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StringUTF8Entry._stringOffset_));
	}

}
