/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT.class)
public class _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer extends StructurePointer {

	// NULL
	public static final _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer NULL = new _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer(long address) {
		super(address);
	}

	public static _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer(address);
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer add(long count) {
		return _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer.cast(address + (_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT.SIZEOF * count));
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer addOffset(long offset) {
		return _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer.cast(address + offset);
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer sub(long count) {
		return _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer.cast(address - (_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT.SIZEOF * count));
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer subOffset(long offset) {
		return _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer.cast(address - offset);
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer untag(long mask) {
		return _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer.cast(address & ~mask);
	}

	public _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUTPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT.SIZEOF;
	}

	// Implementation methods

	// U32 Action
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ActionOffset_", declaredType="U32")
	public UDATA Action() throws CorruptDataException {
		return new U32(getIntAtOffset(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._ActionOffset_));
	}

	// U32 Action
	public UDATAPointer ActionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._ActionOffset_));
	}

	// U32 ExtendedError
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExtendedErrorOffset_", declaredType="U32")
	public UDATA ExtendedError() throws CorruptDataException {
		return new U32(getIntAtOffset(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._ExtendedErrorOffset_));
	}

	// U32 ExtendedError
	public UDATAPointer ExtendedErrorEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._ExtendedErrorOffset_));
	}

	// U32 Flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FlagsOffset_", declaredType="U32")
	public UDATA Flags() throws CorruptDataException {
		return new U32(getIntAtOffset(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._FlagsOffset_));
	}

	// U32 Flags
	public UDATAPointer FlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._FlagsOffset_));
	}

	// U32 OperationStatus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OperationStatusOffset_", declaredType="U32")
	public UDATA OperationStatus() throws CorruptDataException {
		return new U32(getIntAtOffset(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._OperationStatusOffset_));
	}

	// U32 OperationStatus
	public UDATAPointer OperationStatusEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._OperationStatusOffset_));
	}

	// U32 OutputBlockLength
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OutputBlockLengthOffset_", declaredType="U32")
	public UDATA OutputBlockLength() throws CorruptDataException {
		return new U32(getIntAtOffset(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._OutputBlockLengthOffset_));
	}

	// U32 OutputBlockLength
	public UDATAPointer OutputBlockLengthEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._OutputBlockLengthOffset_));
	}

	// U32 OutputBlockOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OutputBlockOffsetOffset_", declaredType="U32")
	public UDATA OutputBlockOffset() throws CorruptDataException {
		return new U32(getIntAtOffset(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._OutputBlockOffsetOffset_));
	}

	// U32 OutputBlockOffset
	public UDATAPointer OutputBlockOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._OutputBlockOffsetOffset_));
	}

	// U32 ReservedStatus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ReservedStatusOffset_", declaredType="U32")
	public UDATA ReservedStatus() throws CorruptDataException {
		return new U32(getIntAtOffset(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._ReservedStatusOffset_));
	}

	// U32 ReservedStatus
	public UDATAPointer ReservedStatusEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._ReservedStatusOffset_));
	}

	// U32 Size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOffset_", declaredType="U32")
	public UDATA Size() throws CorruptDataException {
		return new U32(getIntAtOffset(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._SizeOffset_));
	}

	// U32 Size
	public UDATAPointer SizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._SizeOffset_));
	}

	// U32 TargetDetailedError
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TargetDetailedErrorOffset_", declaredType="U32")
	public UDATA TargetDetailedError() throws CorruptDataException {
		return new U32(getIntAtOffset(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._TargetDetailedErrorOffset_));
	}

	// U32 TargetDetailedError
	public UDATAPointer TargetDetailedErrorEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_DEVICE_MANAGE_DATA_SET_ATTRIBUTES_OUTPUT._TargetDetailedErrorOffset_));
	}

}
