/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _EVENT_DESCRIPTORPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _EVENT_DESCRIPTORPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_EVENT_DESCRIPTOR.class)
public class _EVENT_DESCRIPTORPointer extends StructurePointer {

	// NULL
	public static final _EVENT_DESCRIPTORPointer NULL = new _EVENT_DESCRIPTORPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _EVENT_DESCRIPTORPointer(long address) {
		super(address);
	}

	public static _EVENT_DESCRIPTORPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _EVENT_DESCRIPTORPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _EVENT_DESCRIPTORPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _EVENT_DESCRIPTORPointer(address);
	}

	public _EVENT_DESCRIPTORPointer add(long count) {
		return _EVENT_DESCRIPTORPointer.cast(address + (_EVENT_DESCRIPTOR.SIZEOF * count));
	}

	public _EVENT_DESCRIPTORPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _EVENT_DESCRIPTORPointer addOffset(long offset) {
		return _EVENT_DESCRIPTORPointer.cast(address + offset);
	}

	public _EVENT_DESCRIPTORPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _EVENT_DESCRIPTORPointer sub(long count) {
		return _EVENT_DESCRIPTORPointer.cast(address - (_EVENT_DESCRIPTOR.SIZEOF * count));
	}

	public _EVENT_DESCRIPTORPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _EVENT_DESCRIPTORPointer subOffset(long offset) {
		return _EVENT_DESCRIPTORPointer.cast(address - offset);
	}

	public _EVENT_DESCRIPTORPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _EVENT_DESCRIPTORPointer untag(long mask) {
		return _EVENT_DESCRIPTORPointer.cast(address & ~mask);
	}

	public _EVENT_DESCRIPTORPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _EVENT_DESCRIPTOR.SIZEOF;
	}

	// Implementation methods

	// U8 Channel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ChannelOffset_", declaredType="U8")
	public U8 Channel() throws CorruptDataException {
		return new U8(getByteAtOffset(_EVENT_DESCRIPTOR._ChannelOffset_));
	}

	// U8 Channel
	public U8Pointer ChannelEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_EVENT_DESCRIPTOR._ChannelOffset_));
	}

	// U16 Id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_IdOffset_", declaredType="U16")
	public U16 Id() throws CorruptDataException {
		return new U16(getShortAtOffset(_EVENT_DESCRIPTOR._IdOffset_));
	}

	// U16 Id
	public U16Pointer IdEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_EVENT_DESCRIPTOR._IdOffset_));
	}

	// U64 Keyword
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_KeywordOffset_", declaredType="U64")
	public UDATA Keyword() throws CorruptDataException {
		return new U64(getLongAtOffset(_EVENT_DESCRIPTOR._KeywordOffset_));
	}

	// U64 Keyword
	public UDATAPointer KeywordEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_EVENT_DESCRIPTOR._KeywordOffset_));
	}

	// U8 Level
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LevelOffset_", declaredType="U8")
	public U8 Level() throws CorruptDataException {
		return new U8(getByteAtOffset(_EVENT_DESCRIPTOR._LevelOffset_));
	}

	// U8 Level
	public U8Pointer LevelEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_EVENT_DESCRIPTOR._LevelOffset_));
	}

	// U8 Opcode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OpcodeOffset_", declaredType="U8")
	public U8 Opcode() throws CorruptDataException {
		return new U8(getByteAtOffset(_EVENT_DESCRIPTOR._OpcodeOffset_));
	}

	// U8 Opcode
	public U8Pointer OpcodeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_EVENT_DESCRIPTOR._OpcodeOffset_));
	}

	// U16 Task
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TaskOffset_", declaredType="U16")
	public U16 Task() throws CorruptDataException {
		return new U16(getShortAtOffset(_EVENT_DESCRIPTOR._TaskOffset_));
	}

	// U16 Task
	public U16Pointer TaskEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_EVENT_DESCRIPTOR._TaskOffset_));
	}

	// U8 Version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VersionOffset_", declaredType="U8")
	public U8 Version() throws CorruptDataException {
		return new U8(getByteAtOffset(_EVENT_DESCRIPTOR._VersionOffset_));
	}

	// U8 Version
	public U8Pointer VersionEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_EVENT_DESCRIPTOR._VersionOffset_));
	}

}
