/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _IMAGEHLP_LINE64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _IMAGEHLP_LINE64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_IMAGEHLP_LINE64.class)
public class _IMAGEHLP_LINE64Pointer extends StructurePointer {

	// NULL
	public static final _IMAGEHLP_LINE64Pointer NULL = new _IMAGEHLP_LINE64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _IMAGEHLP_LINE64Pointer(long address) {
		super(address);
	}

	public static _IMAGEHLP_LINE64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _IMAGEHLP_LINE64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _IMAGEHLP_LINE64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _IMAGEHLP_LINE64Pointer(address);
	}

	public _IMAGEHLP_LINE64Pointer add(long count) {
		return _IMAGEHLP_LINE64Pointer.cast(address + (_IMAGEHLP_LINE64.SIZEOF * count));
	}

	public _IMAGEHLP_LINE64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public _IMAGEHLP_LINE64Pointer addOffset(long offset) {
		return _IMAGEHLP_LINE64Pointer.cast(address + offset);
	}

	public _IMAGEHLP_LINE64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _IMAGEHLP_LINE64Pointer sub(long count) {
		return _IMAGEHLP_LINE64Pointer.cast(address - (_IMAGEHLP_LINE64.SIZEOF * count));
	}

	public _IMAGEHLP_LINE64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _IMAGEHLP_LINE64Pointer subOffset(long offset) {
		return _IMAGEHLP_LINE64Pointer.cast(address - offset);
	}

	public _IMAGEHLP_LINE64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _IMAGEHLP_LINE64Pointer untag(long mask) {
		return _IMAGEHLP_LINE64Pointer.cast(address & ~mask);
	}

	public _IMAGEHLP_LINE64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _IMAGEHLP_LINE64.SIZEOF;
	}

	// Implementation methods

	// U64 Address
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AddressOffset_", declaredType="U64")
	public UDATA Address() throws CorruptDataException {
		return new U64(getLongAtOffset(_IMAGEHLP_LINE64._AddressOffset_));
	}

	// U64 Address
	public UDATAPointer AddressEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_LINE64._AddressOffset_));
	}

	// U8* FileName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FileNameOffset_", declaredType="U8*")
	public U8Pointer FileName() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IMAGEHLP_LINE64._FileNameOffset_));
	}

	// U8* FileName
	public PointerPointer FileNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IMAGEHLP_LINE64._FileNameOffset_));
	}

	// void* Key
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_KeyOffset_", declaredType="void*")
	public VoidPointer Key() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_IMAGEHLP_LINE64._KeyOffset_));
	}

	// void* Key
	public PointerPointer KeyEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IMAGEHLP_LINE64._KeyOffset_));
	}

	// U32 LineNumber
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LineNumberOffset_", declaredType="U32")
	public UDATA LineNumber() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_LINE64._LineNumberOffset_));
	}

	// U32 LineNumber
	public UDATAPointer LineNumberEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_LINE64._LineNumberOffset_));
	}

	// U32 SizeOfStruct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfStructOffset_", declaredType="U32")
	public UDATA SizeOfStruct() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGEHLP_LINE64._SizeOfStructOffset_));
	}

	// U32 SizeOfStruct
	public UDATAPointer SizeOfStructEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGEHLP_LINE64._SizeOfStructOffset_));
	}

}
