/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _KDHELP64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _KDHELP64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_KDHELP64.class)
public class _KDHELP64Pointer extends StructurePointer {

	// NULL
	public static final _KDHELP64Pointer NULL = new _KDHELP64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _KDHELP64Pointer(long address) {
		super(address);
	}

	public static _KDHELP64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _KDHELP64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _KDHELP64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _KDHELP64Pointer(address);
	}

	public _KDHELP64Pointer add(long count) {
		return _KDHELP64Pointer.cast(address + (_KDHELP64.SIZEOF * count));
	}

	public _KDHELP64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public _KDHELP64Pointer addOffset(long offset) {
		return _KDHELP64Pointer.cast(address + offset);
	}

	public _KDHELP64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _KDHELP64Pointer sub(long count) {
		return _KDHELP64Pointer.cast(address - (_KDHELP64.SIZEOF * count));
	}

	public _KDHELP64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _KDHELP64Pointer subOffset(long offset) {
		return _KDHELP64Pointer.cast(address - offset);
	}

	public _KDHELP64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _KDHELP64Pointer untag(long mask) {
		return _KDHELP64Pointer.cast(address & ~mask);
	}

	public _KDHELP64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _KDHELP64.SIZEOF;
	}

	// Implementation methods

	// U32 BuildVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_BuildVersionOffset_", declaredType="U32")
	public UDATA BuildVersion() throws CorruptDataException {
		return new U32(getIntAtOffset(_KDHELP64._BuildVersionOffset_));
	}

	// U32 BuildVersion
	public UDATAPointer BuildVersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._BuildVersionOffset_));
	}

	// U32 FramePointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FramePointerOffset_", declaredType="U32")
	public UDATA FramePointer() throws CorruptDataException {
		return new U32(getIntAtOffset(_KDHELP64._FramePointerOffset_));
	}

	// U32 FramePointer
	public UDATAPointer FramePointerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._FramePointerOffset_));
	}

	// U64 KeUserCallbackDispatcher
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_KeUserCallbackDispatcherOffset_", declaredType="U64")
	public UDATA KeUserCallbackDispatcher() throws CorruptDataException {
		return new U64(getLongAtOffset(_KDHELP64._KeUserCallbackDispatcherOffset_));
	}

	// U64 KeUserCallbackDispatcher
	public UDATAPointer KeUserCallbackDispatcherEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._KeUserCallbackDispatcherOffset_));
	}

	// U64 KiCallUserMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_KiCallUserModeOffset_", declaredType="U64")
	public UDATA KiCallUserMode() throws CorruptDataException {
		return new U64(getLongAtOffset(_KDHELP64._KiCallUserModeOffset_));
	}

	// U64 KiCallUserMode
	public UDATAPointer KiCallUserModeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._KiCallUserModeOffset_));
	}

	// U64 KiUserExceptionDispatcher
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_KiUserExceptionDispatcherOffset_", declaredType="U64")
	public UDATA KiUserExceptionDispatcher() throws CorruptDataException {
		return new U64(getLongAtOffset(_KDHELP64._KiUserExceptionDispatcherOffset_));
	}

	// U64 KiUserExceptionDispatcher
	public UDATAPointer KiUserExceptionDispatcherEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._KiUserExceptionDispatcherOffset_));
	}

	// U32 NextCallback
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NextCallbackOffset_", declaredType="U32")
	public UDATA NextCallback() throws CorruptDataException {
		return new U32(getIntAtOffset(_KDHELP64._NextCallbackOffset_));
	}

	// U32 NextCallback
	public UDATAPointer NextCallbackEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._NextCallbackOffset_));
	}

	// U64[] Reserved0
	public UDATAPointer Reserved0EA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(_KDHELP64._Reserved0Offset_));
	}

	// U64 RetpolineStubFunctionTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RetpolineStubFunctionTableOffset_", declaredType="U64")
	public UDATA RetpolineStubFunctionTable() throws CorruptDataException {
		return new U64(getLongAtOffset(_KDHELP64._RetpolineStubFunctionTableOffset_));
	}

	// U64 RetpolineStubFunctionTable
	public UDATAPointer RetpolineStubFunctionTableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._RetpolineStubFunctionTableOffset_));
	}

	// U32 RetpolineStubFunctionTableSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RetpolineStubFunctionTableSizeOffset_", declaredType="U32")
	public UDATA RetpolineStubFunctionTableSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_KDHELP64._RetpolineStubFunctionTableSizeOffset_));
	}

	// U32 RetpolineStubFunctionTableSize
	public UDATAPointer RetpolineStubFunctionTableSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._RetpolineStubFunctionTableSizeOffset_));
	}

	// U32 RetpolineStubOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RetpolineStubOffsetOffset_", declaredType="U32")
	public UDATA RetpolineStubOffset() throws CorruptDataException {
		return new U32(getIntAtOffset(_KDHELP64._RetpolineStubOffsetOffset_));
	}

	// U32 RetpolineStubOffset
	public UDATAPointer RetpolineStubOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._RetpolineStubOffsetOffset_));
	}

	// U32 RetpolineStubSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RetpolineStubSizeOffset_", declaredType="U32")
	public UDATA RetpolineStubSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_KDHELP64._RetpolineStubSizeOffset_));
	}

	// U32 RetpolineStubSize
	public UDATAPointer RetpolineStubSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._RetpolineStubSizeOffset_));
	}

	// U64 StackBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_StackBaseOffset_", declaredType="U64")
	public UDATA StackBase() throws CorruptDataException {
		return new U64(getLongAtOffset(_KDHELP64._StackBaseOffset_));
	}

	// U64 StackBase
	public UDATAPointer StackBaseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._StackBaseOffset_));
	}

	// U64 StackLimit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_StackLimitOffset_", declaredType="U64")
	public UDATA StackLimit() throws CorruptDataException {
		return new U64(getLongAtOffset(_KDHELP64._StackLimitOffset_));
	}

	// U64 StackLimit
	public UDATAPointer StackLimitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._StackLimitOffset_));
	}

	// U64 SystemRangeStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SystemRangeStartOffset_", declaredType="U64")
	public UDATA SystemRangeStart() throws CorruptDataException {
		return new U64(getLongAtOffset(_KDHELP64._SystemRangeStartOffset_));
	}

	// U64 SystemRangeStart
	public UDATAPointer SystemRangeStartEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._SystemRangeStartOffset_));
	}

	// U32 ThCallbackBStore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ThCallbackBStoreOffset_", declaredType="U32")
	public UDATA ThCallbackBStore() throws CorruptDataException {
		return new U32(getIntAtOffset(_KDHELP64._ThCallbackBStoreOffset_));
	}

	// U32 ThCallbackBStore
	public UDATAPointer ThCallbackBStoreEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._ThCallbackBStoreOffset_));
	}

	// U32 ThCallbackStack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ThCallbackStackOffset_", declaredType="U32")
	public UDATA ThCallbackStack() throws CorruptDataException {
		return new U32(getIntAtOffset(_KDHELP64._ThCallbackStackOffset_));
	}

	// U32 ThCallbackStack
	public UDATAPointer ThCallbackStackEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._ThCallbackStackOffset_));
	}

	// U64 Thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ThreadOffset_", declaredType="U64")
	public UDATA Thread() throws CorruptDataException {
		return new U64(getLongAtOffset(_KDHELP64._ThreadOffset_));
	}

	// U64 Thread
	public UDATAPointer ThreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KDHELP64._ThreadOffset_));
	}

}
