/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _MINIDUMP_VM_PRE_READ_CALLBACKPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _MINIDUMP_VM_PRE_READ_CALLBACKPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_MINIDUMP_VM_PRE_READ_CALLBACK.class)
public class _MINIDUMP_VM_PRE_READ_CALLBACKPointer extends StructurePointer {

	// NULL
	public static final _MINIDUMP_VM_PRE_READ_CALLBACKPointer NULL = new _MINIDUMP_VM_PRE_READ_CALLBACKPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _MINIDUMP_VM_PRE_READ_CALLBACKPointer(long address) {
		super(address);
	}

	public static _MINIDUMP_VM_PRE_READ_CALLBACKPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _MINIDUMP_VM_PRE_READ_CALLBACKPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _MINIDUMP_VM_PRE_READ_CALLBACKPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _MINIDUMP_VM_PRE_READ_CALLBACKPointer(address);
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer add(long count) {
		return _MINIDUMP_VM_PRE_READ_CALLBACKPointer.cast(address + (_MINIDUMP_VM_PRE_READ_CALLBACK.SIZEOF * count));
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer addOffset(long offset) {
		return _MINIDUMP_VM_PRE_READ_CALLBACKPointer.cast(address + offset);
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer sub(long count) {
		return _MINIDUMP_VM_PRE_READ_CALLBACKPointer.cast(address - (_MINIDUMP_VM_PRE_READ_CALLBACK.SIZEOF * count));
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer subOffset(long offset) {
		return _MINIDUMP_VM_PRE_READ_CALLBACKPointer.cast(address - offset);
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer untag(long mask) {
		return _MINIDUMP_VM_PRE_READ_CALLBACKPointer.cast(address & ~mask);
	}

	public _MINIDUMP_VM_PRE_READ_CALLBACKPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _MINIDUMP_VM_PRE_READ_CALLBACK.SIZEOF;
	}

	// Implementation methods

	// void* Buffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_BufferOffset_", declaredType="void*")
	public VoidPointer Buffer() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_MINIDUMP_VM_PRE_READ_CALLBACK._BufferOffset_));
	}

	// void* Buffer
	public PointerPointer BufferEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_MINIDUMP_VM_PRE_READ_CALLBACK._BufferOffset_));
	}

	// U64 Offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OffsetOffset_", declaredType="U64")
	public UDATA Offset() throws CorruptDataException {
		return new U64(getLongAtOffset(_MINIDUMP_VM_PRE_READ_CALLBACK._OffsetOffset_));
	}

	// U64 Offset
	public UDATAPointer OffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_VM_PRE_READ_CALLBACK._OffsetOffset_));
	}

	// U32 Size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOffset_", declaredType="U32")
	public UDATA Size() throws CorruptDataException {
		return new U32(getIntAtOffset(_MINIDUMP_VM_PRE_READ_CALLBACK._SizeOffset_));
	}

	// U32 Size
	public UDATAPointer SizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MINIDUMP_VM_PRE_READ_CALLBACK._SizeOffset_));
	}

}
