/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _OVERLAPPEDPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _OVERLAPPEDPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_OVERLAPPED.class)
public class _OVERLAPPEDPointer extends StructurePointer {

	// NULL
	public static final _OVERLAPPEDPointer NULL = new _OVERLAPPEDPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _OVERLAPPEDPointer(long address) {
		super(address);
	}

	public static _OVERLAPPEDPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _OVERLAPPEDPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _OVERLAPPEDPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _OVERLAPPEDPointer(address);
	}

	public _OVERLAPPEDPointer add(long count) {
		return _OVERLAPPEDPointer.cast(address + (_OVERLAPPED.SIZEOF * count));
	}

	public _OVERLAPPEDPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _OVERLAPPEDPointer addOffset(long offset) {
		return _OVERLAPPEDPointer.cast(address + offset);
	}

	public _OVERLAPPEDPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _OVERLAPPEDPointer sub(long count) {
		return _OVERLAPPEDPointer.cast(address - (_OVERLAPPED.SIZEOF * count));
	}

	public _OVERLAPPEDPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _OVERLAPPEDPointer subOffset(long offset) {
		return _OVERLAPPEDPointer.cast(address - offset);
	}

	public _OVERLAPPEDPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _OVERLAPPEDPointer untag(long mask) {
		return _OVERLAPPEDPointer.cast(address & ~mask);
	}

	public _OVERLAPPEDPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _OVERLAPPED.SIZEOF;
	}

	// Implementation methods

	// U64 Internal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_InternalOffset_", declaredType="U64")
	public UDATA Internal() throws CorruptDataException {
		return new U64(getLongAtOffset(_OVERLAPPED._InternalOffset_));
	}

	// U64 Internal
	public UDATAPointer InternalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OVERLAPPED._InternalOffset_));
	}

	// U64 InternalHigh
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_InternalHighOffset_", declaredType="U64")
	public UDATA InternalHigh() throws CorruptDataException {
		return new U64(getLongAtOffset(_OVERLAPPED._InternalHighOffset_));
	}

	// U64 InternalHigh
	public UDATAPointer InternalHighEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OVERLAPPED._InternalHighOffset_));
	}

	// U32 Offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OffsetOffset_", declaredType="U32")
	public UDATA Offset() throws CorruptDataException {
		return new U32(getIntAtOffset(_OVERLAPPED._OffsetOffset_));
	}

	// U32 Offset
	public UDATAPointer OffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OVERLAPPED._OffsetOffset_));
	}

	// U32 OffsetHigh
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OffsetHighOffset_", declaredType="U32")
	public UDATA OffsetHigh() throws CorruptDataException {
		return new U32(getIntAtOffset(_OVERLAPPED._OffsetHighOffset_));
	}

	// U32 OffsetHigh
	public UDATAPointer OffsetHighEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_OVERLAPPED._OffsetHighOffset_));
	}

	// void* Pointer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PointerOffset_", declaredType="void*")
	public VoidPointer Pointer() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_OVERLAPPED._PointerOffset_));
	}

	// void* Pointer
	public PointerPointer PointerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_OVERLAPPED._PointerOffset_));
	}

	// void* hEvent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hEventOffset_", declaredType="void*")
	public VoidPointer hEvent() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_OVERLAPPED._hEventOffset_));
	}

	// void* hEvent
	public PointerPointer hEventEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_OVERLAPPED._hEventOffset_));
	}

}
