/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _PROCESS_MEMORY_COUNTERSPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _PROCESS_MEMORY_COUNTERSPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_PROCESS_MEMORY_COUNTERS.class)
public class _PROCESS_MEMORY_COUNTERSPointer extends StructurePointer {

	// NULL
	public static final _PROCESS_MEMORY_COUNTERSPointer NULL = new _PROCESS_MEMORY_COUNTERSPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _PROCESS_MEMORY_COUNTERSPointer(long address) {
		super(address);
	}

	public static _PROCESS_MEMORY_COUNTERSPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _PROCESS_MEMORY_COUNTERSPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _PROCESS_MEMORY_COUNTERSPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _PROCESS_MEMORY_COUNTERSPointer(address);
	}

	public _PROCESS_MEMORY_COUNTERSPointer add(long count) {
		return _PROCESS_MEMORY_COUNTERSPointer.cast(address + (_PROCESS_MEMORY_COUNTERS.SIZEOF * count));
	}

	public _PROCESS_MEMORY_COUNTERSPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _PROCESS_MEMORY_COUNTERSPointer addOffset(long offset) {
		return _PROCESS_MEMORY_COUNTERSPointer.cast(address + offset);
	}

	public _PROCESS_MEMORY_COUNTERSPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _PROCESS_MEMORY_COUNTERSPointer sub(long count) {
		return _PROCESS_MEMORY_COUNTERSPointer.cast(address - (_PROCESS_MEMORY_COUNTERS.SIZEOF * count));
	}

	public _PROCESS_MEMORY_COUNTERSPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _PROCESS_MEMORY_COUNTERSPointer subOffset(long offset) {
		return _PROCESS_MEMORY_COUNTERSPointer.cast(address - offset);
	}

	public _PROCESS_MEMORY_COUNTERSPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _PROCESS_MEMORY_COUNTERSPointer untag(long mask) {
		return _PROCESS_MEMORY_COUNTERSPointer.cast(address & ~mask);
	}

	public _PROCESS_MEMORY_COUNTERSPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _PROCESS_MEMORY_COUNTERS.SIZEOF;
	}

	// Implementation methods

	// U32 PageFaultCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PageFaultCountOffset_", declaredType="U32")
	public UDATA PageFaultCount() throws CorruptDataException {
		return new U32(getIntAtOffset(_PROCESS_MEMORY_COUNTERS._PageFaultCountOffset_));
	}

	// U32 PageFaultCount
	public UDATAPointer PageFaultCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._PageFaultCountOffset_));
	}

	// U64 PagefileUsage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PagefileUsageOffset_", declaredType="U64")
	public UDATA PagefileUsage() throws CorruptDataException {
		return new U64(getLongAtOffset(_PROCESS_MEMORY_COUNTERS._PagefileUsageOffset_));
	}

	// U64 PagefileUsage
	public UDATAPointer PagefileUsageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._PagefileUsageOffset_));
	}

	// U64 PeakPagefileUsage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PeakPagefileUsageOffset_", declaredType="U64")
	public UDATA PeakPagefileUsage() throws CorruptDataException {
		return new U64(getLongAtOffset(_PROCESS_MEMORY_COUNTERS._PeakPagefileUsageOffset_));
	}

	// U64 PeakPagefileUsage
	public UDATAPointer PeakPagefileUsageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._PeakPagefileUsageOffset_));
	}

	// U64 PeakWorkingSetSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_PeakWorkingSetSizeOffset_", declaredType="U64")
	public UDATA PeakWorkingSetSize() throws CorruptDataException {
		return new U64(getLongAtOffset(_PROCESS_MEMORY_COUNTERS._PeakWorkingSetSizeOffset_));
	}

	// U64 PeakWorkingSetSize
	public UDATAPointer PeakWorkingSetSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._PeakWorkingSetSizeOffset_));
	}

	// U64 QuotaNonPagedPoolUsage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_QuotaNonPagedPoolUsageOffset_", declaredType="U64")
	public UDATA QuotaNonPagedPoolUsage() throws CorruptDataException {
		return new U64(getLongAtOffset(_PROCESS_MEMORY_COUNTERS._QuotaNonPagedPoolUsageOffset_));
	}

	// U64 QuotaNonPagedPoolUsage
	public UDATAPointer QuotaNonPagedPoolUsageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._QuotaNonPagedPoolUsageOffset_));
	}

	// U64 QuotaPagedPoolUsage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_QuotaPagedPoolUsageOffset_", declaredType="U64")
	public UDATA QuotaPagedPoolUsage() throws CorruptDataException {
		return new U64(getLongAtOffset(_PROCESS_MEMORY_COUNTERS._QuotaPagedPoolUsageOffset_));
	}

	// U64 QuotaPagedPoolUsage
	public UDATAPointer QuotaPagedPoolUsageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._QuotaPagedPoolUsageOffset_));
	}

	// U64 QuotaPeakNonPagedPoolUsage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_QuotaPeakNonPagedPoolUsageOffset_", declaredType="U64")
	public UDATA QuotaPeakNonPagedPoolUsage() throws CorruptDataException {
		return new U64(getLongAtOffset(_PROCESS_MEMORY_COUNTERS._QuotaPeakNonPagedPoolUsageOffset_));
	}

	// U64 QuotaPeakNonPagedPoolUsage
	public UDATAPointer QuotaPeakNonPagedPoolUsageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._QuotaPeakNonPagedPoolUsageOffset_));
	}

	// U64 QuotaPeakPagedPoolUsage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_QuotaPeakPagedPoolUsageOffset_", declaredType="U64")
	public UDATA QuotaPeakPagedPoolUsage() throws CorruptDataException {
		return new U64(getLongAtOffset(_PROCESS_MEMORY_COUNTERS._QuotaPeakPagedPoolUsageOffset_));
	}

	// U64 QuotaPeakPagedPoolUsage
	public UDATAPointer QuotaPeakPagedPoolUsageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._QuotaPeakPagedPoolUsageOffset_));
	}

	// U64 WorkingSetSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_WorkingSetSizeOffset_", declaredType="U64")
	public UDATA WorkingSetSize() throws CorruptDataException {
		return new U64(getLongAtOffset(_PROCESS_MEMORY_COUNTERS._WorkingSetSizeOffset_));
	}

	// U64 WorkingSetSize
	public UDATAPointer WorkingSetSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._WorkingSetSizeOffset_));
	}

	// U32 cb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cbOffset_", declaredType="U32")
	public UDATA cb() throws CorruptDataException {
		return new U32(getIntAtOffset(_PROCESS_MEMORY_COUNTERS._cbOffset_));
	}

	// U32 cb
	public UDATAPointer cbEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_PROCESS_MEMORY_COUNTERS._cbOffset_));
	}

}
