/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _SECURITY_DESCRIPTORPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _SECURITY_DESCRIPTORPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_SECURITY_DESCRIPTOR.class)
public class _SECURITY_DESCRIPTORPointer extends StructurePointer {

	// NULL
	public static final _SECURITY_DESCRIPTORPointer NULL = new _SECURITY_DESCRIPTORPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _SECURITY_DESCRIPTORPointer(long address) {
		super(address);
	}

	public static _SECURITY_DESCRIPTORPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _SECURITY_DESCRIPTORPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _SECURITY_DESCRIPTORPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _SECURITY_DESCRIPTORPointer(address);
	}

	public _SECURITY_DESCRIPTORPointer add(long count) {
		return _SECURITY_DESCRIPTORPointer.cast(address + (_SECURITY_DESCRIPTOR.SIZEOF * count));
	}

	public _SECURITY_DESCRIPTORPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _SECURITY_DESCRIPTORPointer addOffset(long offset) {
		return _SECURITY_DESCRIPTORPointer.cast(address + offset);
	}

	public _SECURITY_DESCRIPTORPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _SECURITY_DESCRIPTORPointer sub(long count) {
		return _SECURITY_DESCRIPTORPointer.cast(address - (_SECURITY_DESCRIPTOR.SIZEOF * count));
	}

	public _SECURITY_DESCRIPTORPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _SECURITY_DESCRIPTORPointer subOffset(long offset) {
		return _SECURITY_DESCRIPTORPointer.cast(address - offset);
	}

	public _SECURITY_DESCRIPTORPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _SECURITY_DESCRIPTORPointer untag(long mask) {
		return _SECURITY_DESCRIPTORPointer.cast(address & ~mask);
	}

	public _SECURITY_DESCRIPTORPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _SECURITY_DESCRIPTOR.SIZEOF;
	}

	// Implementation methods

	// U16 Control
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ControlOffset_", declaredType="U16")
	public U16 Control() throws CorruptDataException {
		return new U16(getShortAtOffset(_SECURITY_DESCRIPTOR._ControlOffset_));
	}

	// U16 Control
	public U16Pointer ControlEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_SECURITY_DESCRIPTOR._ControlOffset_));
	}

	// _ACL* Dacl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DaclOffset_", declaredType="_ACL*")
	public _ACLPointer Dacl() throws CorruptDataException {
		return _ACLPointer.cast(getPointerAtOffset(_SECURITY_DESCRIPTOR._DaclOffset_));
	}

	// _ACL* Dacl
	public PointerPointer DaclEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_SECURITY_DESCRIPTOR._DaclOffset_));
	}

	// void* Group
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GroupOffset_", declaredType="void*")
	public VoidPointer Group() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_SECURITY_DESCRIPTOR._GroupOffset_));
	}

	// void* Group
	public PointerPointer GroupEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_SECURITY_DESCRIPTOR._GroupOffset_));
	}

	// void* Owner
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OwnerOffset_", declaredType="void*")
	public VoidPointer Owner() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_SECURITY_DESCRIPTOR._OwnerOffset_));
	}

	// void* Owner
	public PointerPointer OwnerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_SECURITY_DESCRIPTOR._OwnerOffset_));
	}

	// U8 Revision
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RevisionOffset_", declaredType="U8")
	public U8 Revision() throws CorruptDataException {
		return new U8(getByteAtOffset(_SECURITY_DESCRIPTOR._RevisionOffset_));
	}

	// U8 Revision
	public U8Pointer RevisionEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_SECURITY_DESCRIPTOR._RevisionOffset_));
	}

	// _ACL* Sacl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SaclOffset_", declaredType="_ACL*")
	public _ACLPointer Sacl() throws CorruptDataException {
		return _ACLPointer.cast(getPointerAtOffset(_SECURITY_DESCRIPTOR._SaclOffset_));
	}

	// _ACL* Sacl
	public PointerPointer SaclEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_SECURITY_DESCRIPTOR._SaclOffset_));
	}

	// U8 Sbz1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Sbz1Offset_", declaredType="U8")
	public U8 Sbz1() throws CorruptDataException {
		return new U8(getByteAtOffset(_SECURITY_DESCRIPTOR._Sbz1Offset_));
	}

	// U8 Sbz1
	public U8Pointer Sbz1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_SECURITY_DESCRIPTOR._Sbz1Offset_));
	}

}
