/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _SYSTEM_INFOPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _SYSTEM_INFOPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_SYSTEM_INFO.class)
public class _SYSTEM_INFOPointer extends StructurePointer {

	// NULL
	public static final _SYSTEM_INFOPointer NULL = new _SYSTEM_INFOPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _SYSTEM_INFOPointer(long address) {
		super(address);
	}

	public static _SYSTEM_INFOPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _SYSTEM_INFOPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _SYSTEM_INFOPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _SYSTEM_INFOPointer(address);
	}

	public _SYSTEM_INFOPointer add(long count) {
		return _SYSTEM_INFOPointer.cast(address + (_SYSTEM_INFO.SIZEOF * count));
	}

	public _SYSTEM_INFOPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _SYSTEM_INFOPointer addOffset(long offset) {
		return _SYSTEM_INFOPointer.cast(address + offset);
	}

	public _SYSTEM_INFOPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _SYSTEM_INFOPointer sub(long count) {
		return _SYSTEM_INFOPointer.cast(address - (_SYSTEM_INFO.SIZEOF * count));
	}

	public _SYSTEM_INFOPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _SYSTEM_INFOPointer subOffset(long offset) {
		return _SYSTEM_INFOPointer.cast(address - offset);
	}

	public _SYSTEM_INFOPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _SYSTEM_INFOPointer untag(long mask) {
		return _SYSTEM_INFOPointer.cast(address & ~mask);
	}

	public _SYSTEM_INFOPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _SYSTEM_INFO.SIZEOF;
	}

	// Implementation methods

	// U64 dwActiveProcessorMask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwActiveProcessorMaskOffset_", declaredType="U64")
	public UDATA dwActiveProcessorMask() throws CorruptDataException {
		return new U64(getLongAtOffset(_SYSTEM_INFO._dwActiveProcessorMaskOffset_));
	}

	// U64 dwActiveProcessorMask
	public UDATAPointer dwActiveProcessorMaskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYSTEM_INFO._dwActiveProcessorMaskOffset_));
	}

	// U32 dwAllocationGranularity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwAllocationGranularityOffset_", declaredType="U32")
	public UDATA dwAllocationGranularity() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYSTEM_INFO._dwAllocationGranularityOffset_));
	}

	// U32 dwAllocationGranularity
	public UDATAPointer dwAllocationGranularityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYSTEM_INFO._dwAllocationGranularityOffset_));
	}

	// U32 dwNumberOfProcessors
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwNumberOfProcessorsOffset_", declaredType="U32")
	public UDATA dwNumberOfProcessors() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYSTEM_INFO._dwNumberOfProcessorsOffset_));
	}

	// U32 dwNumberOfProcessors
	public UDATAPointer dwNumberOfProcessorsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYSTEM_INFO._dwNumberOfProcessorsOffset_));
	}

	// U32 dwOemId
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwOemIdOffset_", declaredType="U32")
	public UDATA dwOemId() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYSTEM_INFO._dwOemIdOffset_));
	}

	// U32 dwOemId
	public UDATAPointer dwOemIdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYSTEM_INFO._dwOemIdOffset_));
	}

	// U32 dwPageSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwPageSizeOffset_", declaredType="U32")
	public UDATA dwPageSize() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYSTEM_INFO._dwPageSizeOffset_));
	}

	// U32 dwPageSize
	public UDATAPointer dwPageSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYSTEM_INFO._dwPageSizeOffset_));
	}

	// U32 dwProcessorType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwProcessorTypeOffset_", declaredType="U32")
	public UDATA dwProcessorType() throws CorruptDataException {
		return new U32(getIntAtOffset(_SYSTEM_INFO._dwProcessorTypeOffset_));
	}

	// U32 dwProcessorType
	public UDATAPointer dwProcessorTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYSTEM_INFO._dwProcessorTypeOffset_));
	}

	// void* lpMaximumApplicationAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpMaximumApplicationAddressOffset_", declaredType="void*")
	public VoidPointer lpMaximumApplicationAddress() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_SYSTEM_INFO._lpMaximumApplicationAddressOffset_));
	}

	// void* lpMaximumApplicationAddress
	public PointerPointer lpMaximumApplicationAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_SYSTEM_INFO._lpMaximumApplicationAddressOffset_));
	}

	// void* lpMinimumApplicationAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpMinimumApplicationAddressOffset_", declaredType="void*")
	public VoidPointer lpMinimumApplicationAddress() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_SYSTEM_INFO._lpMinimumApplicationAddressOffset_));
	}

	// void* lpMinimumApplicationAddress
	public PointerPointer lpMinimumApplicationAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_SYSTEM_INFO._lpMinimumApplicationAddressOffset_));
	}

	// U16 wProcessorArchitecture
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wProcessorArchitectureOffset_", declaredType="U16")
	public U16 wProcessorArchitecture() throws CorruptDataException {
		return new U16(getShortAtOffset(_SYSTEM_INFO._wProcessorArchitectureOffset_));
	}

	// U16 wProcessorArchitecture
	public U16Pointer wProcessorArchitectureEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_SYSTEM_INFO._wProcessorArchitectureOffset_));
	}

	// U16 wProcessorLevel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wProcessorLevelOffset_", declaredType="U16")
	public U16 wProcessorLevel() throws CorruptDataException {
		return new U16(getShortAtOffset(_SYSTEM_INFO._wProcessorLevelOffset_));
	}

	// U16 wProcessorLevel
	public U16Pointer wProcessorLevelEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_SYSTEM_INFO._wProcessorLevelOffset_));
	}

	// U16 wProcessorRevision
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wProcessorRevisionOffset_", declaredType="U16")
	public U16 wProcessorRevision() throws CorruptDataException {
		return new U16(getShortAtOffset(_SYSTEM_INFO._wProcessorRevisionOffset_));
	}

	// U16 wProcessorRevision
	public U16Pointer wProcessorRevisionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_SYSTEM_INFO._wProcessorRevisionOffset_));
	}

	// U16 wReserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReservedOffset_", declaredType="U16")
	public U16 wReserved() throws CorruptDataException {
		return new U16(getShortAtOffset(_SYSTEM_INFO._wReservedOffset_));
	}

	// U16 wReserved
	public U16Pointer wReservedEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_SYSTEM_INFO._wReservedOffset_));
	}

}
