/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_SYSTEM_LOGICAL_PROCESSOR_INFORMATION.class)
public class _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer extends StructurePointer {

	// NULL
	public static final _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer NULL = new _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer(long address) {
		super(address);
	}

	public static _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer(address);
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer add(long count) {
		return _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer.cast(address + (_SYSTEM_LOGICAL_PROCESSOR_INFORMATION.SIZEOF * count));
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer addOffset(long offset) {
		return _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer.cast(address + offset);
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer sub(long count) {
		return _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer.cast(address - (_SYSTEM_LOGICAL_PROCESSOR_INFORMATION.SIZEOF * count));
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer subOffset(long offset) {
		return _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer.cast(address - offset);
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer untag(long mask) {
		return _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer.cast(address & ~mask);
	}

	public _SYSTEM_LOGICAL_PROCESSOR_INFORMATIONPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _SYSTEM_LOGICAL_PROCESSOR_INFORMATION.SIZEOF;
	}

	// Implementation methods

	// _CACHE_DESCRIPTOR Cache
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CacheOffset_", declaredType="_CACHE_DESCRIPTOR")
	public _CACHE_DESCRIPTORPointer Cache() throws CorruptDataException {
		return _CACHE_DESCRIPTORPointer.cast(nonNullFieldEA(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._CacheOffset_));
	}

	// _CACHE_DESCRIPTOR Cache
	public PointerPointer CacheEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._CacheOffset_));
	}

	// void NumaNode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NumaNodeOffset_", declaredType="void")
	public VoidPointer NumaNode() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._NumaNodeOffset_));
	}

	// void NumaNode
	public PointerPointer NumaNodeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._NumaNodeOffset_));
	}

	// void ProcessorCore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProcessorCoreOffset_", declaredType="void")
	public VoidPointer ProcessorCore() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._ProcessorCoreOffset_));
	}

	// void ProcessorCore
	public PointerPointer ProcessorCoreEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._ProcessorCoreOffset_));
	}

	// U64 ProcessorMask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProcessorMaskOffset_", declaredType="U64")
	public UDATA ProcessorMask() throws CorruptDataException {
		return new U64(getLongAtOffset(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._ProcessorMaskOffset_));
	}

	// U64 ProcessorMask
	public UDATAPointer ProcessorMaskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._ProcessorMaskOffset_));
	}

	// _LOGICAL_PROCESSOR_RELATIONSHIP Relationship
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RelationshipOffset_", declaredType="_LOGICAL_PROCESSOR_RELATIONSHIP")
	public long Relationship() throws CorruptDataException {
		if (_LOGICAL_PROCESSOR_RELATIONSHIP.SIZEOF == 1) {
			return getByteAtOffset(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._RelationshipOffset_);
		} else if (_LOGICAL_PROCESSOR_RELATIONSHIP.SIZEOF == 2) {
			return getShortAtOffset(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._RelationshipOffset_);
		} else if (_LOGICAL_PROCESSOR_RELATIONSHIP.SIZEOF == 4) {
			return getIntAtOffset(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._RelationshipOffset_);
		} else if (_LOGICAL_PROCESSOR_RELATIONSHIP.SIZEOF == 8) {
			return getLongAtOffset(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._RelationshipOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// _LOGICAL_PROCESSOR_RELATIONSHIP Relationship
	public EnumPointer RelationshipEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._RelationshipOffset_), _LOGICAL_PROCESSOR_RELATIONSHIP.class);
	}

	// U64[] Reserved
	public UDATAPointer ReservedEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(_SYSTEM_LOGICAL_PROCESSOR_INFORMATION._ReservedOffset_));
	}

}
