/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __crt_locale_data_publicPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __crt_locale_data_publicPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__crt_locale_data_public.class)
public class __crt_locale_data_publicPointer extends StructurePointer {

	// NULL
	public static final __crt_locale_data_publicPointer NULL = new __crt_locale_data_publicPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __crt_locale_data_publicPointer(long address) {
		super(address);
	}

	public static __crt_locale_data_publicPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __crt_locale_data_publicPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __crt_locale_data_publicPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __crt_locale_data_publicPointer(address);
	}

	public __crt_locale_data_publicPointer add(long count) {
		return __crt_locale_data_publicPointer.cast(address + (__crt_locale_data_public.SIZEOF * count));
	}

	public __crt_locale_data_publicPointer add(Scalar count) {
		return add(count.longValue());
	}

	public __crt_locale_data_publicPointer addOffset(long offset) {
		return __crt_locale_data_publicPointer.cast(address + offset);
	}

	public __crt_locale_data_publicPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __crt_locale_data_publicPointer sub(long count) {
		return __crt_locale_data_publicPointer.cast(address - (__crt_locale_data_public.SIZEOF * count));
	}

	public __crt_locale_data_publicPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __crt_locale_data_publicPointer subOffset(long offset) {
		return __crt_locale_data_publicPointer.cast(address - offset);
	}

	public __crt_locale_data_publicPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __crt_locale_data_publicPointer untag(long mask) {
		return __crt_locale_data_publicPointer.cast(address & ~mask);
	}

	public __crt_locale_data_publicPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __crt_locale_data_public.SIZEOF;
	}

	// Implementation methods

	// U32 _locale_lc_codepage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__locale_lc_codepageOffset_", declaredType="U32")
	public UDATA _locale_lc_codepage() throws CorruptDataException {
		return new U32(getIntAtOffset(__crt_locale_data_public.__locale_lc_codepageOffset_));
	}

	// U32 _locale_lc_codepage
	public UDATAPointer _locale_lc_codepageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__crt_locale_data_public.__locale_lc_codepageOffset_));
	}

	// I32 _locale_mb_cur_max
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__locale_mb_cur_maxOffset_", declaredType="I32")
	public IDATA _locale_mb_cur_max() throws CorruptDataException {
		return new I32(getIntAtOffset(__crt_locale_data_public.__locale_mb_cur_maxOffset_));
	}

	// I32 _locale_mb_cur_max
	public IDATAPointer _locale_mb_cur_maxEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__crt_locale_data_public.__locale_mb_cur_maxOffset_));
	}

	// const U16* _locale_pctype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__locale_pctypeOffset_", declaredType="const U16*")
	public U16Pointer _locale_pctype() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(__crt_locale_data_public.__locale_pctypeOffset_));
	}

	// const U16* _locale_pctype
	public PointerPointer _locale_pctypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__crt_locale_data_public.__locale_pctypeOffset_));
	}

}
